/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.util;

import com.sleepycat.bind.tuple.LongBinding;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.OperationStatus;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.crawler.util.SetBasedUriUniqFilter;
import org.archive.settings.file.BdbModule;
import org.archive.state.Immutable;
import org.archive.state.Initializable;
import org.archive.state.Key;
import org.archive.state.KeyManager;
import org.archive.state.StateProvider;
import st.ata.util.FPGenerator;

public class BdbUriUniqFilter
extends SetBasedUriUniqFilter
implements Initializable,
Serializable {
    private static final long serialVersionUID = -8099357538178524011L;
    private static Logger logger = Logger.getLogger(BdbUriUniqFilter.class.getName());
    protected boolean createdEnvironment = false;
    protected long lastCacheMiss = 0L;
    protected long lastCacheMissDiff = 0L;
    protected transient Database alreadySeen = null;
    protected transient DatabaseEntry value = null;
    protected static DatabaseEntry ZERO_LENGTH_ENTRY = new DatabaseEntry(new byte[0]);
    private static final String DB_NAME = "alreadySeenUrl";
    protected long count = 0L;
    private long aggregatedLookupTime = 0L;
    private static final String COLON_SLASH_SLASH = "://";
    @Immutable
    public static final Key<BdbModule> BDB = Key.makeAuto(BdbModule.class);
    private BdbModule bdb;

    public BdbUriUniqFilter() {
    }

    public void initialTasks(StateProvider provider) {
        this.bdb = (BdbModule)provider.get((Object)this, BDB);
        try {
            BdbModule.BdbConfig config = this.getDatabaseConfig();
            config.setAllowCreate(true);
            this.initialize(this.bdb.openDatabase(DB_NAME, config, false));
        }
        catch (DatabaseException e) {
            throw new IllegalStateException(e);
        }
    }

    public BdbUriUniqFilter(File bdbEnv) throws IOException {
        this(bdbEnv, -1);
    }

    public BdbUriUniqFilter(File bdbEnv, int cacheSizePercentage) throws IOException {
        if (!bdbEnv.exists()) {
            bdbEnv.mkdirs();
        }
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setAllowCreate(true);
        if (cacheSizePercentage > 0 && cacheSizePercentage < 100) {
            envConfig.setCachePercent(cacheSizePercentage);
        }
        try {
            this.createdEnvironment = true;
            Environment env = new Environment(bdbEnv, envConfig);
            BdbModule.BdbConfig config = this.getDatabaseConfig();
            config.setAllowCreate(true);
            try {
                env.truncateDatabase(null, DB_NAME, false);
            }
            catch (DatabaseNotFoundException e) {
                // empty catch block
            }
            Database db = env.openDatabase(null, DB_NAME, config.toDatabaseConfig());
            this.initialize(db);
        }
        catch (DatabaseException e) {
            IOException io = new IOException();
            io.initCause(e);
            throw io;
        }
    }

    protected void initialize(Database db) throws DatabaseException {
        this.open(db);
    }

    protected BdbModule.BdbConfig getDatabaseConfig() {
        BdbModule.BdbConfig dbConfig = new BdbModule.BdbConfig();
        return dbConfig;
    }

    public void reopen(Database db) throws DatabaseException {
        this.open(db);
    }

    protected void open(Database db) throws DatabaseException {
        this.alreadySeen = db;
        this.value = new DatabaseEntry("".getBytes());
    }

    public synchronized void close() {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Count of alreadyseen on close " + Long.toString(this.count));
        }
        if (this.createdEnvironment) {
            Environment env = null;
            if (this.alreadySeen != null) {
                try {
                    env = this.alreadySeen.getEnvironment();
                    this.alreadySeen.sync();
                    this.alreadySeen.close();
                }
                catch (DatabaseException e) {
                    logger.severe(e.getMessage());
                }
                this.alreadySeen = null;
            }
            if (env != null) {
                try {
                    env.sync();
                    env.close();
                }
                catch (DatabaseException e) {
                    logger.severe(e.getMessage());
                }
            }
        }
    }

    public synchronized long getCacheMisses() throws DatabaseException {
        long cacheMiss = this.alreadySeen.getEnvironment().getStats(null).getNCacheMiss();
        this.lastCacheMissDiff = cacheMiss - this.lastCacheMiss;
        this.lastCacheMiss = cacheMiss;
        return this.lastCacheMiss;
    }

    public long getLastCacheMissDiff() {
        return this.lastCacheMissDiff;
    }

    public static long createKey(CharSequence uri) {
        String url = ((Object)uri).toString();
        int index = url.indexOf(COLON_SLASH_SLASH);
        if (index > 0) {
            index = url.indexOf(47, index + COLON_SLASH_SLASH.length());
        }
        String hostPlusScheme = index == -1 ? url : url.subSequence(0, index);
        long tmp = FPGenerator.std24.fp((CharSequence)hostPlusScheme);
        return tmp | FPGenerator.std40.fp((CharSequence)url) >>> 24;
    }

    protected boolean setAdd(CharSequence uri) {
        DatabaseEntry key = new DatabaseEntry();
        LongBinding.longToEntry((long)BdbUriUniqFilter.createKey(uri), (DatabaseEntry)key);
        long started = 0L;
        OperationStatus status = null;
        try {
            if (logger.isLoggable(Level.INFO)) {
                started = System.currentTimeMillis();
            }
            status = this.alreadySeen.putNoOverwrite(null, key, ZERO_LENGTH_ENTRY);
            if (logger.isLoggable(Level.INFO)) {
                this.aggregatedLookupTime += System.currentTimeMillis() - started;
            }
        }
        catch (DatabaseException e) {
            logger.severe(e.getMessage());
        }
        if (status == OperationStatus.SUCCESS) {
            ++this.count;
            if (logger.isLoggable(Level.INFO)) {
                int logAt = 10000;
                if (this.count > 0L && this.count % 10000L == 0L) {
                    logger.info("Average lookup " + this.aggregatedLookupTime / 10000L + "ms.");
                    this.aggregatedLookupTime = 0L;
                }
            }
        }
        return status != OperationStatus.KEYEXIST;
    }

    protected long setCount() {
        return this.count;
    }

    protected boolean setRemove(CharSequence uri) {
        DatabaseEntry key = new DatabaseEntry();
        LongBinding.longToEntry((long)BdbUriUniqFilter.createKey(uri), (DatabaseEntry)key);
        OperationStatus status = null;
        try {
            status = this.alreadySeen.delete(null, key);
        }
        catch (DatabaseException e) {
            logger.severe(e.getMessage());
        }
        if (status == OperationStatus.SUCCESS) {
            --this.count;
            return true;
        }
        return false;
    }

    public long flush() {
        return 0L;
    }

    private void writeObject(ObjectOutputStream output) throws IOException {
        try {
            this.alreadySeen.sync();
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
        output.defaultWriteObject();
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        try {
            BdbModule.BdbConfig config = this.getDatabaseConfig();
            config.setAllowCreate(false);
            this.reopen(this.bdb.getDatabase(DB_NAME));
        }
        catch (DatabaseException e) {
            IOException io = new IOException();
            io.initCause(e);
            throw io;
        }
    }

    static {
        KeyManager.addKeys(BdbUriUniqFilter.class);
    }
}

