/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.archive.crawler.datamodel.CrawlURI;
import org.archive.crawler.datamodel.UriUniqFilter;
import org.archive.crawler.util.BdbUriUniqFilter;
import org.archive.crawler.util.BloomUriUniqFilter;
import org.archive.crawler.util.FPUriUniqFilter;
import org.archive.crawler.util.MemUriUniqFilter;
import org.archive.crawler.util.SetBasedUriUniqFilter;
import org.archive.util.fingerprint.LongFPSet;
import org.archive.util.fingerprint.MemLongFPSet;

public class BenchmarkUriUniqFilters
implements UriUniqFilter.CrawlUriReceiver {
    private BufferedWriter out;
    String current;

    public static void main(String[] args) throws IOException {
        new BenchmarkUriUniqFilters().instanceMain(args);
    }

    public void instanceMain(String[] args) throws IOException {
        String testClass = args[0];
        String inputFilename = args[1];
        long start = System.currentTimeMillis();
        UriUniqFilter uniq = this.createUriUniqFilter(testClass);
        long created = System.currentTimeMillis();
        BufferedReader br = new BufferedReader(new FileReader(inputFilename));
        if (args.length > 2) {
            String outputFilename = args[2];
            this.out = new BufferedWriter(new FileWriter(outputFilename));
        }
        int added = 0;
        while ((this.current = br.readLine()) != null) {
            ++added;
            uniq.add(this.current, null);
        }
        uniq.close();
        long finished = System.currentTimeMillis();
        if (this.out != null) {
            this.out.close();
        }
        System.out.println(added + " adds");
        System.out.println(uniq.count() + " retained");
        System.out.println(created - start + "ms to setup UUF");
        System.out.println(finished - created + "ms to perform all adds");
    }

    private UriUniqFilter createUriUniqFilter(String testClass) throws IOException {
        SetBasedUriUniqFilter uniq = null;
        if (BdbUriUniqFilter.class.getName().endsWith(testClass)) {
            File tmpDir = File.createTempFile("uuf", "benchmark");
            tmpDir.delete();
            tmpDir.mkdir();
            uniq = new BdbUriUniqFilter(tmpDir, 50);
        } else if (BloomUriUniqFilter.class.getName().endsWith(testClass)) {
            uniq = new BloomUriUniqFilter();
        } else if (MemUriUniqFilter.class.getName().endsWith(testClass)) {
            uniq = new MemUriUniqFilter();
        } else if (FPUriUniqFilter.class.getName().endsWith(testClass)) {
            uniq = new FPUriUniqFilter((LongFPSet)new MemLongFPSet(21, 0.75f));
        }
        uniq.setDestination(this);
        return uniq;
    }

    public void receive(CrawlURI item) {
        if (this.out != null) {
            try {
                this.out.write(this.current);
                this.out.write("\n");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

