/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.util;

import java.io.Serializable;
import java.util.logging.Logger;
import org.archive.crawler.datamodel.CrawlURI;
import org.archive.crawler.util.SetBasedUriUniqFilter;
import org.archive.util.BloomFilter;
import org.archive.util.BloomFilter32bitSplit;

public class BloomUriUniqFilter
extends SetBasedUriUniqFilter
implements Serializable {
    private static final long serialVersionUID = 1061526253773091309L;
    private static Logger LOGGER = Logger.getLogger(BloomUriUniqFilter.class.getName());
    BloomFilter bloom;
    protected int expected_n;
    protected static final String EXPECTED_SIZE_KEY = ".expected-size";
    protected static final String HASH_COUNT_KEY = ".hash-count";
    private static final int DEFAULT_EXPECTED_SIZE = 125000000;
    private static final int DEFAULT_HASH_COUNT = 22;

    public BloomUriUniqFilter() {
        String ns = System.getProperty(this.getClass().getName() + EXPECTED_SIZE_KEY);
        int n = ns == null ? 125000000 : Integer.parseInt(ns);
        String ds = System.getProperty(this.getClass().getName() + HASH_COUNT_KEY);
        int d = ds == null ? 22 : Integer.parseInt(ds);
        this.initialize(n, d);
    }

    public BloomUriUniqFilter(int n, int d) {
        this.initialize(n, d);
    }

    protected void initialize(int n, int d) {
        this.expected_n = n;
        this.bloom = new BloomFilter32bitSplit(n, d);
    }

    public void forget(String canonical, CrawlURI item) {
        LOGGER.severe("forget(\"" + canonical + "\",CrawlURI) not supported");
    }

    protected boolean setAdd(CharSequence uri) {
        boolean added = this.bloom.add(uri);
        if (added && this.count() == (long)this.expected_n) {
            LOGGER.warning("Bloom has reached expected limit " + this.expected_n);
        }
        return added;
    }

    protected long setCount() {
        return this.bloom.size();
    }

    protected boolean setRemove(CharSequence uri) {
        throw new UnsupportedOperationException();
    }
}

