/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckpointUtils {
    public static final String SERIALIZED_CLASS_SUFFIX = ".serialized";

    public static File getBdbSubDirectory(File checkpointDir) {
        return new File(checkpointDir, "bdbje-logs");
    }

    public static File getClassCheckpointFile(File checkpointDir, String suffix, Class c) {
        return new File(checkpointDir, CheckpointUtils.getClassCheckpointFilename(c, suffix));
    }

    public static File getClassCheckpointFile(File checkpointDir, Class c) {
        return new File(checkpointDir, CheckpointUtils.getClassCheckpointFilename(c, null));
    }

    public static String getClassCheckpointFilename(Class c) {
        return CheckpointUtils.getClassCheckpointFilename(c, null);
    }

    public static String getClassCheckpointFilename(Class c, String suffix) {
        return c.getName() + (suffix == null ? "" : "." + suffix) + SERIALIZED_CLASS_SUFFIX;
    }

    public static void writeObjectToFile(Object o, File dir) throws IOException {
        CheckpointUtils.writeObjectToFile(o, null, dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeObjectToFile(Object o, String suffix, File dir) throws IOException {
        dir.mkdirs();
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(CheckpointUtils.getClassCheckpointFile(dir, suffix, o.getClass())));
        try {
            out.writeObject(o);
        }
        finally {
            out.close();
        }
    }

    public static <T> T readObjectFromFile(Class<T> c, File dir) throws FileNotFoundException, IOException, ClassNotFoundException {
        return CheckpointUtils.readObjectFromFile(c, null, dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T readObjectFromFile(Class<T> c, String suffix, File dir) throws FileNotFoundException, IOException, ClassNotFoundException {
        ObjectInputStream in = new ObjectInputStream(new FileInputStream(CheckpointUtils.getClassCheckpointFile(dir, suffix, c)));
        T o = null;
        try {
            o = c.cast(in.readObject());
        }
        finally {
            in.close();
        }
        return o;
    }

    public static FilenameFilter getJeLogsFilter() {
        return new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name != null && name.toLowerCase().endsWith(".jdb");
            }
        };
    }
}

