/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.util;

import org.archive.crawler.datamodel.CoreAttributeConstants;
import org.archive.crawler.datamodel.CrawlURI;
import org.archive.modules.ProcessorURI;
import org.archive.modules.deciderules.recrawl.IdenticalDigestDecideRule;
import org.archive.util.Accumulator;
import org.archive.util.ArchiveUtils;
import org.archive.util.Histotable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrawledBytesHistotable
extends Histotable<String>
implements Accumulator<CrawlURI>,
CoreAttributeConstants {
    private static final long serialVersionUID = 7923431123239026213L;
    public static final String NOTMODIFIED = "not-modified";
    public static final String DUPLICATE = "dup-by-hash";
    public static final String NOVEL = "novel";

    public void accumulate(CrawlURI curi) {
        if (curi.getFetchStatus() == 304) {
            this.tally(NOTMODIFIED, curi.getContentSize());
        } else if (IdenticalDigestDecideRule.hasIdenticalDigest((ProcessorURI)curi)) {
            this.tally(DUPLICATE, curi.getContentSize());
        } else {
            this.tally(NOVEL, curi.getContentSize());
        }
    }

    public String summary() {
        StringBuilder sb = new StringBuilder();
        sb.append(ArchiveUtils.formatBytesForDisplay((long)this.getTotal()));
        sb.append(" crawled (");
        sb.append(ArchiveUtils.formatBytesForDisplay((long)this.get(NOVEL)));
        sb.append(" novel");
        if (this.get(DUPLICATE) != null) {
            sb.append(", ");
            sb.append(ArchiveUtils.formatBytesForDisplay((long)this.get(DUPLICATE)));
            sb.append(" ");
            sb.append(DUPLICATE);
        }
        if (this.get(NOTMODIFIED) != null) {
            sb.append(", ");
            sb.append(ArchiveUtils.formatBytesForDisplay((long)this.get(NOTMODIFIED)));
            sb.append(" ");
            sb.append(NOTMODIFIED);
        }
        sb.append(")");
        return sb.toString();
    }
}

