/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.util;

import it.unimi.dsi.fastutil.longs.LongIterator;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.crawler.datamodel.CrawlURI;
import org.archive.crawler.datamodel.UriUniqFilter;
import org.archive.util.fingerprint.ArrayLongFPCache;
import st.ata.util.FPGenerator;

public abstract class FPMergeUriUniqFilter
implements UriUniqFilter {
    private static Logger LOGGER = Logger.getLogger(FPMergeUriUniqFilter.class.getName());
    protected UriUniqFilter.CrawlUriReceiver receiver;
    protected PrintWriter profileLog;
    protected long quickDuplicateCount = 0L;
    protected long quickDupAtLast = 0L;
    protected long pendDuplicateCount = 0L;
    protected long pendDupAtLast = 0L;
    protected long mergeDuplicateCount = 0L;
    protected long mergeDupAtLast = 0L;
    protected TreeSet<PendingItem> pendingSet = new TreeSet();
    protected int maxPending = 10000;
    public static final int DEFAULT_MAX_PENDING = 10000;
    protected long nextFlushAllowableAfter = 0L;
    public static final long FLUSH_DELAY_FACTOR = 100L;
    protected ArrayLongFPCache quickCache = new ArrayLongFPCache();

    public FPMergeUriUniqFilter() {
        String profileLogFile = System.getProperty(FPMergeUriUniqFilter.class.getName() + ".profileLogFile");
        if (profileLogFile != null) {
            this.setProfileLog(new File(profileLogFile));
        }
    }

    public void setMaxPending(int max) {
        this.maxPending = max;
    }

    public long pending() {
        return this.pendingSet.size();
    }

    public void setDestination(UriUniqFilter.CrawlUriReceiver receiver) {
        this.receiver = receiver;
    }

    protected void profileLog(String key) {
        if (this.profileLog != null) {
            this.profileLog.println(key);
        }
    }

    public synchronized void add(String key, CrawlURI value) {
        this.profileLog(key);
        long fp = FPMergeUriUniqFilter.createFp(key);
        if (!this.quickCheck(fp)) {
            ++this.quickDuplicateCount;
            return;
        }
        this.pend(fp, value);
        if (this.pendingSet.size() >= this.maxPending) {
            this.flush();
        }
    }

    protected void pend(long fp, CrawlURI value) {
        if (this.count() == 0L) {
            if (!this.pendingSet.add(new PendingItem(fp, null))) {
                ++this.pendDuplicateCount;
            } else if (value != null) {
                this.receiver.receive(value);
            }
            return;
        }
        if (!this.pendingSet.add(new PendingItem(fp, value))) {
            ++this.pendDuplicateCount;
        }
    }

    private boolean quickCheck(long fp) {
        return this.quickCache.add(fp);
    }

    public static long createFp(CharSequence key) {
        return FPGenerator.std64.fp(key);
    }

    public void addNow(String key, CrawlURI value) {
        this.add(key, value);
        this.flush();
    }

    public void addForce(String key, CrawlURI value) {
        this.add(key, null);
        this.receiver.receive(value);
    }

    public void note(String key) {
        this.add(key, null);
    }

    public void forget(String key, CrawlURI value) {
        throw new UnsupportedOperationException();
    }

    public synchronized long requestFlush() {
        if (System.currentTimeMillis() > this.nextFlushAllowableAfter) {
            return this.flush();
        }
        return -1L;
    }

    public synchronized long flush() {
        if (this.pending() == 0L) {
            return 0L;
        }
        long flushStartTime = System.currentTimeMillis();
        long adds = 0L;
        long fpOnlyAdds = 0L;
        Long currFp = null;
        PendingItem currPend = null;
        Iterator<PendingItem> pendIter = this.pendingSet.iterator();
        LongIterator fpIter = this.beginFpMerge();
        currPend = pendIter.hasNext() ? pendIter.next() : null;
        Long l = currFp = fpIter.hasNext() ? (Long)fpIter.next() : null;
        while (true) {
            if (currFp != null && (currPend == null || currFp <= currPend.fp)) {
                this.addNewFp(currFp);
                if (currPend != null && currFp == currPend.fp) {
                    ++this.mergeDuplicateCount;
                }
                if (fpIter.hasNext()) {
                    currFp = (Long)fpIter.next();
                    continue;
                }
                currFp = null;
            }
            while (currPend != null && (currFp == null || currFp > currPend.fp)) {
                this.addNewFp(currPend.fp);
                if (currPend.caUri != null) {
                    ++adds;
                    this.receiver.receive(currPend.caUri);
                } else {
                    ++fpOnlyAdds;
                }
                if (pendIter.hasNext()) {
                    currPend = pendIter.next();
                    continue;
                }
                currPend = null;
                break;
            }
            if (currFp == null) break;
        }
        long flushDuration = System.currentTimeMillis() - flushStartTime;
        this.nextFlushAllowableAfter = flushStartTime + 100L * flushDuration;
        if (LOGGER.isLoggable(Level.INFO)) {
            long mergeDups = this.mergeDuplicateCount - this.mergeDupAtLast;
            long pendDups = this.pendDuplicateCount - this.pendDupAtLast;
            long quickDups = this.quickDuplicateCount - this.quickDupAtLast;
            LOGGER.info("flush took " + flushDuration + "ms: " + adds + " adds, " + fpOnlyAdds + " fpOnlydds, " + mergeDups + " mergeDups, " + pendDups + " pendDups, " + quickDups + " quickDups ");
            if (adds == 0L && fpOnlyAdds == 0L && mergeDups == 0L && pendDups == 0L && quickDups == 0L) {
                LOGGER.info("that's odd");
            }
        }
        this.mergeDupAtLast = this.mergeDuplicateCount;
        this.pendDupAtLast = this.pendDuplicateCount;
        this.quickDupAtLast = this.quickDuplicateCount;
        this.pendingSet.clear();
        this.finishFpMerge();
        return adds;
    }

    protected abstract LongIterator beginFpMerge();

    protected abstract void addNewFp(long var1);

    protected abstract void finishFpMerge();

    public void close() {
        if (this.profileLog != null) {
            this.profileLog.close();
        }
    }

    public void setProfileLog(File logfile) {
        try {
            this.profileLog = new PrintWriter(new BufferedOutputStream(new FileOutputStream(logfile)));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public class PendingItem
    implements Comparable {
        long fp;
        CrawlURI caUri;

        public PendingItem(long fp, CrawlURI value) {
            this.fp = fp;
            this.caUri = value;
        }

        public int compareTo(Object arg0) {
            PendingItem vs = (PendingItem)arg0;
            return this.fp < vs.fp ? -1 : (this.fp == vs.fp ? 0 : 1);
        }
    }
}

