/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.util;

import java.io.Serializable;
import org.archive.crawler.util.SetBasedUriUniqFilter;
import org.archive.state.Immutable;
import org.archive.state.Initializable;
import org.archive.state.Key;
import org.archive.state.KeyManager;
import org.archive.state.StateProvider;
import org.archive.util.ArchiveUtils;
import org.archive.util.fingerprint.LongFPSet;
import st.ata.util.FPGenerator;

public class FPUriUniqFilter
extends SetBasedUriUniqFilter
implements Initializable,
Serializable {
    private static final long serialVersionUID = ArchiveUtils.classnameBasedUID(FPUriUniqFilter.class, (int)1);
    private LongFPSet fpset;
    private transient FPGenerator fpgen = FPGenerator.std64;
    @Immutable
    public static final Key<LongFPSet> LONG_FP_SET = Key.makeAuto(LongFPSet.class);

    public FPUriUniqFilter(LongFPSet fpset) {
        this.fpset = fpset;
    }

    public FPUriUniqFilter() {
    }

    public void initialTasks(StateProvider provider) {
        this.fpset = (LongFPSet)provider.get((Object)this, LONG_FP_SET);
    }

    private long getFp(CharSequence canonical) {
        return this.fpgen.fp(canonical);
    }

    protected boolean setAdd(CharSequence uri) {
        return this.fpset.add(this.getFp(uri));
    }

    protected long setCount() {
        return this.fpset.count();
    }

    protected boolean setRemove(CharSequence uri) {
        return this.fpset.remove(this.getFp(uri));
    }

    static {
        KeyManager.addKeys(FPUriUniqFilter.class);
    }
}

