/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.util;

import java.io.File;
import java.io.Serializable;
import javax.management.ObjectName;
import org.archive.crawler.util.LogReader;
import org.archive.crawler.util.LogRemoteAccess;
import org.archive.crawler.util.Logs;
import org.archive.openmbeans.annotations.Bean;
import org.archive.settings.jmx.JMXModuleListener;

public class LogRemoteAccessImpl
extends Bean
implements Serializable,
LogRemoteAccess {
    private static final long serialVersionUID = 1L;
    String logDirectory;
    ObjectName oname;

    public LogRemoteAccessImpl(String job, String domain, String logDirectory) {
        super(LogRemoteAccess.class);
        this.logDirectory = logDirectory;
        this.oname = JMXModuleListener.nameOf((String)domain, (String)job, (Object)this);
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String[] getTail(String log, int lines) {
        String logfile = Logs.valueOf(log).getFilename();
        return LogReader.tail(this.logDirectory + File.separator + logfile, lines);
    }

    public String[] getByRegExpr(String log, int lines, String regexpr, boolean grep, boolean ln, boolean indent, int linesToSkip) {
        String logfile = Logs.valueOf(log).getFilename();
        if (regexpr == null) {
            regexpr = ".*";
        }
        if (grep) {
            regexpr = ".*" + regexpr + ".*";
        }
        if (indent) {
            return LogReader.getByRegExprFromSeries(this.logDirectory + File.separator + logfile, regexpr, " ", ln, linesToSkip - 1, lines);
        }
        return LogReader.getByRegExprFromSeries(this.logDirectory + File.separator + logfile, regexpr, 0, ln, linesToSkip - 1, lines);
    }

    public String[] getByPrefix(String log, int lines, String prefix) {
        String logfile = Logs.valueOf(log).getFilename();
        if (prefix == null) {
            prefix = "";
        }
        int prefixLinenumber = LogReader.findFirstLineBeginningFromSeries(this.logDirectory + File.separator + logfile, prefix);
        return LogReader.getFromSeries(this.logDirectory + File.separator + logfile, prefixLinenumber, lines);
    }

    public String[] getByLinenumber(String log, int lines, int linenumber) {
        String logfile = Logs.valueOf(log).getFilename();
        return LogReader.getFromSeries(this.logDirectory + File.separator + logfile, linenumber, lines);
    }
}

