/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.util;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Logger;
import org.archive.util.PropertyUtils;

public class LogUtils {
    public static void createFileLogger(File logsDir, String baseName, Logger logger) {
        int limit = PropertyUtils.getIntProperty((String)"java.util.logging.FileHandler.limit", (int)0);
        int count = PropertyUtils.getIntProperty((String)"java.util.logging.FileHandler.count", (int)1);
        try {
            String tmp = System.getProperty("java.util.logging.FileHandler.pattern");
            File logFile = new File(logsDir, baseName + (tmp != null && tmp.length() > 0 ? tmp : ".log"));
            FileHandler fh = new FileHandler(logFile.getAbsolutePath(), limit, count, true);
            tmp = System.getProperty("java.util.logging.FileHandler.formatter");
            if (tmp != null && tmp.length() > 0) {
                Constructor<?> co = Class.forName(tmp).getConstructor(new Class[0]);
                Formatter f = (Formatter)co.newInstance(new Object[0]);
                fh.setFormatter(f);
            }
            logger.addHandler(fh);
            logger.setUseParentHandlers(false);
        }
        catch (Exception e) {
            logger.severe("Failed customization of logger: " + e.getMessage());
        }
    }
}

