/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.crawler.datamodel.CrawlURI;
import org.archive.crawler.datamodel.UriUniqFilter;
import org.archive.state.KeyManager;

public abstract class SetBasedUriUniqFilter
implements UriUniqFilter,
Serializable {
    private static Logger LOGGER = Logger.getLogger(SetBasedUriUniqFilter.class.getName());
    protected UriUniqFilter.CrawlUriReceiver receiver;
    protected PrintWriter profileLog;
    protected long duplicateCount = 0L;
    protected long duplicatesAtLastSample = 0L;

    public SetBasedUriUniqFilter() {
        KeyManager.addKeys(this.getClass());
        String profileLogFile = System.getProperty(SetBasedUriUniqFilter.class.getName() + ".profileLogFile");
        if (profileLogFile != null) {
            this.setProfileLog(new File(profileLogFile));
        }
    }

    protected abstract boolean setAdd(CharSequence var1);

    protected abstract boolean setRemove(CharSequence var1);

    protected abstract long setCount();

    public long count() {
        return this.setCount();
    }

    public long pending() {
        return 0L;
    }

    public void setDestination(UriUniqFilter.CrawlUriReceiver receiver) {
        this.receiver = receiver;
    }

    protected void profileLog(String key) {
        if (this.profileLog != null) {
            this.profileLog.println(key);
        }
    }

    public void add(String key, CrawlURI value) {
        this.profileLog(key);
        if (this.setAdd(key)) {
            this.receiver.receive(value);
            if (this.setCount() % 50000L == 0L) {
                LOGGER.log(Level.FINE, "count: " + this.setCount() + " totalDups: " + this.duplicateCount + " recentDups: " + (this.duplicateCount - this.duplicatesAtLastSample));
                this.duplicatesAtLastSample = this.duplicateCount;
            }
        } else {
            ++this.duplicateCount;
        }
    }

    public void addNow(String key, CrawlURI value) {
        this.add(key, value);
    }

    public void addForce(String key, CrawlURI value) {
        this.profileLog(key);
        this.setAdd(key);
        this.receiver.receive(value);
    }

    public void note(String key) {
        this.profileLog(key);
        this.setAdd(key);
    }

    public void forget(String key, CrawlURI value) {
        this.setRemove(key);
    }

    public long requestFlush() {
        return 0L;
    }

    public void close() {
        if (this.profileLog != null) {
            this.profileLog.close();
        }
    }

    public void setProfileLog(File logfile) {
        try {
            this.profileLog = new PrintWriter(new BufferedOutputStream(new FileOutputStream(logfile)));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

