/*
 * Decompiled with CFR 0.152.
 */
package org.archive.extractor;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.archive.extractor.CharSequenceProvider;
import org.archive.extractor.ExtractErrorListener;
import org.archive.extractor.LinkExtractor;
import org.archive.modules.extractor.Link;
import org.archive.net.UURI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CharSequenceLinkExtractor
implements LinkExtractor {
    protected UURI source;
    protected UURI base;
    protected ExtractErrorListener extractErrorListener;
    protected CharSequence sourceContent;
    protected LinkedList<Link> next;

    @Override
    public void setup(UURI source, UURI base, InputStream content, Charset charset, ExtractErrorListener listener) {
        this.setup(source, base, this.charSequenceFrom(content, charset), listener);
    }

    public void setup(UURI source, UURI base, CharSequence content, ExtractErrorListener listener) {
        this.source = source;
        this.base = base;
        this.extractErrorListener = listener;
        this.sourceContent = content;
        this.next = new LinkedList();
    }

    public void setup(UURI sourceandbase, CharSequence content, ExtractErrorListener listener) {
        this.setup(sourceandbase, sourceandbase, content, listener);
    }

    @Override
    public void setup(UURI sourceandbase, InputStream content, Charset charset, ExtractErrorListener listener) {
        this.setup(sourceandbase, sourceandbase, content, charset, listener);
    }

    @Override
    public Link nextLink() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.next.removeFirst();
    }

    @Override
    public void reset() {
        this.base = null;
        this.source = null;
        this.sourceContent = null;
    }

    @Override
    public boolean hasNext() {
        if (!this.next.isEmpty()) {
            return true;
        }
        return this.findNextLink();
    }

    protected abstract boolean findNextLink();

    public Object next() {
        return this.nextLink();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected CharSequence charSequenceFrom(InputStream content, Charset charset) {
        if (content instanceof CharSequenceProvider) {
            return ((CharSequenceProvider)((Object)content)).getCharSequence();
        }
        return this.createCharSequenceFrom(content, charset);
    }

    protected CharSequence createCharSequenceFrom(InputStream content, Charset charset) {
        return null;
    }

    public static void extract(CharSequence content, UURI source, UURI base, List<Link> collector, ExtractErrorListener extractErrorListener) {
        CharSequenceLinkExtractor extractor = CharSequenceLinkExtractor.newDefaultInstance();
        extractor.setup(source, base, content, extractErrorListener);
        while (extractor.hasNext()) {
            collector.add(extractor.nextLink());
        }
        extractor.reset();
    }

    protected static CharSequenceLinkExtractor newDefaultInstance() {
        return null;
    }
}

