/*
 * Decompiled with CFR 0.152.
 */
package org.archive.extractor;

import java.io.IOException;
import java.util.regex.Matcher;
import org.apache.commons.httpclient.URIException;
import org.archive.extractor.CharSequenceLinkExtractor;
import org.archive.modules.extractor.Hop;
import org.archive.modules.extractor.Link;
import org.archive.modules.extractor.LinkContext;
import org.archive.net.UURI;
import org.archive.net.UURIFactory;
import org.archive.util.DevUtils;
import org.archive.util.TextUtils;

public class RegexpCSSLinkExtractor
extends CharSequenceLinkExtractor {
    private static String ESCAPED_AMP = "&amp";
    static final String CSS_BACKSLASH_ESCAPE = "\\\\([,'\"\\(\\)\\s])";
    protected Matcher uris;
    static final String CSS_URI_EXTRACTOR = "(?:@import (?:url[(]|)|url[(])\\s*([\\\"']?)([^\\\"'].*?)\\1\\s*[);]";

    protected boolean findNextLink() {
        block5: {
            if (this.uris == null) {
                this.uris = TextUtils.getMatcher((String)CSS_URI_EXTRACTOR, (CharSequence)this.sourceContent);
            }
            try {
                if (!this.uris.find()) break block5;
                String cssUri = this.uris.group(2);
                cssUri = TextUtils.replaceAll((String)ESCAPED_AMP, (CharSequence)cssUri, (String)"&");
                cssUri = TextUtils.replaceAll((String)CSS_BACKSLASH_ESCAPE, (CharSequence)cssUri, (String)"$1");
                try {
                    Link link = new Link((CharSequence)this.source, (CharSequence)UURIFactory.getInstance((UURI)this.base, (String)cssUri), LinkContext.EMBED_MISC, Hop.EMBED);
                    this.next.addLast(link);
                }
                catch (URIException e) {
                    this.extractErrorListener.noteExtractError((IOException)((Object)e), this.source, cssUri);
                }
                return true;
            }
            catch (StackOverflowError e) {
                DevUtils.warnHandle((Throwable)e, (String)"RegexpCSSLinkExtractor StackOverflowError");
            }
        }
        return false;
    }

    public void reset() {
        super.reset();
        TextUtils.recycleMatcher((Matcher)this.uris);
        this.uris = null;
    }

    protected static CharSequenceLinkExtractor newDefaultInstance() {
        return new RegexpCSSLinkExtractor();
    }
}

