/*
 * Decompiled with CFR 0.152.
 */
package org.archive.extractor;

import java.io.IOException;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.URIException;
import org.archive.extractor.CharSequenceLinkExtractor;
import org.archive.modules.extractor.Hop;
import org.archive.modules.extractor.Link;
import org.archive.modules.extractor.LinkContext;
import org.archive.net.UURI;
import org.archive.net.UURIFactory;
import org.archive.util.TextUtils;

public class RegexpJSLinkExtractor
extends CharSequenceLinkExtractor {
    static final String AMP = "&";
    static final String ESCAPED_AMP = "&amp;";
    static final String WHITESPACE = "\\s";
    static final Pattern JAVASCRIPT_STRING_EXTRACTOR = Pattern.compile("(\\\\{0,8}+(?:\"|'))(.+?)(?:\\1)");
    static final Pattern STRING_URI_DETECTOR = Pattern.compile("(?:\\w|[\\.]{0,2}/)[\\S&&[^<>]]*(?:\\.|/)[\\S&&[^<>]]*(?:\\w|/)");
    Matcher strings;
    LinkedList<Matcher> matcherStack = new LinkedList();

    protected boolean findNextLink() {
        if (this.strings == null) {
            this.strings = JAVASCRIPT_STRING_EXTRACTOR.matcher(this.sourceContent);
        }
        while (this.strings != null) {
            while (this.strings.find()) {
                CharSequence subsequence = this.sourceContent.subSequence(this.strings.start(2), this.strings.end(2));
                Matcher uri = STRING_URI_DETECTOR.matcher(subsequence);
                if (subsequence.length() <= 2083 && uri.matches()) {
                    String string = uri.group();
                    string = TextUtils.replaceAll((String)ESCAPED_AMP, (CharSequence)string, (String)AMP);
                    try {
                        Link link = new Link((CharSequence)this.source, (CharSequence)UURIFactory.getInstance((UURI)this.source, (String)string), LinkContext.JS_MISC, Hop.SPECULATIVE);
                        this.next.add(link);
                        return true;
                    }
                    catch (URIException e) {
                        this.extractErrorListener.noteExtractError((IOException)((Object)e), this.source, string);
                        continue;
                    }
                }
                this.matcherStack.addFirst(this.strings);
                this.strings = JAVASCRIPT_STRING_EXTRACTOR.matcher(subsequence);
            }
            this.strings = this.matcherStack.isEmpty() ? null : this.matcherStack.removeFirst();
        }
        return false;
    }

    public void reset() {
        super.reset();
        this.matcherStack.clear();
        this.strings = null;
    }

    protected static CharSequenceLinkExtractor newDefaultInstance() {
        return new RegexpJSLinkExtractor();
    }
}

