/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.info;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.support.nodes.NodeOperationResponse;
import org.elasticsearch.action.support.nodes.NodesOperationResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;

public class NodesInfoResponse
extends NodesOperationResponse<NodeInfo>
implements ToXContent {
    private SettingsFilter settingsFilter;

    public NodesInfoResponse() {
    }

    public NodesInfoResponse(ClusterName clusterName, NodeInfo[] nodes) {
        super(clusterName, (NodeOperationResponse[])nodes);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.nodes = new NodeInfo[in.readVInt()];
        for (int i = 0; i < ((NodeInfo[])this.nodes).length; ++i) {
            ((NodeInfo[])this.nodes)[i] = NodeInfo.readNodeInfo(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(((NodeInfo[])this.nodes).length);
        for (NodeInfo node : (NodeInfo[])this.nodes) {
            node.writeTo(out);
        }
    }

    public NodesInfoResponse settingsFilter(SettingsFilter settingsFilter) {
        this.settingsFilter = settingsFilter;
        return this;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("cluster_name", this.getClusterName().value());
        builder.startObject("nodes");
        for (NodeInfo nodeInfo : this) {
            builder.startObject(nodeInfo.getNode().id(), XContentBuilder.FieldCaseConversion.NONE);
            builder.field("name", nodeInfo.getNode().name(), XContentBuilder.FieldCaseConversion.NONE);
            builder.field("transport_address", nodeInfo.getNode().address().toString());
            if (nodeInfo.getHostname() != null) {
                builder.field("hostname", nodeInfo.getHostname(), XContentBuilder.FieldCaseConversion.NONE);
            }
            if (nodeInfo.getVersion() != null) {
                builder.field("version", (Object)nodeInfo.getVersion());
            }
            if (nodeInfo.getServiceAttributes() != null) {
                for (Map.Entry nodeAttribute : nodeInfo.getServiceAttributes().entrySet()) {
                    builder.field((String)nodeAttribute.getKey(), (String)nodeAttribute.getValue());
                }
            }
            if (!nodeInfo.getNode().attributes().isEmpty()) {
                builder.startObject("attributes");
                for (Map.Entry attr : nodeInfo.getNode().attributes().entrySet()) {
                    builder.field((String)attr.getKey(), (String)attr.getValue());
                }
                builder.endObject();
            }
            if (nodeInfo.getSettings() != null) {
                builder.startObject("settings");
                Settings settings = this.settingsFilter.filterSettings(nodeInfo.getSettings());
                for (Map.Entry entry : settings.getAsMap().entrySet()) {
                    builder.field((String)entry.getKey(), (String)entry.getValue());
                }
                builder.endObject();
            }
            if (nodeInfo.getOs() != null) {
                nodeInfo.getOs().toXContent(builder, params);
            }
            if (nodeInfo.getProcess() != null) {
                nodeInfo.getProcess().toXContent(builder, params);
            }
            if (nodeInfo.getJvm() != null) {
                nodeInfo.getJvm().toXContent(builder, params);
            }
            if (nodeInfo.getThreadPool() != null) {
                nodeInfo.getThreadPool().toXContent(builder, params);
            }
            if (nodeInfo.getNetwork() != null) {
                nodeInfo.getNetwork().toXContent(builder, params);
            }
            if (nodeInfo.getTransport() != null) {
                nodeInfo.getTransport().toXContent(builder, params);
            }
            if (nodeInfo.getHttp() != null) {
                nodeInfo.getHttp().toXContent(builder, params);
            }
            if (nodeInfo.getPlugins() != null) {
                nodeInfo.getPlugins().toXContent(builder, params);
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public String toString() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().prettyPrint();
            builder.startObject();
            this.toXContent(builder, EMPTY_PARAMS);
            builder.endObject();
            return builder.string();
        }
        catch (IOException e) {
            return "{ \"error\" : \"" + e.getMessage() + "\"}";
        }
    }
}

