/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.state;

import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeOperationAction;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportClusterStateAction
extends TransportMasterNodeOperationAction<ClusterStateRequest, ClusterStateResponse> {
    private final ClusterName clusterName;

    @Inject
    public TransportClusterStateAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ClusterName clusterName) {
        super(settings, transportService, clusterService, threadPool);
        this.clusterName = clusterName;
    }

    @Override
    protected String executor() {
        return "generic";
    }

    @Override
    protected String transportAction() {
        return "cluster/state";
    }

    @Override
    protected ClusterStateRequest newRequest() {
        return new ClusterStateRequest();
    }

    @Override
    protected ClusterStateResponse newResponse() {
        return new ClusterStateResponse();
    }

    @Override
    protected boolean localExecute(ClusterStateRequest request) {
        return request.local();
    }

    @Override
    protected ClusterStateResponse masterOperation(ClusterStateRequest request, ClusterState state) throws ElasticSearchException {
        ClusterState currentState = this.clusterService.state();
        ClusterState.Builder builder = ClusterState.newClusterStateBuilder();
        if (!request.filterNodes()) {
            builder.nodes(currentState.nodes());
        }
        if (!request.filterRoutingTable()) {
            builder.routingTable(currentState.routingTable());
            builder.allocationExplanation(currentState.allocationExplanation());
        }
        if (!request.filterBlocks()) {
            builder.blocks(currentState.blocks());
        }
        if (!request.filterMetaData()) {
            MetaData.Builder mdBuilder = MetaData.newMetaDataBuilder();
            if (request.filteredIndices().length == 0 && request.filteredIndexTemplates().length == 0) {
                mdBuilder.metaData(currentState.metaData());
            }
            if (!(request.filteredIndices().length <= 0 || request.filteredIndices().length == 1 && "_na".equals(request.filteredIndices()[0]))) {
                String[] indices;
                for (String filteredIndex : indices = currentState.metaData().concreteIndicesIgnoreMissing(request.filteredIndices())) {
                    IndexMetaData indexMetaData = currentState.metaData().index(filteredIndex);
                    if (indexMetaData == null) continue;
                    mdBuilder.put(indexMetaData, false);
                }
            }
            if (request.filteredIndexTemplates().length > 0) {
                for (String templateName : request.filteredIndexTemplates()) {
                    IndexTemplateMetaData indexTemplateMetaData = currentState.metaData().templates().get(templateName);
                    if (indexTemplateMetaData == null) continue;
                    mdBuilder.put(indexTemplateMetaData);
                }
            }
            builder.metaData(mdBuilder);
        }
        return new ClusterStateResponse(this.clusterName, builder.build());
    }
}

