/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.analyze;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class AnalyzeResponse
extends ActionResponse
implements Iterable<AnalyzeToken>,
ToXContent {
    private List<AnalyzeToken> tokens;

    AnalyzeResponse() {
    }

    public AnalyzeResponse(List<AnalyzeToken> tokens) {
        this.tokens = tokens;
    }

    public List<AnalyzeToken> getTokens() {
        return this.tokens;
    }

    @Override
    public Iterator<AnalyzeToken> iterator() {
        return this.tokens.iterator();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        String format = params.param("format", "detailed");
        if ("detailed".equals(format)) {
            builder.startArray("tokens");
            for (AnalyzeToken token : this.tokens) {
                builder.startObject();
                builder.field("token", token.getTerm());
                builder.field("start_offset", token.getStartOffset());
                builder.field("end_offset", token.getEndOffset());
                builder.field("type", token.getType());
                builder.field("position", token.getPosition());
                builder.endObject();
            }
            builder.endArray();
        } else if ("text".equals(format)) {
            StringBuilder sb = new StringBuilder();
            int lastPosition = 0;
            for (AnalyzeToken token : this.tokens) {
                if (lastPosition != token.getPosition()) {
                    if (lastPosition != 0) {
                        sb.append("\n").append(token.getPosition()).append(": \n");
                    }
                    lastPosition = token.getPosition();
                }
                sb.append('[').append(token.getTerm()).append(":").append(token.getStartOffset()).append("->").append(token.getEndOffset()).append(":").append(token.getType()).append("]\n");
            }
            builder.field("tokens", (Object)sb);
        }
        return builder;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        this.tokens = new ArrayList<AnalyzeToken>(size);
        for (int i = 0; i < size; ++i) {
            this.tokens.add(AnalyzeToken.readAnalyzeToken(in));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.tokens.size());
        for (AnalyzeToken token : this.tokens) {
            token.writeTo(out);
        }
    }

    public static class AnalyzeToken
    implements Streamable {
        private String term;
        private int startOffset;
        private int endOffset;
        private int position;
        private String type;

        AnalyzeToken() {
        }

        public AnalyzeToken(String term, int position, int startOffset, int endOffset, String type) {
            this.term = term;
            this.position = position;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.type = type;
        }

        public String getTerm() {
            return this.term;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public int getPosition() {
            return this.position;
        }

        public String getType() {
            return this.type;
        }

        public static AnalyzeToken readAnalyzeToken(StreamInput in) throws IOException {
            AnalyzeToken analyzeToken = new AnalyzeToken();
            analyzeToken.readFrom(in);
            return analyzeToken;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.term = in.readString();
            this.startOffset = in.readInt();
            this.endOffset = in.readInt();
            this.position = in.readVInt();
            this.type = in.readOptionalString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.term);
            out.writeInt(this.startOffset);
            out.writeInt(this.endOffset);
            out.writeVInt(this.position);
            out.writeOptionalString(this.type);
        }
    }
}

