/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.RoutingMissingException;
import org.elasticsearch.action.bulk.BulkAction;
import org.elasticsearch.action.bulk.BulkItemRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.bulk.BulkShardResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.replication.TransportShardReplicationOperationAction;
import org.elasticsearch.action.update.UpdateHelper;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.action.index.MappingUpdatedAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.engine.DocumentAlreadyExistsException;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.percolator.PercolatorExecutor;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;

public class TransportShardBulkAction
extends TransportShardReplicationOperationAction<BulkShardRequest, BulkShardRequest, BulkShardResponse> {
    private final MappingUpdatedAction mappingUpdatedAction;
    private final UpdateHelper updateHelper;
    private final boolean allowIdGeneration;

    @Inject
    public TransportShardBulkAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, MappingUpdatedAction mappingUpdatedAction, UpdateHelper updateHelper) {
        super(settings, transportService, clusterService, indicesService, threadPool, shardStateAction);
        this.mappingUpdatedAction = mappingUpdatedAction;
        this.updateHelper = updateHelper;
        this.allowIdGeneration = settings.getAsBoolean("action.allow_id_generation", (Boolean)true);
    }

    @Override
    protected String executor() {
        return "bulk";
    }

    @Override
    protected boolean checkWriteConsistency() {
        return true;
    }

    @Override
    protected TransportRequestOptions transportOptions() {
        return BulkAction.INSTANCE.transportOptions(this.settings);
    }

    @Override
    protected BulkShardRequest newRequestInstance() {
        return new BulkShardRequest();
    }

    @Override
    protected BulkShardRequest newReplicaRequestInstance() {
        return new BulkShardRequest();
    }

    @Override
    protected BulkShardResponse newResponseInstance() {
        return new BulkShardResponse();
    }

    @Override
    protected String transportAction() {
        return "bulk/shard";
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, BulkShardRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.WRITE);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, BulkShardRequest request) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.WRITE, request.index());
    }

    @Override
    protected ShardIterator shards(ClusterState clusterState, BulkShardRequest request) {
        return clusterState.routingTable().index(request.index()).shard(request.shardId()).shardsIt();
    }

    @Override
    protected TransportShardReplicationOperationAction.PrimaryResponse<BulkShardResponse, BulkShardRequest> shardOperationOnPrimary(ClusterState clusterState, TransportShardReplicationOperationAction.PrimaryOperationRequest shardRequest) {
        BulkShardRequest request = (BulkShardRequest)shardRequest.request;
        IndexShard indexShard = this.indicesService.indexServiceSafe(((BulkShardRequest)shardRequest.request).index()).shardSafe(shardRequest.shardId);
        Engine.IndexingOperation[] ops = null;
        HashSet<Tuple<String, String>> mappingsToUpdate = null;
        BulkItemResponse[] responses = new BulkItemResponse[request.items().length];
        long[] preVersions = new long[request.items().length];
        block17: for (int i = 0; i < request.items().length; ++i) {
            BulkItemRequest bulkItemRequest = request.items()[i];
            if (bulkItemRequest.request() instanceof IndexRequest) {
                IndexRequest indexRequest = (IndexRequest)bulkItemRequest.request();
                try {
                    WriteResult result = this.shardIndexOperation(request, indexRequest, clusterState, indexShard, true);
                    IndexResponse indexResponse = (IndexResponse)result.response();
                    responses[i] = new BulkItemResponse(bulkItemRequest.id(), indexRequest.opType().lowercase(), indexResponse);
                    preVersions[i] = result.preVersion;
                    if (result.mappingToUpdate != null) {
                        if (mappingsToUpdate == null) {
                            mappingsToUpdate = Sets.newHashSet();
                        }
                        mappingsToUpdate.add(result.mappingToUpdate);
                    }
                    if (result.op == null) continue;
                    if (ops == null) {
                        ops = new Engine.IndexingOperation[request.items().length];
                    }
                    ops[i] = result.op;
                }
                catch (Exception e) {
                    if (this.retryPrimaryException(e)) {
                        for (int j = 0; j < i; ++j) {
                            this.applyVersion(request.items()[j], preVersions[j]);
                        }
                        throw (ElasticSearchException)e;
                    }
                    if (e instanceof ElasticSearchException && ((ElasticSearchException)e).status() == RestStatus.CONFLICT) {
                        this.logger.trace("[{}][{}] failed to execute bulk item (index) {}", e, ((BulkShardRequest)shardRequest.request).index(), shardRequest.shardId, indexRequest);
                    } else {
                        this.logger.debug("[{}][{}] failed to execute bulk item (index) {}", e, ((BulkShardRequest)shardRequest.request).index(), shardRequest.shardId, indexRequest);
                    }
                    responses[i] = new BulkItemResponse(bulkItemRequest.id(), indexRequest.opType().lowercase(), new BulkItemResponse.Failure(indexRequest.index(), indexRequest.type(), indexRequest.id(), ExceptionsHelper.detailedMessage(e)));
                    request.items()[i] = null;
                }
                continue;
            }
            if (bulkItemRequest.request() instanceof DeleteRequest) {
                DeleteRequest deleteRequest = (DeleteRequest)bulkItemRequest.request();
                try {
                    DeleteResponse deleteResponse = (DeleteResponse)this.shardDeleteOperation(deleteRequest, indexShard).response();
                    responses[i] = new BulkItemResponse(bulkItemRequest.id(), "delete", deleteResponse);
                }
                catch (Exception e) {
                    if (this.retryPrimaryException(e)) {
                        for (int j = 0; j < i; ++j) {
                            this.applyVersion(request.items()[j], preVersions[j]);
                        }
                        throw (ElasticSearchException)e;
                    }
                    if (e instanceof ElasticSearchException && ((ElasticSearchException)e).status() == RestStatus.CONFLICT) {
                        this.logger.trace("[{}][{}] failed to execute bulk item (delete) {}", e, ((BulkShardRequest)shardRequest.request).index(), shardRequest.shardId, deleteRequest);
                    } else {
                        this.logger.debug("[{}][{}] failed to execute bulk item (delete) {}", e, ((BulkShardRequest)shardRequest.request).index(), shardRequest.shardId, deleteRequest);
                    }
                    responses[i] = new BulkItemResponse(bulkItemRequest.id(), "delete", new BulkItemResponse.Failure(deleteRequest.index(), deleteRequest.type(), deleteRequest.id(), ExceptionsHelper.detailedMessage(e)));
                    request.items()[i] = null;
                }
                continue;
            }
            if (!(bulkItemRequest.request() instanceof UpdateRequest)) continue;
            UpdateRequest updateRequest = (UpdateRequest)bulkItemRequest.request();
            int retryCount = 0;
            do {
                IndexRequest indexRequest;
                UpdateResult updateResult;
                try {
                    updateResult = this.shardUpdateOperation(clusterState, request, updateRequest, indexShard);
                }
                catch (Throwable t) {
                    updateResult = new UpdateResult(null, null, false, t, null);
                }
                if (updateResult.success()) {
                    switch (updateResult.result.operation()) {
                        case UPSERT: 
                        case INDEX: {
                            WriteResult result = updateResult.writeResult;
                            indexRequest = (IndexRequest)updateResult.request();
                            BytesReference indexSourceAsBytes = indexRequest.source();
                            IndexResponse indexResponse = (IndexResponse)result.response();
                            UpdateResponse updateResponse = new UpdateResponse(indexResponse.getIndex(), indexResponse.getType(), indexResponse.getId(), indexResponse.getVersion());
                            updateResponse.setMatches(indexResponse.getMatches());
                            if (updateRequest.fields() != null && updateRequest.fields().length > 0) {
                                Tuple<XContentType, Map<String, Object>> sourceAndContent = XContentHelper.convertToMap(indexSourceAsBytes, true);
                                updateResponse.setGetResult(this.updateHelper.extractGetResult(updateRequest, indexResponse.getVersion(), sourceAndContent.v2(), sourceAndContent.v1(), indexSourceAsBytes));
                            }
                            responses[i] = new BulkItemResponse(bulkItemRequest.id(), "update", updateResponse);
                            preVersions[i] = result.preVersion;
                            if (result.mappingToUpdate != null) {
                                if (mappingsToUpdate == null) {
                                    mappingsToUpdate = Sets.newHashSet();
                                }
                                mappingsToUpdate.add(result.mappingToUpdate);
                            }
                            if (result.op != null) {
                                if (ops == null) {
                                    ops = new Engine.IndexingOperation[request.items().length];
                                }
                                ops[i] = result.op;
                            }
                            request.items()[i] = new BulkItemRequest(request.items()[i].id(), indexRequest);
                            break;
                        }
                        case DELETE: {
                            DeleteResponse response = (DeleteResponse)updateResult.writeResult.response();
                            DeleteRequest deleteRequest = (DeleteRequest)updateResult.request();
                            UpdateResponse updateResponse = new UpdateResponse(response.getIndex(), response.getType(), response.getId(), response.getVersion());
                            updateResponse.setGetResult(this.updateHelper.extractGetResult(updateRequest, response.getVersion(), updateResult.result.updatedSourceAsMap(), updateResult.result.updateSourceContentType(), null));
                            responses[i] = new BulkItemResponse(bulkItemRequest.id(), "update", updateResponse);
                            request.items()[i] = new BulkItemRequest(request.items()[i].id(), deleteRequest);
                            break;
                        }
                        case NONE: {
                            responses[i] = new BulkItemResponse(bulkItemRequest.id(), "update", updateResult.noopResult);
                            request.items()[i] = null;
                        }
                    }
                    continue block17;
                }
                if (!updateResult.failure()) continue;
                Throwable t = updateResult.error;
                if (updateResult.retry) continue;
                if (this.retryPrimaryException(t)) {
                    for (int j = 0; j < i; ++j) {
                        this.applyVersion(request.items()[j], preVersions[j]);
                    }
                    throw (ElasticSearchException)t;
                }
                if (updateResult.result == null) {
                    responses[i] = new BulkItemResponse(bulkItemRequest.id(), "update", new BulkItemResponse.Failure(updateRequest.index(), updateRequest.type(), updateRequest.id(), ExceptionsHelper.detailedMessage(t)));
                } else {
                    switch (updateResult.result.operation()) {
                        case UPSERT: 
                        case INDEX: {
                            indexRequest = (IndexRequest)updateResult.request();
                            if (t instanceof ElasticSearchException && ((ElasticSearchException)t).status() == RestStatus.CONFLICT) {
                                this.logger.trace("[{}][{}] failed to execute bulk item (index) {}", t, ((BulkShardRequest)shardRequest.request).index(), shardRequest.shardId, indexRequest);
                            } else {
                                this.logger.debug("[{}][{}] failed to execute bulk item (index) {}", t, ((BulkShardRequest)shardRequest.request).index(), shardRequest.shardId, indexRequest);
                            }
                            responses[i] = new BulkItemResponse(bulkItemRequest.id(), indexRequest.opType().lowercase(), new BulkItemResponse.Failure(indexRequest.index(), indexRequest.type(), indexRequest.id(), ExceptionsHelper.detailedMessage(t)));
                            break;
                        }
                        case DELETE: {
                            DeleteRequest deleteRequest = (DeleteRequest)updateResult.request();
                            if (t instanceof ElasticSearchException && ((ElasticSearchException)t).status() == RestStatus.CONFLICT) {
                                this.logger.trace("[{}][{}] failed to execute bulk item (delete) {}", t, ((BulkShardRequest)shardRequest.request).index(), shardRequest.shardId, deleteRequest);
                            } else {
                                this.logger.debug("[{}][{}] failed to execute bulk item (delete) {}", t, ((BulkShardRequest)shardRequest.request).index(), shardRequest.shardId, deleteRequest);
                            }
                            responses[i] = new BulkItemResponse(bulkItemRequest.id(), "delete", new BulkItemResponse.Failure(deleteRequest.index(), deleteRequest.type(), deleteRequest.id(), ExceptionsHelper.detailedMessage(t)));
                        }
                    }
                }
                request.items()[i] = null;
                continue block17;
            } while (++retryCount < updateRequest.retryOnConflict());
        }
        if (mappingsToUpdate != null) {
            for (Tuple tuple : mappingsToUpdate) {
                this.updateMappingOnMaster((String)tuple.v1(), (String)tuple.v2());
            }
        }
        if (request.refresh()) {
            try {
                indexShard.refresh(new Engine.Refresh(false));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        BulkShardResponse response = new BulkShardResponse(new ShardId(request.index(), request.shardId()), responses);
        return new TransportShardReplicationOperationAction.PrimaryResponse<BulkShardResponse, BulkShardRequest>((BulkShardRequest)shardRequest.request, response, ops);
    }

    private WriteResult shardIndexOperation(BulkShardRequest request, IndexRequest indexRequest, ClusterState clusterState, IndexShard indexShard, boolean processed) {
        Engine.IndexingOperation op;
        long version;
        MappingMetaData mappingMd = clusterState.metaData().index(request.index()).mappingOrDefault(indexRequest.type());
        if (mappingMd != null && mappingMd.routing().required() && indexRequest.routing() == null) {
            throw new RoutingMissingException(indexRequest.index(), indexRequest.type(), indexRequest.id());
        }
        if (!processed) {
            indexRequest.process(clusterState.metaData(), indexRequest.index(), mappingMd, this.allowIdGeneration);
        }
        SourceToParse sourceToParse = SourceToParse.source(indexRequest.source()).type(indexRequest.type()).id(indexRequest.id()).routing(indexRequest.routing()).parent(indexRequest.parent()).timestamp(indexRequest.timestamp()).ttl(indexRequest.ttl());
        if (indexRequest.opType() == IndexRequest.OpType.INDEX) {
            Engine.Index index = indexShard.prepareIndex(sourceToParse).version(indexRequest.version()).versionType(indexRequest.versionType()).origin(Engine.Operation.Origin.PRIMARY);
            indexShard.index(index);
            version = index.version();
            op = index;
        } else {
            Engine.Create create = indexShard.prepareCreate(sourceToParse).version(indexRequest.version()).versionType(indexRequest.versionType()).origin(Engine.Operation.Origin.PRIMARY);
            indexShard.create(create);
            version = create.version();
            op = create;
        }
        long preVersion = indexRequest.version();
        indexRequest.version(version);
        Tuple<String, String> mappingsToUpdate = null;
        if (op.parsedDoc().mappingsModified()) {
            mappingsToUpdate = Tuple.tuple(indexRequest.index(), indexRequest.type());
        }
        if (!Strings.hasLength(indexRequest.percolate())) {
            op = null;
        }
        IndexResponse indexResponse = new IndexResponse(indexRequest.index(), indexRequest.type(), indexRequest.id(), version);
        return new WriteResult(indexResponse, preVersion, mappingsToUpdate, op);
    }

    private WriteResult shardDeleteOperation(DeleteRequest deleteRequest, IndexShard indexShard) {
        Engine.Delete delete = indexShard.prepareDelete(deleteRequest.type(), deleteRequest.id(), deleteRequest.version()).versionType(deleteRequest.versionType()).origin(Engine.Operation.Origin.PRIMARY);
        indexShard.delete(delete);
        deleteRequest.version(delete.version());
        DeleteResponse deleteResponse = new DeleteResponse(deleteRequest.index(), deleteRequest.type(), deleteRequest.id(), delete.version(), delete.notFound());
        return new WriteResult(deleteResponse, deleteRequest.version(), null, null);
    }

    private UpdateResult shardUpdateOperation(ClusterState clusterState, BulkShardRequest bulkShardRequest, UpdateRequest updateRequest, IndexShard indexShard) {
        UpdateHelper.Result translate = this.updateHelper.prepare(updateRequest, indexShard);
        switch (translate.operation()) {
            case UPSERT: 
            case INDEX: {
                IndexRequest indexRequest = (IndexRequest)translate.action();
                try {
                    WriteResult result = this.shardIndexOperation(bulkShardRequest, indexRequest, clusterState, indexShard, false);
                    return new UpdateResult(translate, indexRequest, result);
                }
                catch (Throwable t) {
                    t = ExceptionsHelper.unwrapCause(t);
                    boolean retry = false;
                    if (t instanceof VersionConflictEngineException || t instanceof DocumentAlreadyExistsException && translate.operation() == UpdateHelper.Operation.UPSERT) {
                        retry = true;
                    }
                    return new UpdateResult(translate, indexRequest, retry, t, null);
                }
            }
            case DELETE: {
                DeleteRequest deleteRequest = (DeleteRequest)translate.action();
                try {
                    WriteResult result = this.shardDeleteOperation(deleteRequest, indexShard);
                    return new UpdateResult(translate, deleteRequest, result);
                }
                catch (Throwable t) {
                    t = ExceptionsHelper.unwrapCause(t);
                    boolean retry = false;
                    if (t instanceof VersionConflictEngineException) {
                        retry = true;
                    }
                    return new UpdateResult(translate, deleteRequest, retry, t, null);
                }
            }
            case NONE: {
                UpdateResponse updateResponse = (UpdateResponse)translate.action();
                return new UpdateResult(translate, updateResponse);
            }
        }
        throw new ElasticSearchIllegalStateException("Illegal update operation " + (Object)((Object)translate.operation()));
    }

    @Override
    protected void postPrimaryOperation(BulkShardRequest request, TransportShardReplicationOperationAction.PrimaryResponse<BulkShardResponse, BulkShardRequest> response) {
        IndexService indexService = this.indicesService.indexServiceSafe(request.index());
        Engine.IndexingOperation[] ops = (Engine.IndexingOperation[])response.payload();
        if (ops == null) {
            return;
        }
        for (int i = 0; i < ops.length; ++i) {
            IndexRequest indexRequest;
            Engine.IndexingOperation op;
            BulkItemRequest itemRequest = request.items()[i];
            BulkItemResponse itemResponse = response.response().getResponses()[i];
            if (itemResponse.isFailed() || (op = ops[i]) == null || !(itemRequest.request() instanceof IndexRequest) || !Strings.hasLength((indexRequest = (IndexRequest)itemRequest.request()).percolate())) continue;
            try {
                PercolatorExecutor.Response percolate = indexService.percolateService().percolate(new PercolatorExecutor.DocAndSourceQueryRequest(op.parsedDoc(), indexRequest.percolate()));
                ((IndexResponse)itemResponse.getResponse()).setMatches(percolate.matches());
                continue;
            }
            catch (Exception e) {
                this.logger.warn("failed to percolate [{}]", e, itemRequest.request());
            }
        }
    }

    @Override
    protected void shardOperationOnReplica(TransportShardReplicationOperationAction.ReplicaOperationRequest shardRequest) {
        IndexShard indexShard = this.indicesService.indexServiceSafe(((BulkShardRequest)shardRequest.request).index()).shardSafe(shardRequest.shardId);
        BulkShardRequest request = (BulkShardRequest)shardRequest.request;
        for (int i = 0; i < request.items().length; ++i) {
            BulkItemRequest item = request.items()[i];
            if (item == null) continue;
            if (item.request() instanceof IndexRequest) {
                IndexRequest indexRequest = (IndexRequest)item.request();
                try {
                    SourceToParse sourceToParse = SourceToParse.source(indexRequest.source()).type(indexRequest.type()).id(indexRequest.id()).routing(indexRequest.routing()).parent(indexRequest.parent()).timestamp(indexRequest.timestamp()).ttl(indexRequest.ttl());
                    if (indexRequest.opType() == IndexRequest.OpType.INDEX) {
                        Engine.Index index = indexShard.prepareIndex(sourceToParse).version(indexRequest.version()).origin(Engine.Operation.Origin.REPLICA);
                        indexShard.index(index);
                        continue;
                    }
                    Engine.Create create = indexShard.prepareCreate(sourceToParse).version(indexRequest.version()).origin(Engine.Operation.Origin.REPLICA);
                    indexShard.create(create);
                }
                catch (Exception e) {}
                continue;
            }
            if (!(item.request() instanceof DeleteRequest)) continue;
            DeleteRequest deleteRequest = (DeleteRequest)item.request();
            try {
                Engine.Delete delete = indexShard.prepareDelete(deleteRequest.type(), deleteRequest.id(), deleteRequest.version()).origin(Engine.Operation.Origin.REPLICA);
                indexShard.delete(delete);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (request.refresh()) {
            try {
                indexShard.refresh(new Engine.Refresh(false));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void updateMappingOnMaster(final String index, final String type) {
        try {
            MapperService mapperService = this.indicesService.indexServiceSafe(index).mapperService();
            final DocumentMapper documentMapper = mapperService.documentMapper(type);
            if (documentMapper == null) {
                return;
            }
            documentMapper.refreshSource();
            this.mappingUpdatedAction.execute(new MappingUpdatedAction.MappingUpdatedRequest(index, type, documentMapper.mappingSource()), new ActionListener<MappingUpdatedAction.MappingUpdatedResponse>(){

                @Override
                public void onResponse(MappingUpdatedAction.MappingUpdatedResponse mappingUpdatedResponse) {
                }

                @Override
                public void onFailure(Throwable e) {
                    try {
                        TransportShardBulkAction.this.logger.warn("failed to update master on updated mapping for index [{}], type [{}] and source [{}]", e, index, type, documentMapper.mappingSource().string());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }
        catch (Exception e) {
            this.logger.warn("failed to update master on updated mapping for index [{}], type [{}]", e, index, type);
        }
    }

    private void applyVersion(BulkItemRequest item, long version) {
        if (item.request() instanceof IndexRequest) {
            ((IndexRequest)item.request()).version(version);
        } else if (item.request() instanceof DeleteRequest) {
            ((DeleteRequest)item.request()).version(version);
        }
    }

    static class UpdateResult {
        final UpdateHelper.Result result;
        final ActionRequest actionRequest;
        final boolean retry;
        final Throwable error;
        final WriteResult writeResult;
        final UpdateResponse noopResult;

        UpdateResult(UpdateHelper.Result result, ActionRequest actionRequest, boolean retry, Throwable error, WriteResult writeResult) {
            this.result = result;
            this.actionRequest = actionRequest;
            this.retry = retry;
            this.error = error;
            this.writeResult = writeResult;
            this.noopResult = null;
        }

        UpdateResult(UpdateHelper.Result result, ActionRequest actionRequest, WriteResult writeResult) {
            this.result = result;
            this.actionRequest = actionRequest;
            this.writeResult = writeResult;
            this.retry = false;
            this.error = null;
            this.noopResult = null;
        }

        public UpdateResult(UpdateHelper.Result result, UpdateResponse updateResponse) {
            this.result = result;
            this.noopResult = updateResponse;
            this.actionRequest = null;
            this.writeResult = null;
            this.retry = false;
            this.error = null;
        }

        boolean failure() {
            return this.error != null;
        }

        boolean success() {
            return this.noopResult != null || this.writeResult != null;
        }

        <T extends ActionRequest> T request() {
            return (T)this.actionRequest;
        }
    }

    static class WriteResult {
        final Object response;
        final long preVersion;
        final Tuple<String, String> mappingToUpdate;
        final Engine.IndexingOperation op;

        WriteResult(Object response, long preVersion, Tuple<String, String> mappingToUpdate, Engine.IndexingOperation op) {
            this.response = response;
            this.preVersion = preVersion;
            this.mappingToUpdate = mappingToUpdate;
            this.op = op;
        }

        <T> T response() {
            return (T)this.response;
        }
    }
}

