/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search.type;

import java.io.IOException;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.search.ScoreDoc;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.ReduceSearchPhaseException;
import org.elasticsearch.action.search.SearchOperationThreading;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.action.search.type.ParsedScrollId;
import org.elasticsearch.action.search.type.TransportSearchCache;
import org.elasticsearch.action.search.type.TransportSearchHelper;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.action.SearchServiceListener;
import org.elasticsearch.search.action.SearchServiceTransportAction;
import org.elasticsearch.search.controller.SearchPhaseController;
import org.elasticsearch.search.controller.ShardDoc;
import org.elasticsearch.search.controller.ShardScoreDoc;
import org.elasticsearch.search.fetch.QueryFetchSearchResult;
import org.elasticsearch.search.internal.InternalSearchHits;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.threadpool.ThreadPool;

public class TransportSearchScrollScanAction
extends AbstractComponent {
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final SearchServiceTransportAction searchService;
    private final SearchPhaseController searchPhaseController;
    private final TransportSearchCache searchCache;

    @Inject
    public TransportSearchScrollScanAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportSearchCache searchCache, SearchServiceTransportAction searchService, SearchPhaseController searchPhaseController) {
        super(settings);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.searchCache = searchCache;
        this.searchService = searchService;
        this.searchPhaseController = searchPhaseController;
    }

    public void execute(SearchScrollRequest request, ParsedScrollId scrollId, ActionListener<SearchResponse> listener) {
        new AsyncAction(request, scrollId, listener).start();
    }

    private class AsyncAction {
        private final SearchScrollRequest request;
        private final ActionListener<SearchResponse> listener;
        private final ParsedScrollId scrollId;
        private final DiscoveryNodes nodes;
        protected volatile Queue<ShardSearchFailure> shardFailures;
        private final Map<SearchShardTarget, QueryFetchSearchResult> queryFetchResults;
        private final AtomicInteger successfulOps;
        private final AtomicInteger counter;
        private final long startTime;

        private AsyncAction(SearchScrollRequest request, ParsedScrollId scrollId, ActionListener<SearchResponse> listener) {
            this.queryFetchResults = TransportSearchScrollScanAction.this.searchCache.obtainQueryFetchResults();
            this.startTime = System.currentTimeMillis();
            this.request = request;
            this.listener = listener;
            this.scrollId = scrollId;
            this.nodes = TransportSearchScrollScanAction.this.clusterService.state().nodes();
            this.successfulOps = new AtomicInteger(scrollId.getContext().length);
            this.counter = new AtomicInteger(scrollId.getContext().length);
        }

        protected final ShardSearchFailure[] buildShardFailures() {
            Queue<ShardSearchFailure> localFailures = this.shardFailures;
            if (localFailures == null) {
                return ShardSearchFailure.EMPTY_ARRAY;
            }
            return localFailures.toArray(ShardSearchFailure.EMPTY_ARRAY);
        }

        protected final void addShardFailure(ShardSearchFailure failure) {
            if (this.shardFailures == null) {
                this.shardFailures = ConcurrentCollections.newQueue();
            }
            this.shardFailures.add(failure);
        }

        public void start() {
            DiscoveryNode node;
            if (this.scrollId.getContext().length == 0) {
                InternalSearchResponse internalResponse = new InternalSearchResponse(new InternalSearchHits(InternalSearchHits.EMPTY, Long.parseLong(this.scrollId.getAttributes().get("total_hits")), 0.0f), null, null, false);
                TransportSearchScrollScanAction.this.searchCache.releaseQueryFetchResults(this.queryFetchResults);
                this.listener.onResponse(new SearchResponse(internalResponse, this.request.scrollId(), 0, 0, 0L, this.buildShardFailures()));
                return;
            }
            int localOperations = 0;
            for (Tuple<String, Long> target : this.scrollId.getContext()) {
                node = this.nodes.get(target.v1());
                if (node != null) {
                    if (this.nodes.localNodeId().equals(node.id())) {
                        ++localOperations;
                        continue;
                    }
                    this.executePhase(node, target.v2());
                    continue;
                }
                if (TransportSearchScrollScanAction.this.logger.isDebugEnabled()) {
                    TransportSearchScrollScanAction.this.logger.debug("Node [" + target.v1() + "] not available for scroll request [" + this.scrollId.getSource() + "]", new Object[0]);
                }
                this.successfulOps.decrementAndGet();
                if (this.counter.decrementAndGet() != 0) continue;
                this.finishHim();
            }
            if (localOperations > 0) {
                if (this.request.operationThreading() == SearchOperationThreading.SINGLE_THREAD) {
                    TransportSearchScrollScanAction.this.threadPool.executor("search").execute(new Runnable(){

                        @Override
                        public void run() {
                            for (Tuple<String, Long> target : AsyncAction.this.scrollId.getContext()) {
                                DiscoveryNode node = AsyncAction.this.nodes.get(target.v1());
                                if (node == null || !AsyncAction.this.nodes.localNodeId().equals(node.id())) continue;
                                AsyncAction.this.executePhase(node, target.v2());
                            }
                        }
                    });
                } else {
                    boolean localAsync = this.request.operationThreading() == SearchOperationThreading.THREAD_PER_SHARD;
                    for (final Tuple<String, Long> target : this.scrollId.getContext()) {
                        final DiscoveryNode node2 = this.nodes.get(target.v1());
                        if (node2 == null || !this.nodes.localNodeId().equals(node2.id())) continue;
                        if (localAsync) {
                            TransportSearchScrollScanAction.this.threadPool.executor("search").execute(new Runnable(){

                                @Override
                                public void run() {
                                    AsyncAction.this.executePhase(node2, (Long)target.v2());
                                }
                            });
                            continue;
                        }
                        this.executePhase(node2, target.v2());
                    }
                }
            }
            for (Tuple<String, Long> target : this.scrollId.getContext()) {
                node = this.nodes.get(target.v1());
                if (node != null) continue;
                if (TransportSearchScrollScanAction.this.logger.isDebugEnabled()) {
                    TransportSearchScrollScanAction.this.logger.debug("Node [" + target.v1() + "] not available for scroll request [" + this.scrollId.getSource() + "]", new Object[0]);
                }
                this.successfulOps.decrementAndGet();
                if (this.counter.decrementAndGet() != 0) continue;
                this.finishHim();
            }
        }

        private void executePhase(DiscoveryNode node, final long searchId) {
            TransportSearchScrollScanAction.this.searchService.sendExecuteScan(node, TransportSearchHelper.internalScrollSearchRequest(searchId, this.request), new SearchServiceListener<QueryFetchSearchResult>(){

                @Override
                public void onResult(QueryFetchSearchResult result) {
                    AsyncAction.this.queryFetchResults.put(result.shardTarget(), result);
                    if (AsyncAction.this.counter.decrementAndGet() == 0) {
                        AsyncAction.this.finishHim();
                    }
                }

                @Override
                public void onFailure(Throwable t) {
                    if (TransportSearchScrollScanAction.this.logger.isDebugEnabled()) {
                        TransportSearchScrollScanAction.this.logger.debug("[{}] Failed to execute query phase", t, searchId);
                    }
                    AsyncAction.this.addShardFailure(new ShardSearchFailure(t));
                    AsyncAction.this.successfulOps.decrementAndGet();
                    if (AsyncAction.this.counter.decrementAndGet() == 0) {
                        AsyncAction.this.finishHim();
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void finishHim() {
            try {
                this.innerFinishHim();
            }
            catch (Exception e) {
                ReduceSearchPhaseException failure = new ReduceSearchPhaseException("fetch", "", e, this.buildShardFailures());
                if (TransportSearchScrollScanAction.this.logger.isDebugEnabled()) {
                    TransportSearchScrollScanAction.this.logger.debug("failed to reduce search", failure, new Object[0]);
                }
                this.listener.onFailure(failure);
            }
            finally {
                TransportSearchScrollScanAction.this.searchCache.releaseQueryFetchResults(this.queryFetchResults);
            }
        }

        private void innerFinishHim() throws IOException {
            int numberOfHits = 0;
            for (QueryFetchSearchResult shardResult : this.queryFetchResults.values()) {
                numberOfHits += shardResult.queryResult().topDocs().scoreDocs.length;
            }
            ShardDoc[] docs = new ShardDoc[numberOfHits];
            int counter = 0;
            for (QueryFetchSearchResult shardResult : this.queryFetchResults.values()) {
                ScoreDoc[] scoreDocs;
                for (ScoreDoc scoreDoc : scoreDocs = shardResult.queryResult().topDocs().scoreDocs) {
                    docs[counter++] = new ShardScoreDoc(shardResult.shardTarget(), scoreDoc.doc, 0.0f);
                }
            }
            InternalSearchResponse internalResponse = TransportSearchScrollScanAction.this.searchPhaseController.merge(docs, this.queryFetchResults, this.queryFetchResults);
            ((InternalSearchHits)internalResponse.hits()).totalHits = Long.parseLong(this.scrollId.getAttributes().get("total_hits"));
            for (QueryFetchSearchResult shardResult : this.queryFetchResults.values()) {
                if (shardResult.queryResult().topDocs().scoreDocs.length >= shardResult.queryResult().size()) continue;
                this.queryFetchResults.remove(shardResult.shardTarget());
            }
            String scrollId = null;
            if (this.request.scroll() != null) {
                scrollId = TransportSearchHelper.buildScrollId(this.scrollId.getType(), this.queryFetchResults.values(), this.scrollId.getAttributes());
            }
            this.listener.onResponse(new SearchResponse(internalResponse, scrollId, this.scrollId.getContext().length, this.successfulOps.get(), System.currentTimeMillis() - this.startTime, this.buildShardFailures()));
        }
    }
}

