/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.suggest;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastOperationResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.search.suggest.Suggest;

public final class SuggestResponse
extends BroadcastOperationResponse {
    private final Suggest suggest;

    SuggestResponse(Suggest suggest) {
        this.suggest = suggest;
    }

    SuggestResponse(Suggest suggest, int totalShards, int successfulShards, int failedShards, List<ShardOperationFailedException> shardFailures) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.suggest = suggest;
    }

    public Suggest getSuggest() {
        return this.suggest;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.suggest.readFrom(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.suggest.writeTo(out);
    }

    public String toString() {
        String source;
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            this.suggest.toXContent(builder, null);
            source = XContentHelper.convertToJson(builder.bytes(), true);
        }
        catch (IOException e) {
            source = "Error: " + e.getMessage();
        }
        return "Suggest Response[" + source + "]";
    }
}

