/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import org.elasticsearch.ElasticSearchIllegalArgumentException;

public enum IgnoreIndices {
    DEFAULT(0),
    NONE(1),
    MISSING(2);

    private final byte id;

    private IgnoreIndices(byte id) {
        this.id = id;
    }

    public byte id() {
        return this.id;
    }

    public static IgnoreIndices fromId(byte id) {
        if (id == 0) {
            return DEFAULT;
        }
        if (id == 1) {
            return NONE;
        }
        if (id == 2) {
            return MISSING;
        }
        throw new ElasticSearchIllegalArgumentException("No valid missing index type id: " + id);
    }

    public static IgnoreIndices fromString(String type) {
        if ("none".equals(type)) {
            return NONE;
        }
        if ("missing".equals(type)) {
            return MISSING;
        }
        throw new ElasticSearchIllegalArgumentException("No valid missing index type: " + type);
    }
}

