/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.broadcast;

import java.util.Locale;
import org.elasticsearch.ElasticSearchIllegalArgumentException;

public enum BroadcastOperationThreading {
    NO_THREADS(0),
    SINGLE_THREAD(1),
    THREAD_PER_SHARD(2);

    private final byte id;

    private BroadcastOperationThreading(byte id) {
        this.id = id;
    }

    public byte id() {
        return this.id;
    }

    public static BroadcastOperationThreading fromId(byte id) {
        if (id == 0) {
            return NO_THREADS;
        }
        if (id == 1) {
            return SINGLE_THREAD;
        }
        if (id == 2) {
            return THREAD_PER_SHARD;
        }
        throw new ElasticSearchIllegalArgumentException("No type matching id [" + id + "]");
    }

    public static BroadcastOperationThreading fromString(String value, BroadcastOperationThreading defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return BroadcastOperationThreading.valueOf(value.toUpperCase(Locale.ROOT));
    }
}

