/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.action.shard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.ProcessedClusterStateUpdateTask;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.ImmutableShardRouting;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class ShardStateAction
extends AbstractComponent {
    private final TransportService transportService;
    private final ClusterService clusterService;
    private final AllocationService allocationService;
    private final ThreadPool threadPool;
    private final BlockingQueue<ShardRouting> startedShardsQueue = ConcurrentCollections.newBlockingQueue();
    private final AtomicBoolean rerouteRequired = new AtomicBoolean();

    @Inject
    public ShardStateAction(Settings settings, ClusterService clusterService, TransportService transportService, AllocationService allocationService, ThreadPool threadPool) {
        super(settings);
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.allocationService = allocationService;
        this.threadPool = threadPool;
        transportService.registerHandler("cluster/shardStarted", new ShardStartedTransportHandler());
        transportService.registerHandler("cluster/shardFailure", new ShardFailedTransportHandler());
    }

    public void shardFailed(ShardRouting shardRouting, String reason) throws ElasticSearchException {
        this.logger.warn("sending failed shard for {}, reason [{}]", shardRouting, reason);
        DiscoveryNodes nodes = this.clusterService.state().nodes();
        if (nodes.localNodeMaster()) {
            this.innerShardFailed(shardRouting, reason);
        } else {
            this.transportService.sendRequest(this.clusterService.state().nodes().masterNode(), "cluster/shardFailure", new ShardRoutingEntry(shardRouting, reason), new EmptyTransportResponseHandler("same"){

                @Override
                public void handleException(TransportException exp) {
                    ShardStateAction.this.logger.warn("failed to send failed shard to [{}]", exp, ShardStateAction.this.clusterService.state().nodes().masterNode());
                }
            });
        }
    }

    public void shardStarted(ShardRouting shardRouting, String reason) throws ElasticSearchException {
        DiscoveryNodes nodes;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("sending shard started for {}, reason [{}]", shardRouting, reason);
        }
        if ((nodes = this.clusterService.state().nodes()).localNodeMaster()) {
            this.innerShardStarted(shardRouting, reason);
        } else {
            this.transportService.sendRequest(this.clusterService.state().nodes().masterNode(), "cluster/shardStarted", new ShardRoutingEntry(shardRouting, reason), new EmptyTransportResponseHandler("same"){

                @Override
                public void handleException(TransportException exp) {
                    ShardStateAction.this.logger.warn("failed to send shard started to [{}]", exp, ShardStateAction.this.clusterService.state().nodes().masterNode());
                }
            });
        }
    }

    private void innerShardFailed(final ShardRouting shardRouting, final String reason) {
        this.logger.warn("received shard failed for {}, reason [{}]", shardRouting, reason);
        this.clusterService.submitStateUpdateTask("shard-failed (" + shardRouting + "), reason [" + reason + "]", Priority.HIGH, new ClusterStateUpdateTask(){

            @Override
            public ClusterState execute(ClusterState currentState) {
                RoutingAllocation.Result routingResult;
                if (ShardStateAction.this.logger.isDebugEnabled()) {
                    ShardStateAction.this.logger.debug("Received failed shard {}, reason [{}]", shardRouting, reason);
                }
                if (!(routingResult = ShardStateAction.this.allocationService.applyFailedShard(currentState, shardRouting)).changed()) {
                    return currentState;
                }
                if (ShardStateAction.this.logger.isDebugEnabled()) {
                    ShardStateAction.this.logger.debug("Applying failed shard {}, reason [{}]", shardRouting, reason);
                }
                return ClusterState.newClusterStateBuilder().state(currentState).routingResult(routingResult).build();
            }
        });
    }

    private void innerShardStarted(final ShardRouting shardRouting, final String reason) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("received shard started for {}, reason [{}]", shardRouting, reason);
        }
        this.startedShardsQueue.add(shardRouting);
        this.clusterService.submitStateUpdateTask("shard-started (" + shardRouting + "), reason [" + reason + "]", Priority.HIGH, new ProcessedClusterStateUpdateTask(){

            @Override
            public ClusterState execute(ClusterState currentState) {
                RoutingAllocation.Result routingResult;
                ArrayList shards = new ArrayList();
                ShardStateAction.this.startedShardsQueue.drainTo(shards);
                if (shards.isEmpty()) {
                    return currentState;
                }
                RoutingTable routingTable = currentState.routingTable();
                for (int i = 0; i < shards.size(); ++i) {
                    ShardRouting shardRouting2 = (ShardRouting)shards.get(i);
                    IndexRoutingTable indexRoutingTable = routingTable.index(shardRouting2.index());
                    if (indexRoutingTable == null) {
                        shards.remove(i);
                        continue;
                    }
                    IndexShardRoutingTable indexShardRoutingTable = indexRoutingTable.shard(shardRouting2.id());
                    for (ShardRouting entry : indexShardRoutingTable) {
                        if (!shardRouting2.currentNodeId().equals(entry.currentNodeId()) || !entry.started()) continue;
                        shards.remove(i);
                    }
                }
                if (shards.isEmpty()) {
                    return currentState;
                }
                if (ShardStateAction.this.logger.isDebugEnabled()) {
                    ShardStateAction.this.logger.debug("applying started shards {}, reason [{}]", shards, reason);
                }
                if (!(routingResult = ShardStateAction.this.allocationService.applyStartedShards(currentState, shards, false)).changed()) {
                    return currentState;
                }
                return ClusterState.newClusterStateBuilder().state(currentState).routingResult(routingResult).build();
            }

            @Override
            public void clusterStateProcessed(ClusterState clusterState) {
                ShardStateAction.this.rerouteRequired.set(true);
                ShardStateAction.this.clusterService.submitStateUpdateTask("reroute post shard-started (" + shardRouting + "), reason [" + reason + "]", new ClusterStateUpdateTask(){

                    @Override
                    public ClusterState execute(ClusterState currentState) {
                        if (ShardStateAction.this.rerouteRequired.compareAndSet(true, false)) {
                            RoutingAllocation.Result routingResult = ShardStateAction.this.allocationService.reroute(currentState);
                            if (!routingResult.changed()) {
                                return currentState;
                            }
                            return ClusterState.newClusterStateBuilder().state(currentState).routingResult(routingResult).build();
                        }
                        return currentState;
                    }
                });
            }
        });
    }

    static class ShardRoutingEntry
    extends TransportRequest {
        private ShardRouting shardRouting;
        private String reason;

        private ShardRoutingEntry() {
        }

        private ShardRoutingEntry(ShardRouting shardRouting, String reason) {
            this.shardRouting = shardRouting;
            this.reason = reason;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.shardRouting = ImmutableShardRouting.readShardRoutingEntry(in);
            this.reason = in.readString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardRouting.writeTo(out);
            out.writeString(this.reason);
        }
    }

    class ShardStartedTransportHandler
    extends BaseTransportRequestHandler<ShardRoutingEntry> {
        static final String ACTION = "cluster/shardStarted";

        ShardStartedTransportHandler() {
        }

        @Override
        public ShardRoutingEntry newInstance() {
            return new ShardRoutingEntry();
        }

        @Override
        public void messageReceived(ShardRoutingEntry request, TransportChannel channel) throws Exception {
            ShardStateAction.this.innerShardStarted(request.shardRouting, request.reason);
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }

        @Override
        public String executor() {
            return "same";
        }
    }

    private class ShardFailedTransportHandler
    extends BaseTransportRequestHandler<ShardRoutingEntry> {
        static final String ACTION = "cluster/shardFailure";

        private ShardFailedTransportHandler() {
        }

        @Override
        public ShardRoutingEntry newInstance() {
            return new ShardRoutingEntry();
        }

        @Override
        public void messageReceived(ShardRoutingEntry request, TransportChannel channel) throws Exception {
            ShardStateAction.this.innerShardFailed(request.shardRouting, request.reason);
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }

        @Override
        public String executor() {
            return "same";
        }
    }
}

