/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ProcessedClusterStateUpdateTask;
import org.elasticsearch.cluster.action.index.NodeIndexCreatedAction;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.metadata.MetaDataService;
import org.elasticsearch.cluster.metadata.MetaDataStateIndexService;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.compress.CompressedString;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.Closeables;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.indices.IndexAlreadyExistsException;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.InvalidIndexNameException;
import org.elasticsearch.river.RiverIndexName;
import org.elasticsearch.threadpool.ThreadPool;

public class MetaDataCreateIndexService
extends AbstractComponent {
    private final Environment environment;
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final AllocationService allocationService;
    private final NodeIndexCreatedAction nodeIndexCreatedAction;
    private final MetaDataService metaDataService;
    private final String riverIndexName;

    @Inject
    public MetaDataCreateIndexService(Settings settings, Environment environment, ThreadPool threadPool, ClusterService clusterService, IndicesService indicesService, AllocationService allocationService, NodeIndexCreatedAction nodeIndexCreatedAction, MetaDataService metaDataService, @RiverIndexName String riverIndexName) {
        super(settings);
        this.environment = environment;
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.allocationService = allocationService;
        this.nodeIndexCreatedAction = nodeIndexCreatedAction;
        this.metaDataService = metaDataService;
        this.riverIndexName = riverIndexName;
    }

    public void createIndex(final Request request, Listener userListener) {
        ImmutableSettings.Builder updatedSettingsBuilder = ImmutableSettings.settingsBuilder();
        for (Map.Entry entry : request.settings.getAsMap().entrySet()) {
            if (!((String)entry.getKey()).startsWith("index.")) {
                updatedSettingsBuilder.put("index." + (String)entry.getKey(), (String)entry.getValue());
                continue;
            }
            updatedSettingsBuilder.put((String)entry.getKey(), (String)entry.getValue());
        }
        request.settings(updatedSettingsBuilder.build());
        MetaDataService.MdLock mdLock = this.metaDataService.indexMetaDataLock(request.index);
        try {
            mdLock.lock();
        }
        catch (InterruptedException e) {
            userListener.onFailure(e);
            return;
        }
        final CreateIndexListener listener = new CreateIndexListener(mdLock, request, userListener);
        this.clusterService.submitStateUpdateTask("create-index [" + request.index + "], cause [" + request.cause + "]", Priority.URGENT, new ProcessedClusterStateUpdateTask(){

            @Override
            public ClusterState execute(ClusterState currentState) {
                boolean indexCreated = false;
                String failureReason = null;
                try {
                    IndexMetaData indexMetaData;
                    try {
                        MetaDataCreateIndexService.this.validate(request, currentState);
                    }
                    catch (Throwable e) {
                        listener.onFailure(e);
                        return currentState;
                    }
                    List templates = MetaDataCreateIndexService.this.findTemplates(request, currentState);
                    HashMap<String, Object> customs = Maps.newHashMap();
                    HashMap<String, Map> mappings = Maps.newHashMap();
                    if (request.index.equals("_percolator")) {
                        mappings.put("_default_", MetaDataCreateIndexService.this.parseMapping("{\n    \"_default_\":{\n        \"properties\" : {\n            \"query\" : {\n                \"type\" : \"object\",\n                \"enabled\" : false\n            }\n        }\n    }\n}"));
                    }
                    for (Map.Entry<String, String> entry : request.mappings.entrySet()) {
                        mappings.put(entry.getKey(), MetaDataCreateIndexService.this.parseMapping(entry.getValue()));
                    }
                    for (Map.Entry<String, Object> entry : request.customs.entrySet()) {
                        customs.put(entry.getKey(), entry.getValue());
                    }
                    for (IndexTemplateMetaData indexTemplateMetaData : templates) {
                        for (Map.Entry entry : indexTemplateMetaData.mappings().entrySet()) {
                            if (mappings.containsKey(entry.getKey())) {
                                XContentHelper.mergeDefaults((Map)mappings.get(entry.getKey()), MetaDataCreateIndexService.this.parseMapping(((CompressedString)entry.getValue()).string()));
                                continue;
                            }
                            mappings.put((String)entry.getKey(), MetaDataCreateIndexService.this.parseMapping(((CompressedString)entry.getValue()).string()));
                        }
                        for (Map.Entry customEntry : indexTemplateMetaData.customs().entrySet()) {
                            String type = (String)customEntry.getKey();
                            IndexMetaData.Custom custom = (IndexMetaData.Custom)customEntry.getValue();
                            IndexMetaData.Custom existing = (IndexMetaData.Custom)customs.get(type);
                            if (existing == null) {
                                customs.put(type, custom);
                                continue;
                            }
                            IndexMetaData.Custom merged = IndexMetaData.lookupFactorySafe(type).merge(existing, custom);
                            customs.put(type, merged);
                        }
                    }
                    File mappingsDir = new File(MetaDataCreateIndexService.this.environment.configFile(), "mappings");
                    if (mappingsDir.exists() && mappingsDir.isDirectory()) {
                        File defaultMappingsDir;
                        File file = new File(mappingsDir, request.index);
                        if (file.exists() && file.isDirectory()) {
                            MetaDataCreateIndexService.this.addMappings(mappings, file);
                        }
                        if ((defaultMappingsDir = new File(mappingsDir, "_default")).exists() && defaultMappingsDir.isDirectory()) {
                            MetaDataCreateIndexService.this.addMappings(mappings, defaultMappingsDir);
                        }
                    }
                    ImmutableSettings.Builder builder = ImmutableSettings.settingsBuilder();
                    for (int i = templates.size() - 1; i >= 0; --i) {
                        builder.put(((IndexTemplateMetaData)templates.get(i)).settings());
                    }
                    builder.put(request.settings);
                    if (request.index.equals("_percolator")) {
                        builder.put("index.number_of_shards", 1);
                    } else if (builder.get("index.number_of_shards") == null) {
                        if (request.index.equals(MetaDataCreateIndexService.this.riverIndexName)) {
                            builder.put("index.number_of_shards", MetaDataCreateIndexService.this.settings.getAsInt("index.number_of_shards", (Integer)1));
                        } else {
                            builder.put("index.number_of_shards", MetaDataCreateIndexService.this.settings.getAsInt("index.number_of_shards", (Integer)5));
                        }
                    }
                    if (request.index.equals("_percolator")) {
                        builder.put("index.number_of_replicas", 0);
                        builder.put("index.auto_expand_replicas", "0-all");
                    } else if (builder.get("index.number_of_replicas") == null) {
                        if (request.index.equals(MetaDataCreateIndexService.this.riverIndexName)) {
                            builder.put("index.number_of_replicas", MetaDataCreateIndexService.this.settings.getAsInt("index.number_of_replicas", (Integer)1));
                        } else {
                            builder.put("index.number_of_replicas", MetaDataCreateIndexService.this.settings.getAsInt("index.number_of_replicas", (Integer)1));
                        }
                    }
                    if (MetaDataCreateIndexService.this.settings.get("index.auto_expand_replicas") != null && builder.get("index.auto_expand_replicas") == null) {
                        builder.put("index.auto_expand_replicas", MetaDataCreateIndexService.this.settings.get("index.auto_expand_replicas"));
                    }
                    builder.put("index.version.created", Version.CURRENT);
                    Settings actualIndexSettings = builder.build();
                    MetaDataCreateIndexService.this.indicesService.createIndex(request.index, actualIndexSettings, MetaDataCreateIndexService.this.clusterService.state().nodes().localNode().id());
                    indexCreated = true;
                    IndexService indexService = MetaDataCreateIndexService.this.indicesService.indexServiceSafe(request.index);
                    MapperService mapperService = indexService.mapperService();
                    if (mappings.containsKey("_default_")) {
                        try {
                            mapperService.merge("_default_", XContentFactory.jsonBuilder().map((Map)mappings.get("_default_")).string(), false);
                        }
                        catch (Exception e) {
                            failureReason = "failed on parsing default mapping on index creation";
                            throw new MapperParsingException("mapping [_default_]", e);
                        }
                    }
                    for (Map.Entry entry : mappings.entrySet()) {
                        if (((String)entry.getKey()).equals("_default_")) continue;
                        try {
                            mapperService.merge((String)entry.getKey(), XContentFactory.jsonBuilder().map((Map)entry.getValue()).string(), true);
                        }
                        catch (Exception e) {
                            failureReason = "failed on parsing mappings on index creation";
                            throw new MapperParsingException("mapping [" + (String)entry.getKey() + "]", e);
                        }
                    }
                    HashMap<String, MappingMetaData> mappingsMetaData = Maps.newHashMap();
                    for (DocumentMapper mapper : mapperService) {
                        MappingMetaData mappingMetaData = new MappingMetaData(mapper);
                        mappingsMetaData.put(mapper.type(), mappingMetaData);
                    }
                    IndexMetaData.Builder indexMetaDataBuilder = IndexMetaData.newIndexMetaDataBuilder(request.index).settings(actualIndexSettings);
                    for (MappingMetaData mappingMetaData : mappingsMetaData.values()) {
                        indexMetaDataBuilder.putMapping(mappingMetaData);
                    }
                    for (Map.Entry entry : customs.entrySet()) {
                        indexMetaDataBuilder.putCustom((String)entry.getKey(), (IndexMetaData.Custom)entry.getValue());
                    }
                    indexMetaDataBuilder.state(request.state);
                    try {
                        indexMetaData = indexMetaDataBuilder.build();
                    }
                    catch (Exception exception) {
                        failureReason = "failed to build index metadata";
                        throw exception;
                    }
                    MetaData metaData = MetaData.newMetaDataBuilder().metaData(currentState.metaData()).put(indexMetaData, false).build();
                    MetaDataCreateIndexService.this.logger.info("[{}] creating index, cause [{}], shards [{}]/[{}], mappings {}", request.index, request.cause, indexMetaData.numberOfShards(), indexMetaData.numberOfReplicas(), mappings.keySet());
                    ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
                    if (!request.blocks.isEmpty()) {
                        for (ClusterBlock block : request.blocks) {
                            blocks.addIndexBlock(request.index, block);
                        }
                    }
                    if (request.state == IndexMetaData.State.CLOSE) {
                        blocks.addIndexBlock(request.index, MetaDataStateIndexService.INDEX_CLOSED_BLOCK);
                    }
                    ClusterState updatedState = ClusterState.newClusterStateBuilder().state(currentState).blocks(blocks).metaData(metaData).build();
                    if (request.state == IndexMetaData.State.OPEN) {
                        RoutingTable.Builder routingTableBuilder = RoutingTable.builder().routingTable(updatedState.routingTable()).addAsNew(updatedState.metaData().index(request.index));
                        RoutingAllocation.Result routingResult = MetaDataCreateIndexService.this.allocationService.reroute(ClusterState.newClusterStateBuilder().state(updatedState).routingTable(routingTableBuilder).build());
                        updatedState = ClusterState.newClusterStateBuilder().state(updatedState).routingResult(routingResult).build();
                    }
                    final AtomicInteger counter = new AtomicInteger(currentState.nodes().size());
                    final NodeIndexCreatedAction.Listener nodeIndexCreatedListener = new NodeIndexCreatedAction.Listener(){

                        @Override
                        public void onNodeIndexCreated(String index, String nodeId) {
                            if (index.equals(request.index) && counter.decrementAndGet() == 0) {
                                listener.onResponse(new Response(true, indexMetaData));
                                MetaDataCreateIndexService.this.nodeIndexCreatedAction.remove(this);
                            }
                        }
                    };
                    MetaDataCreateIndexService.this.nodeIndexCreatedAction.add(nodeIndexCreatedListener);
                    listener.future = MetaDataCreateIndexService.this.threadPool.schedule(request.timeout, "same", new Runnable(){

                        @Override
                        public void run() {
                            listener.onResponse(new Response(false, indexMetaData));
                            MetaDataCreateIndexService.this.nodeIndexCreatedAction.remove(nodeIndexCreatedListener);
                        }
                    });
                    return updatedState;
                }
                catch (Throwable e) {
                    MetaDataCreateIndexService.this.logger.warn("[{}] failed to create", e, request.index);
                    if (indexCreated) {
                        MetaDataCreateIndexService.this.indicesService.removeIndex(request.index, failureReason != null ? failureReason : "failed to create index");
                    }
                    listener.onFailure(e);
                    return currentState;
                }
            }

            @Override
            public void clusterStateProcessed(ClusterState clusterState) {
            }
        });
    }

    private Map<String, Object> parseMapping(String mappingSource) throws Exception {
        return XContentFactory.xContent(mappingSource).createParser(mappingSource).mapAndClose();
    }

    private void addMappings(Map<String, Map<String, Object>> mappings, File mappingsDir) {
        File[] mappingsFiles;
        for (File mappingFile : mappingsFiles = mappingsDir.listFiles()) {
            if (mappingFile.isHidden()) continue;
            int lastDotIndex = mappingFile.getName().lastIndexOf(46);
            String mappingType = lastDotIndex != -1 ? mappingFile.getName().substring(0, lastDotIndex) : mappingFile.getName();
            try {
                String mappingSource = Streams.copyToString(new InputStreamReader((InputStream)new FileInputStream(mappingFile), Streams.UTF8));
                if (mappings.containsKey(mappingType)) {
                    XContentHelper.mergeDefaults(mappings.get(mappingType), this.parseMapping(mappingSource));
                    continue;
                }
                mappings.put(mappingType, this.parseMapping(mappingSource));
            }
            catch (Exception e) {
                this.logger.warn("failed to read / parse mapping [" + mappingType + "] from location [" + mappingFile + "], ignoring...", e, new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IndexTemplateMetaData> findTemplates(Request request, ClusterState state) {
        File[] templatesFiles;
        ArrayList<IndexTemplateMetaData> templates = Lists.newArrayList();
        for (IndexTemplateMetaData template : state.metaData().templates().values()) {
            if (!Regex.simpleMatch(template.template(), request.index)) continue;
            templates.add(template);
        }
        File templatesDir = new File(this.environment.configFile(), "templates");
        if (templatesDir.exists() && templatesDir.isDirectory() && (templatesFiles = templatesDir.listFiles()) != null) {
            for (File templatesFile : templatesFiles) {
                XContentParser parser;
                block7: {
                    parser = null;
                    try {
                        byte[] templatesData = Streams.copyToByteArray(templatesFile);
                        parser = XContentHelper.createParser(templatesData, 0, templatesData.length);
                        IndexTemplateMetaData template = IndexTemplateMetaData.Builder.fromXContentStandalone(parser);
                        if (!Regex.simpleMatch(template.template(), request.index)) break block7;
                        templates.add(template);
                    }
                    catch (Exception e) {
                        try {
                            this.logger.warn("[{}] failed to read template [{}] from config", e, request.index, templatesFile.getAbsolutePath());
                        }
                        catch (Throwable throwable) {
                            Closeables.closeQuietly(parser);
                            throw throwable;
                        }
                        Closeables.closeQuietly(parser);
                        continue;
                    }
                }
                Closeables.closeQuietly(parser);
            }
        }
        Collections.sort(templates, new Comparator<IndexTemplateMetaData>(){

            @Override
            public int compare(IndexTemplateMetaData o1, IndexTemplateMetaData o2) {
                return o2.order() - o1.order();
            }
        });
        return templates;
    }

    private void validate(Request request, ClusterState state) throws ElasticSearchException {
        if (state.routingTable().hasIndex(request.index)) {
            throw new IndexAlreadyExistsException(new Index(request.index));
        }
        if (state.metaData().hasIndex(request.index)) {
            throw new IndexAlreadyExistsException(new Index(request.index));
        }
        if (request.index.contains(" ")) {
            throw new InvalidIndexNameException(new Index(request.index), request.index, "must not contain whitespace");
        }
        if (request.index.contains(",")) {
            throw new InvalidIndexNameException(new Index(request.index), request.index, "must not contain ',");
        }
        if (request.index.contains("#")) {
            throw new InvalidIndexNameException(new Index(request.index), request.index, "must not contain '#");
        }
        if (!request.index.equals(this.riverIndexName) && !request.index.equals("_percolator") && request.index.charAt(0) == '_') {
            throw new InvalidIndexNameException(new Index(request.index), request.index, "must not start with '_'");
        }
        if (!request.index.toLowerCase(Locale.ROOT).equals(request.index)) {
            throw new InvalidIndexNameException(new Index(request.index), request.index, "must be lowercase");
        }
        if (!Strings.validFileName(request.index)) {
            throw new InvalidIndexNameException(new Index(request.index), request.index, "must not contain the following characters " + Strings.INVALID_FILENAME_CHARS);
        }
        if (state.metaData().aliases().containsKey(request.index)) {
            throw new InvalidIndexNameException(new Index(request.index), request.index, "an alias with the same name already exists");
        }
    }

    public static class Response {
        private final boolean acknowledged;
        private final IndexMetaData indexMetaData;

        public Response(boolean acknowledged, IndexMetaData indexMetaData) {
            this.acknowledged = acknowledged;
            this.indexMetaData = indexMetaData;
        }

        public boolean acknowledged() {
            return this.acknowledged;
        }

        public IndexMetaData indexMetaData() {
            return this.indexMetaData;
        }
    }

    public static class Request {
        final String cause;
        final String index;
        IndexMetaData.State state = IndexMetaData.State.OPEN;
        Settings settings = ImmutableSettings.Builder.EMPTY_SETTINGS;
        Map<String, String> mappings = Maps.newHashMap();
        Map<String, IndexMetaData.Custom> customs = Maps.newHashMap();
        TimeValue timeout = TimeValue.timeValueSeconds(5L);
        Set<ClusterBlock> blocks = Sets.newHashSet();

        public Request(String cause, String index) {
            this.cause = cause;
            this.index = index;
        }

        public Request settings(Settings settings) {
            this.settings = settings;
            return this;
        }

        public Request mappings(Map<String, String> mappings) {
            this.mappings.putAll(mappings);
            return this;
        }

        public Request mappingsMetaData(Map<String, MappingMetaData> mappings) throws IOException {
            for (Map.Entry<String, MappingMetaData> entry : mappings.entrySet()) {
                this.mappings.put(entry.getKey(), entry.getValue().source().string());
            }
            return this;
        }

        public Request mappingsCompressed(Map<String, CompressedString> mappings) throws IOException {
            for (Map.Entry<String, CompressedString> entry : mappings.entrySet()) {
                this.mappings.put(entry.getKey(), entry.getValue().string());
            }
            return this;
        }

        public Request customs(Map<String, IndexMetaData.Custom> customs) {
            this.customs.putAll(customs);
            return this;
        }

        public Request blocks(Set<ClusterBlock> blocks) {
            this.blocks.addAll(blocks);
            return this;
        }

        public Request state(IndexMetaData.State state) {
            this.state = state;
            return this;
        }

        public Request timeout(TimeValue timeout) {
            this.timeout = timeout;
            return this;
        }
    }

    public static interface Listener {
        public void onResponse(Response var1);

        public void onFailure(Throwable var1);
    }

    class CreateIndexListener
    implements Listener {
        private final AtomicBoolean notified = new AtomicBoolean();
        private final MetaDataService.MdLock mdLock;
        private final Request request;
        private final Listener listener;
        volatile ScheduledFuture future;

        private CreateIndexListener(MetaDataService.MdLock mdLock, Request request, Listener listener) {
            this.mdLock = mdLock;
            this.request = request;
            this.listener = listener;
        }

        @Override
        public void onResponse(Response response) {
            if (this.notified.compareAndSet(false, true)) {
                this.mdLock.unlock();
                if (this.future != null) {
                    this.future.cancel(false);
                }
                this.listener.onResponse(response);
            }
        }

        @Override
        public void onFailure(Throwable t) {
            if (this.notified.compareAndSet(false, true)) {
                this.mdLock.unlock();
                if (this.future != null) {
                    this.future.cancel(false);
                }
                this.listener.onFailure(t);
            }
        }
    }
}

