/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.settings;

import org.elasticsearch.cluster.settings.ClusterDynamicSettings;
import org.elasticsearch.cluster.settings.DynamicSettings;
import org.elasticsearch.cluster.settings.Validator;
import org.elasticsearch.common.inject.AbstractModule;

public class ClusterDynamicSettingsModule
extends AbstractModule {
    private final DynamicSettings clusterDynamicSettings = new DynamicSettings();

    public ClusterDynamicSettingsModule() {
        this.clusterDynamicSettings.addDynamicSetting("cluster.routing.allocation.awareness.attributes");
        this.clusterDynamicSettings.addDynamicSetting("cluster.routing.allocation.awareness.force.*");
        this.clusterDynamicSettings.addDynamicSetting("cluster.routing.allocation.balance.index", Validator.FLOAT);
        this.clusterDynamicSettings.addDynamicSetting("cluster.routing.allocation.balance.primary", Validator.FLOAT);
        this.clusterDynamicSettings.addDynamicSetting("cluster.routing.allocation.balance.shard", Validator.FLOAT);
        this.clusterDynamicSettings.addDynamicSetting("cluster.routing.allocation.balance.threshold", Validator.NON_NEGATIVE_FLOAT);
        this.clusterDynamicSettings.addDynamicSetting("cluster.routing.allocation.cluster_concurrent_rebalance", Validator.INTEGER);
        this.clusterDynamicSettings.addDynamicSetting("cluster.routing.allocation.disable_new_allocation");
        this.clusterDynamicSettings.addDynamicSetting("cluster.routing.allocation.disable_allocation");
        this.clusterDynamicSettings.addDynamicSetting("cluster.routing.allocation.disable_replica_allocation");
        this.clusterDynamicSettings.addDynamicSetting("discovery.zen.minimum_master_nodes", Validator.INTEGER);
        this.clusterDynamicSettings.addDynamicSetting("cluster.routing.allocation.include.*");
        this.clusterDynamicSettings.addDynamicSetting("cluster.routing.allocation.exclude.*");
        this.clusterDynamicSettings.addDynamicSetting("cluster.routing.allocation.require.*");
        this.clusterDynamicSettings.addDynamicSetting("indices.cache.filter.size");
        this.clusterDynamicSettings.addDynamicSetting("indices.cache.filter.expire", Validator.TIME);
        this.clusterDynamicSettings.addDynamicSetting("indices.store.throttle.type");
        this.clusterDynamicSettings.addDynamicSetting("indices.store.throttle.max_bytes_per_sec", Validator.BYTES_SIZE);
        this.clusterDynamicSettings.addDynamicSetting("indices.ttl.interval", Validator.TIME);
        this.clusterDynamicSettings.addDynamicSetting("cluster.blocks.read_only");
        this.clusterDynamicSettings.addDynamicSetting("indices.recovery.file_chunk_size", Validator.BYTES_SIZE);
        this.clusterDynamicSettings.addDynamicSetting("indices.recovery.translog_ops", Validator.INTEGER);
        this.clusterDynamicSettings.addDynamicSetting("indices.recovery.translog_size", Validator.BYTES_SIZE);
        this.clusterDynamicSettings.addDynamicSetting("indices.recovery.compress");
        this.clusterDynamicSettings.addDynamicSetting("indices.recovery.concurrent_streams", Validator.POSITIVE_INTEGER);
        this.clusterDynamicSettings.addDynamicSetting("indices.recovery.max_bytes_per_sec", Validator.BYTES_SIZE);
        this.clusterDynamicSettings.addDynamicSetting("indices.recovery.max_size_per_sec", Validator.BYTES_SIZE);
        this.clusterDynamicSettings.addDynamicSetting("threadpool.*");
        this.clusterDynamicSettings.addDynamicSetting("cluster.routing.allocation.node_initial_primaries_recoveries", Validator.INTEGER);
        this.clusterDynamicSettings.addDynamicSetting("cluster.routing.allocation.node_concurrent_recoveries", Validator.INTEGER);
    }

    public void addDynamicSettings(String ... settings) {
        this.clusterDynamicSettings.addDynamicSettings(settings);
    }

    public void addDynamicSetting(String setting, Validator validator) {
        this.clusterDynamicSettings.addDynamicSetting(setting, validator);
    }

    @Override
    protected void configure() {
        this.bind(DynamicSettings.class).annotatedWith(ClusterDynamicSettings.class).toInstance(this.clusterDynamicSettings);
    }
}

