/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.jackson.core.sym;

import java.util.Arrays;
import org.elasticsearch.common.jackson.core.util.InternCache;

public final class CharsToNameCanonicalizer {
    public static final int HASH_MULT = 33;
    protected static final int DEFAULT_TABLE_SIZE = 64;
    protected static final int MAX_TABLE_SIZE = 65536;
    static final int MAX_ENTRIES_FOR_REUSE = 12000;
    static final int MAX_COLL_CHAIN_LENGTH = 255;
    static final int MAX_COLL_CHAIN_FOR_REUSE = 63;
    static final CharsToNameCanonicalizer sBootstrapSymbolTable = new CharsToNameCanonicalizer();
    protected CharsToNameCanonicalizer _parent;
    private final int _hashSeed;
    protected final boolean _intern;
    protected final boolean _canonicalize;
    protected String[] _symbols;
    protected Bucket[] _buckets;
    protected int _size;
    protected int _sizeThreshold;
    protected int _indexMask;
    protected int _longestCollisionList;
    protected boolean _dirty;

    public static CharsToNameCanonicalizer createRoot() {
        long l = System.currentTimeMillis();
        int n = (int)l + (int)(l >>> 32) | 1;
        return CharsToNameCanonicalizer.createRoot(n);
    }

    protected static CharsToNameCanonicalizer createRoot(int n) {
        return sBootstrapSymbolTable.makeOrphan(n);
    }

    private CharsToNameCanonicalizer() {
        this._canonicalize = true;
        this._intern = true;
        this._dirty = true;
        this._hashSeed = 0;
        this._longestCollisionList = 0;
        this.initTables(64);
    }

    private void initTables(int n) {
        this._symbols = new String[n];
        this._buckets = new Bucket[n >> 1];
        this._indexMask = n - 1;
        this._size = 0;
        this._longestCollisionList = 0;
        this._sizeThreshold = CharsToNameCanonicalizer._thresholdSize(n);
    }

    private static int _thresholdSize(int n) {
        return n - (n >> 2);
    }

    private CharsToNameCanonicalizer(CharsToNameCanonicalizer charsToNameCanonicalizer, boolean bl, boolean bl2, String[] stringArray, Bucket[] bucketArray, int n, int n2, int n3) {
        this._parent = charsToNameCanonicalizer;
        this._canonicalize = bl;
        this._intern = bl2;
        this._symbols = stringArray;
        this._buckets = bucketArray;
        this._size = n;
        this._hashSeed = n2;
        int n4 = stringArray.length;
        this._sizeThreshold = CharsToNameCanonicalizer._thresholdSize(n4);
        this._indexMask = n4 - 1;
        this._longestCollisionList = n3;
        this._dirty = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharsToNameCanonicalizer makeChild(boolean bl, boolean bl2) {
        int n;
        int n2;
        int n3;
        Bucket[] bucketArray;
        String[] stringArray;
        CharsToNameCanonicalizer charsToNameCanonicalizer = this;
        synchronized (charsToNameCanonicalizer) {
            stringArray = this._symbols;
            bucketArray = this._buckets;
            n3 = this._size;
            n2 = this._hashSeed;
            n = this._longestCollisionList;
        }
        return new CharsToNameCanonicalizer(this, bl, bl2, stringArray, bucketArray, n3, n2, n);
    }

    private CharsToNameCanonicalizer makeOrphan(int n) {
        return new CharsToNameCanonicalizer(null, true, true, this._symbols, this._buckets, this._size, n, this._longestCollisionList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeChild(CharsToNameCanonicalizer charsToNameCanonicalizer) {
        if (charsToNameCanonicalizer.size() > 12000 || charsToNameCanonicalizer._longestCollisionList > 63) {
            CharsToNameCanonicalizer charsToNameCanonicalizer2 = this;
            synchronized (charsToNameCanonicalizer2) {
                this.initTables(64);
                this._dirty = false;
            }
        }
        if (charsToNameCanonicalizer.size() <= this.size()) {
            return;
        }
        CharsToNameCanonicalizer charsToNameCanonicalizer3 = this;
        synchronized (charsToNameCanonicalizer3) {
            this._symbols = charsToNameCanonicalizer._symbols;
            this._buckets = charsToNameCanonicalizer._buckets;
            this._size = charsToNameCanonicalizer._size;
            this._sizeThreshold = charsToNameCanonicalizer._sizeThreshold;
            this._indexMask = charsToNameCanonicalizer._indexMask;
            this._longestCollisionList = charsToNameCanonicalizer._longestCollisionList;
            this._dirty = false;
        }
    }

    public void release() {
        if (!this.maybeDirty()) {
            return;
        }
        if (this._parent != null) {
            this._parent.mergeChild(this);
            this._dirty = false;
        }
    }

    public int size() {
        return this._size;
    }

    public int bucketCount() {
        return this._symbols.length;
    }

    public boolean maybeDirty() {
        return this._dirty;
    }

    public int hashSeed() {
        return this._hashSeed;
    }

    public int collisionCount() {
        int n = 0;
        for (Bucket bucket : this._buckets) {
            if (bucket == null) continue;
            n += bucket.length();
        }
        return n;
    }

    public int maxCollisionLength() {
        return this._longestCollisionList;
    }

    public String findSymbol(char[] cArray, int n, int n2, int n3) {
        Object object;
        if (n2 < 1) {
            return "";
        }
        if (!this._canonicalize) {
            return new String(cArray, n, n2);
        }
        int n4 = this._hashToIndex(n3);
        String string = this._symbols[n4];
        if (string != null) {
            if (string.length() == n2) {
                int n5 = 0;
                while (string.charAt(n5) == cArray[n + n5] && ++n5 < n2) {
                }
                if (n5 == n2) {
                    return string;
                }
            }
            if ((object = this._buckets[n4 >> 1]) != null && (string = ((Bucket)object).find(cArray, n, n2)) != null) {
                return string;
            }
        }
        if (!this._dirty) {
            this.copyArrays();
            this._dirty = true;
        } else if (this._size >= this._sizeThreshold) {
            this.rehash();
            n4 = this._hashToIndex(this.calcHash(cArray, n, n2));
        }
        object = new String(cArray, n, n2);
        if (this._intern) {
            object = InternCache.instance.intern((String)object);
        }
        ++this._size;
        if (this._symbols[n4] == null) {
            this._symbols[n4] = object;
        } else {
            Bucket bucket;
            int n6 = n4 >> 1;
            this._buckets[n6] = bucket = new Bucket((String)object, this._buckets[n6]);
            this._longestCollisionList = Math.max(bucket.length(), this._longestCollisionList);
            if (this._longestCollisionList > 255) {
                this.reportTooManyCollisions(255);
            }
        }
        return object;
    }

    public int _hashToIndex(int n) {
        n += n >>> 15;
        return n & this._indexMask;
    }

    public int calcHash(char[] cArray, int n, int n2) {
        int n3 = this._hashSeed;
        for (int i = 0; i < n2; ++i) {
            n3 = n3 * 33 + cArray[i];
        }
        return n3 == 0 ? 1 : n3;
    }

    public int calcHash(String string) {
        int n = string.length();
        int n2 = this._hashSeed;
        for (int i = 0; i < n; ++i) {
            n2 = n2 * 33 + string.charAt(i);
        }
        return n2 == 0 ? 1 : n2;
    }

    private void copyArrays() {
        String[] stringArray = this._symbols;
        int n = stringArray.length;
        this._symbols = new String[n];
        System.arraycopy(stringArray, 0, this._symbols, 0, n);
        Bucket[] bucketArray = this._buckets;
        n = bucketArray.length;
        this._buckets = new Bucket[n];
        System.arraycopy(bucketArray, 0, this._buckets, 0, n);
    }

    private void rehash() {
        int n;
        Object object;
        int n2;
        int n3 = this._symbols.length;
        int n4 = n3 + n3;
        if (n4 > 65536) {
            this._size = 0;
            Arrays.fill(this._symbols, null);
            Arrays.fill(this._buckets, null);
            this._dirty = true;
            return;
        }
        String[] stringArray = this._symbols;
        Bucket[] bucketArray = this._buckets;
        this._symbols = new String[n4];
        this._buckets = new Bucket[n4 >> 1];
        this._indexMask = n4 - 1;
        this._sizeThreshold = CharsToNameCanonicalizer._thresholdSize(n4);
        int n5 = 0;
        int n6 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            Bucket bucket;
            object = stringArray[n2];
            if (object == null) continue;
            ++n5;
            int n7 = this._hashToIndex(this.calcHash((String)object));
            if (this._symbols[n7] == null) {
                this._symbols[n7] = object;
                continue;
            }
            n = n7 >> 1;
            this._buckets[n] = bucket = new Bucket((String)object, this._buckets[n]);
            n6 = Math.max(n6, bucket.length());
        }
        n3 >>= 1;
        for (n2 = 0; n2 < n3; ++n2) {
            for (object = bucketArray[n2]; object != null; object = ((Bucket)object).getNext()) {
                Bucket bucket;
                ++n5;
                String string = ((Bucket)object).getSymbol();
                n = this._hashToIndex(this.calcHash(string));
                if (this._symbols[n] == null) {
                    this._symbols[n] = string;
                    continue;
                }
                int n8 = n >> 1;
                this._buckets[n8] = bucket = new Bucket(string, this._buckets[n8]);
                n6 = Math.max(n6, bucket.length());
            }
        }
        this._longestCollisionList = n6;
        if (n5 != this._size) {
            throw new Error("Internal error on SymbolTable.rehash(): had " + this._size + " entries; now have " + n5 + ".");
        }
    }

    protected void reportTooManyCollisions(int n) {
        throw new IllegalStateException("Longest collision chain in symbol table (of size " + this._size + ") now exceeds maximum, " + n + " -- suspect a DoS attack based on hash collisions");
    }

    static final class Bucket {
        private final String _symbol;
        private final Bucket _next;
        private final int _length;

        public Bucket(String string, Bucket bucket) {
            this._symbol = string;
            this._next = bucket;
            this._length = bucket == null ? 1 : bucket._length + 1;
        }

        public String getSymbol() {
            return this._symbol;
        }

        public Bucket getNext() {
            return this._next;
        }

        public int length() {
            return this._length;
        }

        public String find(char[] cArray, int n, int n2) {
            String string = this._symbol;
            Bucket bucket = this._next;
            while (true) {
                if (string.length() == n2) {
                    int n3 = 0;
                    while (string.charAt(n3) == cArray[n + n3] && ++n3 < n2) {
                    }
                    if (n3 == n2) {
                        return string;
                    }
                }
                if (bucket == null) break;
                string = bucket.getSymbol();
                bucket = bucket.getNext();
            }
            return null;
        }
    }
}

