/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.jackson.core.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import java.util.regex.Pattern;
import org.elasticsearch.common.jackson.core.Version;
import org.elasticsearch.common.jackson.core.Versioned;

public class VersionUtil {
    @Deprecated
    public static final String VERSION_FILE = "VERSION.txt";
    public static final String PACKAGE_VERSION_CLASS_NAME = "PackageVersion";
    private static final Pattern VERSION_SEPARATOR = Pattern.compile("[-_./;:]");
    private final Version _version;

    protected VersionUtil() {
        Version version = null;
        try {
            version = VersionUtil.versionFor(this.getClass());
        }
        catch (Exception exception) {
            System.err.println("ERROR: Failed to load Version information for bundle (via " + this.getClass().getName() + ").");
        }
        if (version == null) {
            version = Version.unknownVersion();
        }
        this._version = version;
    }

    public Version version() {
        return this._version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Version versionFor(Class<?> clazz) {
        Version version = VersionUtil.packageVersionFor(clazz);
        if (version != null) {
            return version;
        }
        InputStream inputStream = clazz.getResourceAsStream(VERSION_FILE);
        if (inputStream == null) {
            return Version.unknownVersion();
        }
        try {
            Version version2;
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            try {
                version2 = VersionUtil.doReadVersion(inputStreamReader);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        inputStreamReader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Version version3 = Version.unknownVersion();
                    return version3;
                }
            }
            try {
                inputStreamReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return version2;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    public static Version packageVersionFor(Class<?> clazz) {
        Package package_;
        Class<?> clazz2 = null;
        try {
            package_ = clazz.getPackage();
            String string = package_.getName() + "." + PACKAGE_VERSION_CLASS_NAME;
            clazz2 = Class.forName(string, true, clazz.getClassLoader());
        }
        catch (Exception exception) {
            return null;
        }
        if (clazz2 == null) {
            return null;
        }
        try {
            package_ = clazz2.newInstance();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Failed to instantiate " + clazz2.getName() + " to find version information, problem: " + exception.getMessage(), exception);
        }
        if (!(package_ instanceof Versioned)) {
            throw new IllegalArgumentException("Bad version class " + clazz2.getName() + ": does not implement " + Versioned.class.getName());
        }
        return ((Versioned)((Object)package_)).version();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Version doReadVersion(Reader reader) {
        String string = null;
        String string2 = null;
        String string3 = null;
        BufferedReader bufferedReader = new BufferedReader(reader);
        try {
            string = bufferedReader.readLine();
            if (string != null && (string2 = bufferedReader.readLine()) != null) {
                string3 = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
        }
        if (string2 != null) {
            string2 = string2.trim();
        }
        if (string3 != null) {
            string3 = string3.trim();
        }
        return VersionUtil.parseVersion(string, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Version mavenVersionFor(ClassLoader classLoader, String string, String string2) {
        InputStream inputStream = classLoader.getResourceAsStream("META-INF/maven/" + string.replaceAll("\\.", "/") + "/" + string2 + "/pom.properties");
        if (inputStream != null) {
            try {
                Properties properties = new Properties();
                properties.load(inputStream);
                String string3 = properties.getProperty("version");
                String string4 = properties.getProperty("artifactId");
                String string5 = properties.getProperty("groupId");
                Version version = VersionUtil.parseVersion(string3, string5, string4);
                return version;
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return Version.unknownVersion();
    }

    @Deprecated
    public static Version parseVersion(String string) {
        return VersionUtil.parseVersion(string, null, null);
    }

    public static Version parseVersion(String string, String string2, String string3) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        String[] stringArray = VERSION_SEPARATOR.split(string);
        int n = VersionUtil.parseVersionPart(stringArray[0]);
        int n2 = stringArray.length > 1 ? VersionUtil.parseVersionPart(stringArray[1]) : 0;
        int n3 = stringArray.length > 2 ? VersionUtil.parseVersionPart(stringArray[2]) : 0;
        String string4 = stringArray.length > 3 ? stringArray[3] : null;
        return new Version(n, n2, n3, string4, string2, string3);
    }

    protected static int parseVersionPart(String string) {
        char c;
        string = string.toString();
        int n = string.length();
        int n2 = 0;
        for (int i = 0; i < n && (c = string.charAt(i)) <= '9' && c >= '0'; ++i) {
            n2 = n2 * 10 + (c - 48);
        }
        return n2;
    }

    public static final void throwInternal() {
        throw new RuntimeException("Internal error: this code path should never get executed");
    }
}

