/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.jackson.dataformat.smile;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import org.elasticsearch.common.jackson.core.Base64Variant;
import org.elasticsearch.common.jackson.core.JsonGenerationException;
import org.elasticsearch.common.jackson.core.JsonGenerator;
import org.elasticsearch.common.jackson.core.ObjectCodec;
import org.elasticsearch.common.jackson.core.PrettyPrinter;
import org.elasticsearch.common.jackson.core.SerializableString;
import org.elasticsearch.common.jackson.core.Version;
import org.elasticsearch.common.jackson.core.base.GeneratorBase;
import org.elasticsearch.common.jackson.core.io.IOContext;
import org.elasticsearch.common.jackson.core.json.JsonWriteContext;
import org.elasticsearch.common.jackson.dataformat.smile.PackageVersion;
import org.elasticsearch.common.jackson.dataformat.smile.SmileBufferRecycler;
import org.elasticsearch.common.jackson.dataformat.smile.SmileUtil;

public class SmileGenerator
extends GeneratorBase {
    private static final int MIN_BUFFER_LENGTH = 770;
    protected static final byte TOKEN_BYTE_LONG_STRING_ASCII = -32;
    protected static final byte TOKEN_BYTE_INT_32 = 36;
    protected static final byte TOKEN_BYTE_INT_64 = 37;
    protected static final byte TOKEN_BYTE_BIG_INTEGER = 38;
    protected static final byte TOKEN_BYTE_FLOAT_32 = 40;
    protected static final byte TOKEN_BYTE_FLOAT_64 = 41;
    protected static final byte TOKEN_BYTE_BIG_DECIMAL = 42;
    protected static final int SURR1_FIRST = 55296;
    protected static final int SURR1_LAST = 56319;
    protected static final int SURR2_FIRST = 56320;
    protected static final int SURR2_LAST = 57343;
    protected static final long MIN_INT_AS_LONG = Integer.MIN_VALUE;
    protected static final long MAX_INT_AS_LONG = Integer.MAX_VALUE;
    protected final IOContext _ioContext;
    protected final OutputStream _out;
    protected int _smileFeatures;
    protected final SmileBufferRecycler<SharedStringNode> _smileBufferRecycler;
    protected byte[] _outputBuffer;
    protected int _outputTail = 0;
    protected final int _outputEnd;
    protected char[] _charBuffer;
    protected final int _charBufferLength;
    protected int _bytesWritten;
    protected SharedStringNode[] _seenNames;
    protected int _seenNameCount;
    protected SharedStringNode[] _seenStringValues;
    protected int _seenStringValueCount;
    protected boolean _bufferRecyclable;
    protected static final ThreadLocal<SoftReference<SmileBufferRecycler<SharedStringNode>>> _smileRecyclerRef = new ThreadLocal();

    public SmileGenerator(IOContext iOContext, int n, int n2, ObjectCodec objectCodec, OutputStream outputStream) {
        super(n, objectCodec);
        this._smileFeatures = n2;
        this._ioContext = iOContext;
        this._smileBufferRecycler = SmileGenerator._smileBufferRecycler();
        this._out = outputStream;
        this._bufferRecyclable = true;
        this._outputBuffer = iOContext.allocWriteEncodingBuffer();
        this._outputEnd = this._outputBuffer.length;
        this._charBuffer = iOContext.allocConcatBuffer();
        this._charBufferLength = this._charBuffer.length;
        if (this._outputEnd < 770) {
            throw new IllegalStateException("Internal encoding buffer length (" + this._outputEnd + ") too short, must be at least " + 770);
        }
        if ((n2 & Feature.CHECK_SHARED_NAMES.getMask()) == 0) {
            this._seenNames = null;
            this._seenNameCount = -1;
        } else {
            this._seenNames = this._smileBufferRecycler.allocSeenNamesBuffer();
            if (this._seenNames == null) {
                this._seenNames = new SharedStringNode[64];
            }
            this._seenNameCount = 0;
        }
        if ((n2 & Feature.CHECK_SHARED_STRING_VALUES.getMask()) == 0) {
            this._seenStringValues = null;
            this._seenStringValueCount = -1;
        } else {
            this._seenStringValues = this._smileBufferRecycler.allocSeenStringValuesBuffer();
            if (this._seenStringValues == null) {
                this._seenStringValues = new SharedStringNode[64];
            }
            this._seenStringValueCount = 0;
        }
    }

    public SmileGenerator(IOContext iOContext, int n, int n2, ObjectCodec objectCodec, OutputStream outputStream, byte[] byArray, int n3, boolean bl) {
        super(n, objectCodec);
        this._smileFeatures = n2;
        this._ioContext = iOContext;
        this._smileBufferRecycler = SmileGenerator._smileBufferRecycler();
        this._out = outputStream;
        this._bufferRecyclable = bl;
        this._outputTail = n3;
        this._outputBuffer = byArray;
        this._outputEnd = this._outputBuffer.length;
        this._charBuffer = iOContext.allocConcatBuffer();
        this._charBufferLength = this._charBuffer.length;
        if (this._outputEnd < 770) {
            throw new IllegalStateException("Internal encoding buffer length (" + this._outputEnd + ") too short, must be at least " + 770);
        }
        if ((n2 & Feature.CHECK_SHARED_NAMES.getMask()) == 0) {
            this._seenNames = null;
            this._seenNameCount = -1;
        } else {
            this._seenNames = this._smileBufferRecycler.allocSeenNamesBuffer();
            if (this._seenNames == null) {
                this._seenNames = new SharedStringNode[64];
            }
            this._seenNameCount = 0;
        }
        if ((n2 & Feature.CHECK_SHARED_STRING_VALUES.getMask()) == 0) {
            this._seenStringValues = null;
            this._seenStringValueCount = -1;
        } else {
            this._seenStringValues = this._smileBufferRecycler.allocSeenStringValuesBuffer();
            if (this._seenStringValues == null) {
                this._seenStringValues = new SharedStringNode[64];
            }
            this._seenStringValueCount = 0;
        }
    }

    public void writeHeader() throws IOException {
        int n = 0;
        if ((this._smileFeatures & Feature.CHECK_SHARED_NAMES.getMask()) != 0) {
            n |= 1;
        }
        if ((this._smileFeatures & Feature.CHECK_SHARED_STRING_VALUES.getMask()) != 0) {
            n |= 2;
        }
        if ((this._smileFeatures & Feature.ENCODE_BINARY_AS_7BIT.getMask()) == 0) {
            n |= 4;
        }
        this._writeBytes((byte)58, (byte)41, (byte)10, (byte)n);
    }

    protected static final SmileBufferRecycler<SharedStringNode> _smileBufferRecycler() {
        SmileBufferRecycler<SharedStringNode> smileBufferRecycler;
        SoftReference<SmileBufferRecycler<SharedStringNode>> softReference = _smileRecyclerRef.get();
        SmileBufferRecycler<SharedStringNode> smileBufferRecycler2 = smileBufferRecycler = softReference == null ? null : softReference.get();
        if (smileBufferRecycler == null) {
            smileBufferRecycler = new SmileBufferRecycler();
            _smileRecyclerRef.set(new SoftReference<SmileBufferRecycler<SharedStringNode>>(smileBufferRecycler));
        }
        return smileBufferRecycler;
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public JsonGenerator useDefaultPrettyPrinter() {
        return this;
    }

    @Override
    public JsonGenerator setPrettyPrinter(PrettyPrinter prettyPrinter) {
        return this;
    }

    @Override
    public Object getOutputTarget() {
        return this._out;
    }

    @Override
    public final void writeFieldName(String string) throws IOException, JsonGenerationException {
        if (this._writeContext.writeFieldName(string) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(string);
    }

    @Override
    public final void writeFieldName(SerializableString serializableString) throws IOException, JsonGenerationException {
        if (this._writeContext.writeFieldName(serializableString.getValue()) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(serializableString);
    }

    @Override
    public final void writeStringField(String string, String string2) throws IOException, JsonGenerationException {
        if (this._writeContext.writeFieldName(string) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(string);
        this.writeString(string2);
    }

    public SmileGenerator enable(Feature feature) {
        this._smileFeatures |= feature.getMask();
        return this;
    }

    public SmileGenerator disable(Feature feature) {
        this._smileFeatures &= ~feature.getMask();
        return this;
    }

    public final boolean isEnabled(Feature feature) {
        return (this._smileFeatures & feature.getMask()) != 0;
    }

    public SmileGenerator configure(Feature feature, boolean bl) {
        if (bl) {
            this.enable(feature);
        } else {
            this.disable(feature);
        }
        return this;
    }

    public void writeRaw(byte by) throws IOException, JsonGenerationException {
        this._writeByte((byte)-8);
    }

    public void writeBytes(byte[] byArray, int n, int n2) throws IOException {
        this._writeBytes(byArray, n, n2);
    }

    @Override
    public final void writeStartArray() throws IOException, JsonGenerationException {
        this._verifyValueWrite("start an array");
        this._writeContext = this._writeContext.createChildArrayContext();
        this._writeByte((byte)-8);
    }

    @Override
    public final void writeEndArray() throws IOException, JsonGenerationException {
        if (!this._writeContext.inArray()) {
            this._reportError("Current context not an ARRAY but " + this._writeContext.getTypeDesc());
        }
        this._writeByte((byte)-7);
        this._writeContext = this._writeContext.getParent();
    }

    @Override
    public final void writeStartObject() throws IOException, JsonGenerationException {
        this._verifyValueWrite("start an object");
        this._writeContext = this._writeContext.createChildObjectContext();
        this._writeByte((byte)-6);
    }

    @Override
    public final void writeEndObject() throws IOException, JsonGenerationException {
        if (!this._writeContext.inObject()) {
            this._reportError("Current context not an object but " + this._writeContext.getTypeDesc());
        }
        this._writeContext = this._writeContext.getParent();
        this._writeByte((byte)-5);
    }

    private final void _writeFieldName(String string) throws IOException, JsonGenerationException {
        int n;
        int n2;
        int n3 = string.length();
        if (n3 == 0) {
            this._writeByte((byte)32);
            return;
        }
        if (this._seenNameCount >= 0 && (n2 = this._findSeenName(string)) >= 0) {
            this._writeSharedNameReference(n2);
            return;
        }
        if (n3 > 56) {
            this._writeNonShortFieldName(string, n3);
            return;
        }
        if (this._outputTail + 196 >= this._outputEnd) {
            this._flushBuffer();
        }
        string.getChars(0, n3, this._charBuffer, 0);
        n2 = this._outputTail++;
        int n4 = this._shortUTF8Encode(this._charBuffer, 0, n3);
        if (n4 == n3) {
            if (n4 <= 64) {
                n = (byte)(127 + n4);
            } else {
                n = 52;
                this._outputBuffer[this._outputTail++] = -4;
            }
        } else if (n4 <= 56) {
            n = (byte)(190 + n4);
        } else {
            n = 52;
            this._outputBuffer[this._outputTail++] = -4;
        }
        this._outputBuffer[n2] = n;
        if (this._seenNameCount >= 0) {
            this._addSeenName(string);
        }
    }

    private final void _writeNonShortFieldName(String string, int n) throws IOException, JsonGenerationException {
        this._writeByte((byte)52);
        if (n > this._charBufferLength) {
            this._slowUTF8Encode(string);
        } else {
            string.getChars(0, n, this._charBuffer, 0);
            int n2 = n + n + n;
            if (n2 <= this._outputBuffer.length) {
                if (this._outputTail + n2 >= this._outputEnd) {
                    this._flushBuffer();
                }
                this._shortUTF8Encode(this._charBuffer, 0, n);
            } else {
                this._mediumUTF8Encode(this._charBuffer, 0, n);
            }
        }
        if (this._seenNameCount >= 0) {
            this._addSeenName(string);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = -4;
    }

    protected final void _writeFieldName(SerializableString serializableString) throws IOException, JsonGenerationException {
        int n;
        int n2 = serializableString.charLength();
        if (n2 == 0) {
            this._writeByte((byte)32);
            return;
        }
        if (this._seenNameCount >= 0 && (n = this._findSeenName(serializableString.getValue())) >= 0) {
            this._writeSharedNameReference(n);
            return;
        }
        byte[] byArray = serializableString.asUnquotedUTF8();
        int n3 = byArray.length;
        if (n3 != n2) {
            this._writeFieldNameUnicode(serializableString, byArray);
            return;
        }
        if (n3 <= 64) {
            if (this._outputTail + n3 >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = (byte)(127 + n3);
            System.arraycopy(byArray, 0, this._outputBuffer, this._outputTail, n3);
            this._outputTail += n3;
        } else {
            this._writeLongAsciiFieldName(byArray);
        }
        if (this._seenNameCount >= 0) {
            this._addSeenName(serializableString.getValue());
        }
    }

    private final void _writeLongAsciiFieldName(byte[] byArray) throws IOException, JsonGenerationException {
        int n = byArray.length;
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 52;
        if (this._outputTail + n + 1 < this._outputEnd) {
            System.arraycopy(byArray, 0, this._outputBuffer, this._outputTail, n);
            this._outputTail += n;
        } else {
            this._flushBuffer();
            if (n < 770) {
                System.arraycopy(byArray, 0, this._outputBuffer, this._outputTail, n);
                this._outputTail += n;
            } else {
                if (this._outputTail > 0) {
                    this._flushBuffer();
                }
                this._out.write(byArray, 0, n);
            }
        }
        this._outputBuffer[this._outputTail++] = -4;
    }

    protected final void _writeFieldNameUnicode(SerializableString serializableString, byte[] byArray) throws IOException, JsonGenerationException {
        int n = byArray.length;
        if (n <= 56) {
            if (this._outputTail + n >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = (byte)(190 + n);
            System.arraycopy(byArray, 0, this._outputBuffer, this._outputTail, n);
            this._outputTail += n;
            if (this._seenNameCount >= 0) {
                this._addSeenName(serializableString.getValue());
            }
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 52;
        if (this._outputTail + n + 1 < this._outputEnd) {
            System.arraycopy(byArray, 0, this._outputBuffer, this._outputTail, n);
            this._outputTail += n;
        } else {
            this._flushBuffer();
            if (n < 770) {
                System.arraycopy(byArray, 0, this._outputBuffer, this._outputTail, n);
                this._outputTail += n;
            } else {
                if (this._outputTail > 0) {
                    this._flushBuffer();
                }
                this._out.write(byArray, 0, n);
            }
        }
        this._outputBuffer[this._outputTail++] = -4;
        if (this._seenNameCount >= 0) {
            this._addSeenName(serializableString.getValue());
        }
    }

    private final void _writeSharedNameReference(int n) throws IOException, JsonGenerationException {
        if (n >= this._seenNameCount) {
            throw new IllegalArgumentException("Internal error: trying to write shared name with index " + n + "; but have only seen " + this._seenNameCount + " so far!");
        }
        if (n < 64) {
            this._writeByte((byte)(64 + n));
        } else {
            this._writeBytes((byte)(48 + (n >> 8)), (byte)n);
        }
    }

    @Override
    public void writeString(String string) throws IOException, JsonGenerationException {
        int n;
        if (string == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write String value");
        int n2 = string.length();
        if (n2 == 0) {
            this._writeByte((byte)32);
            return;
        }
        if (n2 > 65) {
            this._writeNonSharedString(string, n2);
            return;
        }
        if (this._seenStringValueCount >= 0 && (n = this._findSeenStringValue(string)) >= 0) {
            this._writeSharedStringValueReference(n);
            return;
        }
        if (this._outputTail + 196 >= this._outputEnd) {
            this._flushBuffer();
        }
        string.getChars(0, n2, this._charBuffer, 0);
        n = this._outputTail++;
        int n3 = this._shortUTF8Encode(this._charBuffer, 0, n2);
        if (n3 <= 64) {
            if (this._seenStringValueCount >= 0) {
                this._addSeenStringValue(string);
            }
            this._outputBuffer[n] = n3 == n2 ? (byte)(63 + n3) : (byte)(126 + n3);
        } else {
            this._outputBuffer[n] = n3 == n2 ? -32 : -28;
            this._outputBuffer[this._outputTail++] = -4;
        }
    }

    private final void _writeSharedStringValueReference(int n) throws IOException, JsonGenerationException {
        if (n >= this._seenStringValueCount) {
            throw new IllegalArgumentException("Internal error: trying to write shared String value with index " + n + "; but have only seen " + this._seenStringValueCount + " so far!");
        }
        if (n < 31) {
            this._writeByte((byte)(1 + n));
        } else {
            this._writeBytes((byte)(236 + (n >> 8)), (byte)n);
        }
    }

    private final void _writeNonSharedString(String string, int n) throws IOException, JsonGenerationException {
        if (n > this._charBufferLength) {
            this._writeByte((byte)-28);
            this._slowUTF8Encode(string);
            this._writeByte((byte)-4);
            return;
        }
        string.getChars(0, n, this._charBuffer, 0);
        int n2 = n + n + n + 2;
        if (n2 > this._outputBuffer.length) {
            this._writeByte((byte)-28);
            this._mediumUTF8Encode(this._charBuffer, 0, n);
            this._writeByte((byte)-4);
            return;
        }
        if (this._outputTail + n2 >= this._outputEnd) {
            this._flushBuffer();
        }
        int n3 = this._outputTail;
        this._writeByte((byte)-32);
        int n4 = this._shortUTF8Encode(this._charBuffer, 0, n);
        if (n4 > n) {
            this._outputBuffer[n3] = -28;
        }
        this._outputBuffer[this._outputTail++] = -4;
    }

    @Override
    public void writeString(char[] cArray, int n, int n2) throws IOException, JsonGenerationException {
        if (n2 <= 65 && this._seenStringValueCount >= 0 && n2 > 0) {
            this.writeString(new String(cArray, n, n2));
            return;
        }
        this._verifyValueWrite("write String value");
        if (n2 == 0) {
            this._writeByte((byte)32);
            return;
        }
        if (n2 <= 64) {
            int n3;
            if (this._outputTail + 196 >= this._outputEnd) {
                this._flushBuffer();
            }
            int n4 = this._outputTail++;
            int n5 = this._shortUTF8Encode(cArray, n, n + n2);
            if (n5 <= 64) {
                n3 = n5 == n2 ? (int)((byte)(63 + n5)) : (int)((byte)(126 + n5));
            } else {
                n3 = -28;
                this._outputBuffer[this._outputTail++] = -4;
            }
            this._outputBuffer[n4] = n3;
        } else {
            int n6 = n2 + n2 + n2 + 2;
            if (n6 <= this._outputBuffer.length) {
                if (this._outputTail + n6 >= this._outputEnd) {
                    this._flushBuffer();
                }
                int n7 = this._outputTail;
                this._writeByte((byte)-28);
                int n8 = this._shortUTF8Encode(cArray, n, n + n2);
                if (n8 == n2) {
                    this._outputBuffer[n7] = -32;
                }
                this._outputBuffer[this._outputTail++] = -4;
            } else {
                this._writeByte((byte)-28);
                this._mediumUTF8Encode(cArray, n, n + n2);
                this._writeByte((byte)-4);
            }
        }
    }

    @Override
    public final void writeString(SerializableString serializableString) throws IOException, JsonGenerationException {
        int n;
        this._verifyValueWrite("write String value");
        String string = serializableString.getValue();
        int n2 = string.length();
        if (n2 == 0) {
            this._writeByte((byte)32);
            return;
        }
        if (n2 <= 65 && this._seenStringValueCount >= 0 && (n = this._findSeenStringValue(string)) >= 0) {
            this._writeSharedStringValueReference(n);
            return;
        }
        byte[] byArray = serializableString.asUnquotedUTF8();
        int n3 = byArray.length;
        if (n3 <= 64) {
            if (this._outputTail + n3 + 1 >= this._outputEnd) {
                this._flushBuffer();
            }
            int n4 = n3 == n2 ? 63 + n3 : 126 + n3;
            this._outputBuffer[this._outputTail++] = (byte)n4;
            System.arraycopy(byArray, 0, this._outputBuffer, this._outputTail, n3);
            this._outputTail += n3;
            if (this._seenStringValueCount >= 0) {
                this._addSeenStringValue(serializableString.getValue());
            }
        } else {
            byte by = n3 == n2 ? (byte)-32 : -28;
            this._writeByte(by);
            this._writeBytes(byArray, 0, byArray.length);
            this._writeByte((byte)-4);
        }
    }

    @Override
    public void writeRawUTF8String(byte[] byArray, int n, int n2) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write String value");
        if (n2 == 0) {
            this._writeByte((byte)32);
            return;
        }
        if (this._seenStringValueCount >= 0) {
            throw new UnsupportedOperationException("Can not use direct UTF-8 write methods when 'Feature.CHECK_SHARED_STRING_VALUES' enabled");
        }
        if (n2 <= 65) {
            if (this._outputTail + n2 >= this._outputEnd) {
                this._flushBuffer();
            }
            if (n2 == 1) {
                this._outputBuffer[this._outputTail++] = 64;
                this._outputBuffer[this._outputTail++] = byArray[n];
            } else {
                this._outputBuffer[this._outputTail++] = (byte)(126 + n2);
                System.arraycopy(byArray, n, this._outputBuffer, this._outputTail, n2);
                this._outputTail += n2;
            }
        } else {
            int n3 = n2 + n2 + n2 + 2;
            if (n3 <= this._outputBuffer.length) {
                if (this._outputTail + n3 >= this._outputEnd) {
                    this._flushBuffer();
                }
                this._outputBuffer[this._outputTail++] = -28;
                System.arraycopy(byArray, n, this._outputBuffer, this._outputTail, n2);
                this._outputTail += n2;
                this._outputBuffer[this._outputTail++] = -4;
            } else {
                this._writeByte((byte)-28);
                this._writeBytes(byArray, n, n2);
                this._writeByte((byte)-4);
            }
        }
    }

    @Override
    public final void writeUTF8String(byte[] byArray, int n, int n2) throws IOException, JsonGenerationException {
        this.writeRawUTF8String(byArray, n, n2);
    }

    @Override
    public void writeRaw(String string) throws IOException, JsonGenerationException {
        throw this._notSupported();
    }

    @Override
    public void writeRaw(String string, int n, int n2) throws IOException, JsonGenerationException {
        throw this._notSupported();
    }

    @Override
    public void writeRaw(char[] cArray, int n, int n2) throws IOException, JsonGenerationException {
        throw this._notSupported();
    }

    @Override
    public void writeRaw(char c) throws IOException, JsonGenerationException {
        throw this._notSupported();
    }

    @Override
    public void writeRawValue(String string) throws IOException, JsonGenerationException {
        throw this._notSupported();
    }

    @Override
    public void writeRawValue(String string, int n, int n2) throws IOException, JsonGenerationException {
        throw this._notSupported();
    }

    @Override
    public void writeRawValue(char[] cArray, int n, int n2) throws IOException, JsonGenerationException {
        throw this._notSupported();
    }

    @Override
    public void writeBinary(Base64Variant base64Variant, byte[] byArray, int n, int n2) throws IOException, JsonGenerationException {
        if (byArray == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write Binary value");
        if (this.isEnabled(Feature.ENCODE_BINARY_AS_7BIT)) {
            this._writeByte((byte)-24);
            this._write7BitBinaryWithLength(byArray, n, n2);
        } else {
            this._writeByte((byte)-3);
            this._writePositiveVInt(n2);
            this._writeBytes(byArray, n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int writeBinary(InputStream inputStream, int n) throws IOException, JsonGenerationException {
        int n2;
        if (n < 0) {
            throw new UnsupportedOperationException("Must pass actual length for Smile encoded data");
        }
        this._verifyValueWrite("write Binary value");
        if (this.isEnabled(Feature.ENCODE_BINARY_AS_7BIT)) {
            this._writeByte((byte)-24);
            byte[] byArray = this._ioContext.allocBase64Buffer();
            try {
                n2 = this._write7BitBinaryWithLength(inputStream, n, byArray);
            }
            finally {
                this._ioContext.releaseBase64Buffer(byArray);
            }
        } else {
            this._writeByte((byte)-3);
            this._writePositiveVInt(n);
            n2 = this._writeBytes(inputStream, n);
        }
        if (n2 > 0) {
            this._reportError("Too few bytes available: missing " + n2 + " bytes (out of " + n + ")");
        }
        return n;
    }

    @Override
    public int writeBinary(Base64Variant base64Variant, InputStream inputStream, int n) throws IOException, JsonGenerationException {
        return this.writeBinary(inputStream, n);
    }

    @Override
    public void writeBoolean(boolean bl) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write boolean value");
        if (bl) {
            this._writeByte((byte)35);
        } else {
            this._writeByte((byte)34);
        }
    }

    @Override
    public void writeNull() throws IOException, JsonGenerationException {
        this._verifyValueWrite("write null value");
        this._writeByte((byte)33);
    }

    @Override
    public void writeNumber(int n) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        n = SmileUtil.zigzagEncode(n);
        if (n <= 63 && n >= 0) {
            if (n <= 31) {
                this._writeByte((byte)(192 + n));
                return;
            }
            this._writeBytes((byte)36, (byte)(128 + n));
            return;
        }
        byte by = (byte)(128 + (n & 0x3F));
        if ((n >>>= 6) <= 127) {
            this._writeBytes((byte)36, (byte)n, by);
            return;
        }
        byte by2 = (byte)(n & 0x7F);
        if ((n >>= 7) <= 127) {
            this._writeBytes((byte)36, (byte)n, by2, by);
            return;
        }
        byte by3 = (byte)(n & 0x7F);
        if ((n >>= 7) <= 127) {
            this._writeBytes((byte)36, (byte)n, by3, by2, by);
            return;
        }
        byte by4 = (byte)(n & 0x7F);
        this._writeBytes((byte)36, (byte)(n >> 7), by4, by3, by2, by);
    }

    @Override
    public void writeNumber(long l) throws IOException, JsonGenerationException {
        if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
            this.writeNumber((int)l);
            return;
        }
        this._verifyValueWrite("write number");
        l = SmileUtil.zigzagEncode(l);
        int n = (int)l;
        byte by = (byte)(128 + (n & 0x3F));
        byte by2 = (byte)(n >> 6 & 0x7F);
        byte by3 = (byte)(n >> 13 & 0x7F);
        byte by4 = (byte)(n >> 20 & 0x7F);
        byte by5 = (byte)((int)(l >>>= 27) & 0x7F);
        n = (int)(l >> 7);
        if (n == 0) {
            this._writeBytes((byte)37, by5, by4, by3, by2, by);
            return;
        }
        if (n <= 127) {
            this._writeBytes((byte)37, (byte)n);
            this._writeBytes(by5, by4, by3, by2, by);
            return;
        }
        byte by6 = (byte)(n & 0x7F);
        if ((n >>= 7) <= 127) {
            this._writeBytes((byte)37, (byte)n);
            this._writeBytes(by6, by5, by4, by3, by2, by);
            return;
        }
        byte by7 = (byte)(n & 0x7F);
        if ((n >>= 7) <= 127) {
            this._writeBytes((byte)37, (byte)n, by7);
            this._writeBytes(by6, by5, by4, by3, by2, by);
            return;
        }
        byte by8 = (byte)(n & 0x7F);
        if ((n >>= 7) <= 127) {
            this._writeBytes((byte)37, (byte)n, by8, by7);
            this._writeBytes(by6, by5, by4, by3, by2, by);
            return;
        }
        byte by9 = (byte)(n & 0x7F);
        this._writeBytes((byte)37, (byte)(n >>= 7), by9, by8, by7);
        this._writeBytes(by6, by5, by4, by3, by2, by);
    }

    @Override
    public void writeNumber(BigInteger bigInteger) throws IOException, JsonGenerationException {
        if (bigInteger == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        this._writeByte((byte)38);
        byte[] byArray = bigInteger.toByteArray();
        this._write7BitBinaryWithLength(byArray, 0, byArray.length);
    }

    @Override
    public void writeNumber(double d) throws IOException, JsonGenerationException {
        this._ensureRoomForOutput(11);
        this._verifyValueWrite("write number");
        long l = Double.doubleToRawLongBits(d);
        this._outputBuffer[this._outputTail++] = 41;
        int n = (int)(l >>> 35);
        this._outputBuffer[this._outputTail + 4] = (byte)(n & 0x7F);
        this._outputBuffer[this._outputTail + 3] = (byte)((n >>= 7) & 0x7F);
        this._outputBuffer[this._outputTail + 2] = (byte)((n >>= 7) & 0x7F);
        this._outputBuffer[this._outputTail + 1] = (byte)((n >>= 7) & 0x7F);
        this._outputBuffer[this._outputTail] = (byte)(n >>= 7);
        this._outputTail += 5;
        int n2 = (int)(l >> 28);
        this._outputBuffer[this._outputTail++] = (byte)(n2 & 0x7F);
        n2 = (int)l;
        this._outputBuffer[this._outputTail + 3] = (byte)(n2 & 0x7F);
        this._outputBuffer[this._outputTail + 2] = (byte)((n2 >>= 7) & 0x7F);
        this._outputBuffer[this._outputTail + 1] = (byte)((n2 >>= 7) & 0x7F);
        this._outputBuffer[this._outputTail] = (byte)((n2 >>= 7) & 0x7F);
        this._outputTail += 4;
    }

    @Override
    public void writeNumber(float f) throws IOException, JsonGenerationException {
        this._ensureRoomForOutput(6);
        this._verifyValueWrite("write number");
        int n = Float.floatToRawIntBits(f);
        this._outputBuffer[this._outputTail++] = 40;
        this._outputBuffer[this._outputTail + 4] = (byte)(n & 0x7F);
        this._outputBuffer[this._outputTail + 3] = (byte)((n >>= 7) & 0x7F);
        this._outputBuffer[this._outputTail + 2] = (byte)((n >>= 7) & 0x7F);
        this._outputBuffer[this._outputTail + 1] = (byte)((n >>= 7) & 0x7F);
        this._outputBuffer[this._outputTail] = (byte)((n >>= 7) & 0x7F);
        this._outputTail += 5;
    }

    @Override
    public void writeNumber(BigDecimal bigDecimal) throws IOException, JsonGenerationException {
        if (bigDecimal == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        this._writeByte((byte)42);
        int n = bigDecimal.scale();
        this._writeSignedVInt(n);
        BigInteger bigInteger = bigDecimal.unscaledValue();
        byte[] byArray = bigInteger.toByteArray();
        this._write7BitBinaryWithLength(byArray, 0, byArray.length);
    }

    @Override
    public void writeNumber(String string) throws IOException, JsonGenerationException, UnsupportedOperationException {
        throw this._notSupported();
    }

    @Override
    protected final void _verifyValueWrite(String string) throws IOException, JsonGenerationException {
        int n = this._writeContext.writeValue();
        if (n == 5) {
            this._reportError("Can not " + string + ", expecting field name");
        }
    }

    @Override
    public final void flush() throws IOException {
        this._flushBuffer();
        if (this.isEnabled(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM)) {
            this._out.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this._outputBuffer != null && this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT)) {
            while (true) {
                JsonWriteContext jsonWriteContext;
                if ((jsonWriteContext = this.getOutputContext()).inArray()) {
                    this.writeEndArray();
                    continue;
                }
                if (!jsonWriteContext.inObject()) break;
                this.writeEndObject();
            }
        }
        boolean bl = this._closed;
        super.close();
        if (!bl && this.isEnabled(Feature.WRITE_END_MARKER)) {
            this._writeByte((byte)-1);
        }
        this._flushBuffer();
        if (this._ioContext.isResourceManaged() || this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_TARGET)) {
            this._out.close();
        } else {
            this._out.flush();
        }
        this._releaseBuffers();
    }

    private final int _shortUTF8Encode(char[] cArray, int n, int n2) {
        int n3;
        int n4 = this._outputTail;
        byte[] byArray = this._outputBuffer;
        do {
            if ((n3 = cArray[n]) > 127) {
                return this._shortUTF8Encode2(cArray, n, n2, n4);
            }
            byArray[n4++] = (byte)n3;
        } while (++n < n2);
        n3 = n4 - this._outputTail;
        this._outputTail = n4;
        return n3;
    }

    private final int _shortUTF8Encode2(char[] cArray, int n, int n2, int n3) {
        int n4;
        byte[] byArray = this._outputBuffer;
        while (n < n2) {
            if ((n4 = cArray[n++]) <= 127) {
                byArray[n3++] = (byte)n4;
                continue;
            }
            if (n4 < 2048) {
                byArray[n3++] = (byte)(0xC0 | n4 >> 6);
                byArray[n3++] = (byte)(0x80 | n4 & 0x3F);
                continue;
            }
            if (n4 < 55296 || n4 > 57343) {
                byArray[n3++] = (byte)(0xE0 | n4 >> 12);
                byArray[n3++] = (byte)(0x80 | n4 >> 6 & 0x3F);
                byArray[n3++] = (byte)(0x80 | n4 & 0x3F);
                continue;
            }
            if (n4 > 56319) {
                this._throwIllegalSurrogate(n4);
            }
            if (n >= n2) {
                this._throwIllegalSurrogate(n4);
            }
            if ((n4 = this._convertSurrogate(n4, cArray[n++])) > 0x10FFFF) {
                this._throwIllegalSurrogate(n4);
            }
            byArray[n3++] = (byte)(0xF0 | n4 >> 18);
            byArray[n3++] = (byte)(0x80 | n4 >> 12 & 0x3F);
            byArray[n3++] = (byte)(0x80 | n4 >> 6 & 0x3F);
            byArray[n3++] = (byte)(0x80 | n4 & 0x3F);
        }
        n4 = n3 - this._outputTail;
        this._outputTail = n3;
        return n4;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void _slowUTF8Encode(String string) throws IOException {
        int n = string.length();
        int n2 = 0;
        int n3 = this._outputEnd - 4;
        block0: while (n2 < n) {
            int n4;
            if (this._outputTail >= n3) {
                this._flushBuffer();
            }
            if ((n4 = string.charAt(n2++)) <= 127) {
                this._outputBuffer[this._outputTail++] = (byte)n4;
                int n5 = n - n2;
                int n6 = n3 - this._outputTail;
                if (n5 > n6) {
                    n5 = n6;
                }
                n5 += n2;
                while (true) {
                    if (n2 >= n5) continue block0;
                    if ((n4 = (int)string.charAt(n2++)) > 127) break;
                    this._outputBuffer[this._outputTail++] = (byte)n4;
                }
            }
            if (n4 < 2048) {
                this._outputBuffer[this._outputTail++] = (byte)(0xC0 | n4 >> 6);
                this._outputBuffer[this._outputTail++] = (byte)(0x80 | n4 & 0x3F);
                continue;
            }
            if (n4 < 55296 || n4 > 57343) {
                this._outputBuffer[this._outputTail++] = (byte)(0xE0 | n4 >> 12);
                this._outputBuffer[this._outputTail++] = (byte)(0x80 | n4 >> 6 & 0x3F);
                this._outputBuffer[this._outputTail++] = (byte)(0x80 | n4 & 0x3F);
                continue;
            }
            if (n4 > 56319) {
                this._throwIllegalSurrogate(n4);
            }
            if (n2 >= n) {
                this._throwIllegalSurrogate(n4);
            }
            if ((n4 = this._convertSurrogate(n4, string.charAt(n2++))) > 0x10FFFF) {
                this._throwIllegalSurrogate(n4);
            }
            this._outputBuffer[this._outputTail++] = (byte)(0xF0 | n4 >> 18);
            this._outputBuffer[this._outputTail++] = (byte)(0x80 | n4 >> 12 & 0x3F);
            this._outputBuffer[this._outputTail++] = (byte)(0x80 | n4 >> 6 & 0x3F);
            this._outputBuffer[this._outputTail++] = (byte)(0x80 | n4 & 0x3F);
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void _mediumUTF8Encode(char[] cArray, int n, int n2) throws IOException {
        int n3 = this._outputEnd - 4;
        block0: while (n < n2) {
            int n4;
            if (this._outputTail >= n3) {
                this._flushBuffer();
            }
            if ((n4 = cArray[n++]) <= 127) {
                this._outputBuffer[this._outputTail++] = (byte)n4;
                int n5 = n2 - n;
                int n6 = n3 - this._outputTail;
                if (n5 > n6) {
                    n5 = n6;
                }
                n5 += n;
                while (true) {
                    if (n >= n5) continue block0;
                    if ((n4 = cArray[n++]) > 127) break;
                    this._outputBuffer[this._outputTail++] = (byte)n4;
                }
            }
            if (n4 < 2048) {
                this._outputBuffer[this._outputTail++] = (byte)(0xC0 | n4 >> 6);
                this._outputBuffer[this._outputTail++] = (byte)(0x80 | n4 & 0x3F);
                continue;
            }
            if (n4 < 55296 || n4 > 57343) {
                this._outputBuffer[this._outputTail++] = (byte)(0xE0 | n4 >> 12);
                this._outputBuffer[this._outputTail++] = (byte)(0x80 | n4 >> 6 & 0x3F);
                this._outputBuffer[this._outputTail++] = (byte)(0x80 | n4 & 0x3F);
                continue;
            }
            if (n4 > 56319) {
                this._throwIllegalSurrogate(n4);
            }
            if (n >= n2) {
                this._throwIllegalSurrogate(n4);
            }
            if ((n4 = this._convertSurrogate(n4, cArray[n++])) > 0x10FFFF) {
                this._throwIllegalSurrogate(n4);
            }
            this._outputBuffer[this._outputTail++] = (byte)(0xF0 | n4 >> 18);
            this._outputBuffer[this._outputTail++] = (byte)(0x80 | n4 >> 12 & 0x3F);
            this._outputBuffer[this._outputTail++] = (byte)(0x80 | n4 >> 6 & 0x3F);
            this._outputBuffer[this._outputTail++] = (byte)(0x80 | n4 & 0x3F);
        }
        return;
    }

    private int _convertSurrogate(int n, int n2) {
        if (n2 < 56320 || n2 > 57343) {
            throw new IllegalArgumentException("Broken surrogate pair: first char 0x" + Integer.toHexString(n) + ", second 0x" + Integer.toHexString(n2) + "; illegal combination");
        }
        return 65536 + (n - 55296 << 10) + (n2 - 56320);
    }

    private void _throwIllegalSurrogate(int n) {
        if (n > 0x10FFFF) {
            throw new IllegalArgumentException("Illegal character point (0x" + Integer.toHexString(n) + ") to output; max is 0x10FFFF as per RFC 4627");
        }
        if (n >= 55296) {
            if (n <= 56319) {
                throw new IllegalArgumentException("Unmatched first part of surrogate pair (0x" + Integer.toHexString(n) + ")");
            }
            throw new IllegalArgumentException("Unmatched second part of surrogate pair (0x" + Integer.toHexString(n) + ")");
        }
        throw new IllegalArgumentException("Illegal character point (0x" + Integer.toHexString(n) + ") to output");
    }

    private final void _ensureRoomForOutput(int n) throws IOException {
        if (this._outputTail + n >= this._outputEnd) {
            this._flushBuffer();
        }
    }

    private final void _writeByte(byte by) throws IOException {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = by;
    }

    private final void _writeBytes(byte by, byte by2) throws IOException {
        if (this._outputTail + 1 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = by;
        this._outputBuffer[this._outputTail++] = by2;
    }

    private final void _writeBytes(byte by, byte by2, byte by3) throws IOException {
        if (this._outputTail + 2 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = by;
        this._outputBuffer[this._outputTail++] = by2;
        this._outputBuffer[this._outputTail++] = by3;
    }

    private final void _writeBytes(byte by, byte by2, byte by3, byte by4) throws IOException {
        if (this._outputTail + 3 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = by;
        this._outputBuffer[this._outputTail++] = by2;
        this._outputBuffer[this._outputTail++] = by3;
        this._outputBuffer[this._outputTail++] = by4;
    }

    private final void _writeBytes(byte by, byte by2, byte by3, byte by4, byte by5) throws IOException {
        if (this._outputTail + 4 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = by;
        this._outputBuffer[this._outputTail++] = by2;
        this._outputBuffer[this._outputTail++] = by3;
        this._outputBuffer[this._outputTail++] = by4;
        this._outputBuffer[this._outputTail++] = by5;
    }

    private final void _writeBytes(byte by, byte by2, byte by3, byte by4, byte by5, byte by6) throws IOException {
        if (this._outputTail + 5 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = by;
        this._outputBuffer[this._outputTail++] = by2;
        this._outputBuffer[this._outputTail++] = by3;
        this._outputBuffer[this._outputTail++] = by4;
        this._outputBuffer[this._outputTail++] = by5;
        this._outputBuffer[this._outputTail++] = by6;
    }

    private final void _writeBytes(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return;
        }
        if (this._outputTail + n2 >= this._outputEnd) {
            this._writeBytesLong(byArray, n, n2);
            return;
        }
        System.arraycopy(byArray, n, this._outputBuffer, this._outputTail, n2);
        this._outputTail += n2;
    }

    private final int _writeBytes(InputStream inputStream, int n) throws IOException {
        while (n > 0) {
            int n2;
            int n3 = this._outputEnd - this._outputTail;
            if (n3 < 0) {
                this._flushBuffer();
                n3 = this._outputEnd - this._outputTail;
            }
            if ((n2 = inputStream.read(this._outputBuffer, this._outputTail, n3)) < 0) break;
            this._outputTail += n2;
            n -= n2;
        }
        return n;
    }

    private final void _writeBytesLong(byte[] byArray, int n, int n2) throws IOException {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        while (true) {
            int n3 = Math.min(n2, this._outputEnd - this._outputTail);
            System.arraycopy(byArray, n, this._outputBuffer, this._outputTail, n3);
            this._outputTail += n3;
            if ((n2 -= n3) == 0) break;
            n += n3;
            this._flushBuffer();
        }
    }

    private void _writePositiveVInt(int n) throws IOException {
        this._ensureRoomForOutput(5);
        byte by = (byte)(128 + (n & 0x3F));
        if ((n >>= 6) <= 127) {
            if (n > 0) {
                this._outputBuffer[this._outputTail++] = (byte)n;
            }
            this._outputBuffer[this._outputTail++] = by;
            return;
        }
        byte by2 = (byte)(n & 0x7F);
        if ((n >>= 7) <= 127) {
            this._outputBuffer[this._outputTail++] = (byte)n;
            this._outputBuffer[this._outputTail++] = by2;
            this._outputBuffer[this._outputTail++] = by;
        } else {
            byte by3 = (byte)(n & 0x7F);
            if ((n >>= 7) <= 127) {
                this._outputBuffer[this._outputTail++] = (byte)n;
                this._outputBuffer[this._outputTail++] = by3;
                this._outputBuffer[this._outputTail++] = by2;
                this._outputBuffer[this._outputTail++] = by;
            } else {
                byte by4 = (byte)(n & 0x7F);
                this._outputBuffer[this._outputTail++] = (byte)(n >> 7);
                this._outputBuffer[this._outputTail++] = by4;
                this._outputBuffer[this._outputTail++] = by3;
                this._outputBuffer[this._outputTail++] = by2;
                this._outputBuffer[this._outputTail++] = by;
            }
        }
    }

    private void _writeSignedVInt(int n) throws IOException {
        this._writePositiveVInt(SmileUtil.zigzagEncode(n));
    }

    protected void _write7BitBinaryWithLength(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        this._writePositiveVInt(n2);
        while (n2 >= 7) {
            if (this._outputTail + 8 >= this._outputEnd) {
                this._flushBuffer();
            }
            n3 = byArray[n++];
            this._outputBuffer[this._outputTail++] = (byte)(n3 >> 1 & 0x7F);
            n3 = n3 << 8 | byArray[n++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(n3 >> 2 & 0x7F);
            n3 = n3 << 8 | byArray[n++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(n3 >> 3 & 0x7F);
            n3 = n3 << 8 | byArray[n++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(n3 >> 4 & 0x7F);
            n3 = n3 << 8 | byArray[n++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(n3 >> 5 & 0x7F);
            n3 = n3 << 8 | byArray[n++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(n3 >> 6 & 0x7F);
            n3 = n3 << 8 | byArray[n++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(n3 >> 7 & 0x7F);
            this._outputBuffer[this._outputTail++] = (byte)(n3 & 0x7F);
            n2 -= 7;
        }
        if (n2 > 0) {
            if (this._outputTail + 7 >= this._outputEnd) {
                this._flushBuffer();
            }
            n3 = byArray[n++];
            this._outputBuffer[this._outputTail++] = (byte)(n3 >> 1 & 0x7F);
            if (n2 > 1) {
                n3 = (n3 & 1) << 8 | byArray[n++] & 0xFF;
                this._outputBuffer[this._outputTail++] = (byte)(n3 >> 2 & 0x7F);
                if (n2 > 2) {
                    n3 = (n3 & 3) << 8 | byArray[n++] & 0xFF;
                    this._outputBuffer[this._outputTail++] = (byte)(n3 >> 3 & 0x7F);
                    if (n2 > 3) {
                        n3 = (n3 & 7) << 8 | byArray[n++] & 0xFF;
                        this._outputBuffer[this._outputTail++] = (byte)(n3 >> 4 & 0x7F);
                        if (n2 > 4) {
                            n3 = (n3 & 0xF) << 8 | byArray[n++] & 0xFF;
                            this._outputBuffer[this._outputTail++] = (byte)(n3 >> 5 & 0x7F);
                            if (n2 > 5) {
                                n3 = (n3 & 0x1F) << 8 | byArray[n++] & 0xFF;
                                this._outputBuffer[this._outputTail++] = (byte)(n3 >> 6 & 0x7F);
                                this._outputBuffer[this._outputTail++] = (byte)(n3 & 0x3F);
                            } else {
                                this._outputBuffer[this._outputTail++] = (byte)(n3 & 0x1F);
                            }
                        } else {
                            this._outputBuffer[this._outputTail++] = (byte)(n3 & 0xF);
                        }
                    } else {
                        this._outputBuffer[this._outputTail++] = (byte)(n3 & 7);
                    }
                } else {
                    this._outputBuffer[this._outputTail++] = (byte)(n3 & 3);
                }
            } else {
                this._outputBuffer[this._outputTail++] = (byte)(n3 & 1);
            }
        }
    }

    protected int _write7BitBinaryWithLength(InputStream inputStream, int n, byte[] byArray) throws IOException {
        int n2;
        this._writePositiveVInt(n);
        int n3 = 0;
        int n4 = 0;
        int n5 = -7;
        while (n >= 7) {
            if (n3 > n5) {
                n4 = this._readMore(inputStream, byArray, n3, n4, n);
                n3 = 0;
                if (n4 < 7) {
                    n -= n4;
                    break;
                }
                n5 = n4 - 7;
            }
            if (this._outputTail + 8 >= this._outputEnd) {
                this._flushBuffer();
            }
            n2 = byArray[n3++];
            this._outputBuffer[this._outputTail++] = (byte)(n2 >> 1 & 0x7F);
            n2 = n2 << 8 | byArray[n3++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(n2 >> 2 & 0x7F);
            n2 = n2 << 8 | byArray[n3++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(n2 >> 3 & 0x7F);
            n2 = n2 << 8 | byArray[n3++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(n2 >> 4 & 0x7F);
            n2 = n2 << 8 | byArray[n3++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(n2 >> 5 & 0x7F);
            n2 = n2 << 8 | byArray[n3++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(n2 >> 6 & 0x7F);
            n2 = n2 << 8 | byArray[n3++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(n2 >> 7 & 0x7F);
            this._outputBuffer[this._outputTail++] = (byte)(n2 & 0x7F);
            n -= 7;
        }
        if (n > 0) {
            if (this._outputTail + 7 >= this._outputEnd) {
                this._flushBuffer();
            }
            n4 = this._readMore(inputStream, byArray, n3, n4, n);
            n3 = 0;
            if (n4 > 0) {
                n -= n4;
                n2 = byArray[n3++];
                this._outputBuffer[this._outputTail++] = (byte)(n2 >> 1 & 0x7F);
                if (n4 > 1) {
                    n2 = (n2 & 1) << 8 | byArray[n3++] & 0xFF;
                    this._outputBuffer[this._outputTail++] = (byte)(n2 >> 2 & 0x7F);
                    if (n4 > 2) {
                        n2 = (n2 & 3) << 8 | byArray[n3++] & 0xFF;
                        this._outputBuffer[this._outputTail++] = (byte)(n2 >> 3 & 0x7F);
                        if (n4 > 3) {
                            n2 = (n2 & 7) << 8 | byArray[n3++] & 0xFF;
                            this._outputBuffer[this._outputTail++] = (byte)(n2 >> 4 & 0x7F);
                            if (n4 > 4) {
                                n2 = (n2 & 0xF) << 8 | byArray[n3++] & 0xFF;
                                this._outputBuffer[this._outputTail++] = (byte)(n2 >> 5 & 0x7F);
                                if (n4 > 5) {
                                    n2 = (n2 & 0x1F) << 8 | byArray[n3++] & 0xFF;
                                    this._outputBuffer[this._outputTail++] = (byte)(n2 >> 6 & 0x7F);
                                    this._outputBuffer[this._outputTail++] = (byte)(n2 & 0x3F);
                                } else {
                                    this._outputBuffer[this._outputTail++] = (byte)(n2 & 0x1F);
                                }
                            } else {
                                this._outputBuffer[this._outputTail++] = (byte)(n2 & 0xF);
                            }
                        } else {
                            this._outputBuffer[this._outputTail++] = (byte)(n2 & 7);
                        }
                    } else {
                        this._outputBuffer[this._outputTail++] = (byte)(n2 & 3);
                    }
                } else {
                    this._outputBuffer[this._outputTail++] = (byte)(n2 & 1);
                }
            }
        }
        return n;
    }

    private int _readMore(InputStream inputStream, byte[] byArray, int n, int n2, int n3) throws IOException {
        int n4;
        int n5 = 0;
        while (n < n2) {
            byArray[n5++] = byArray[n++];
        }
        n = 0;
        n2 = n5;
        n3 = Math.min(n3, byArray.length);
        while ((n4 = n3 - n2) != 0) {
            int n6 = inputStream.read(byArray, n2, n4);
            if (n6 < 0) {
                return n2;
            }
            if ((n2 += n6) < 7) continue;
        }
        return n2;
    }

    @Override
    protected void _releaseBuffers() {
        Object[] objectArray;
        char[] cArray;
        byte[] byArray = this._outputBuffer;
        if (byArray != null && this._bufferRecyclable) {
            this._outputBuffer = null;
            this._ioContext.releaseWriteEncodingBuffer(byArray);
        }
        if ((cArray = this._charBuffer) != null) {
            this._charBuffer = null;
            this._ioContext.releaseConcatBuffer(cArray);
        }
        if ((objectArray = this._seenNames) != null && objectArray.length == 64) {
            this._seenNames = null;
            if (this._seenNameCount > 0) {
                Arrays.fill(objectArray, null);
            }
            this._smileBufferRecycler.releaseSeenNamesBuffer((SharedStringNode[])objectArray);
        }
        if ((objectArray = this._seenStringValues) != null && objectArray.length == 64) {
            this._seenStringValues = null;
            if (this._seenStringValueCount > 0) {
                Arrays.fill(objectArray, null);
            }
            this._smileBufferRecycler.releaseSeenStringValuesBuffer((SharedStringNode[])objectArray);
        }
    }

    protected final void _flushBuffer() throws IOException {
        if (this._outputTail > 0) {
            this._bytesWritten += this._outputTail;
            this._out.write(this._outputBuffer, 0, this._outputTail);
            this._outputTail = 0;
        }
    }

    private final int _findSeenName(String string) {
        int n = string.hashCode();
        SharedStringNode sharedStringNode = this._seenNames[n & this._seenNames.length - 1];
        if (sharedStringNode == null) {
            return -1;
        }
        SharedStringNode sharedStringNode2 = sharedStringNode;
        if (sharedStringNode2.value == string) {
            return sharedStringNode2.index;
        }
        while ((sharedStringNode2 = sharedStringNode2.next) != null) {
            if (sharedStringNode2.value != string) continue;
            return sharedStringNode2.index;
        }
        sharedStringNode2 = sharedStringNode;
        do {
            String string2;
            if ((string2 = sharedStringNode2.value).hashCode() != n || !string2.equals(string)) continue;
            return sharedStringNode2.index;
        } while ((sharedStringNode2 = sharedStringNode2.next) != null);
        return -1;
    }

    private final void _addSeenName(String string) {
        if (this._seenNameCount == this._seenNames.length) {
            if (this._seenNameCount == 1024) {
                Arrays.fill(this._seenNames, null);
                this._seenNameCount = 0;
            } else {
                SharedStringNode[] sharedStringNodeArray = this._seenNames;
                this._seenNames = new SharedStringNode[1024];
                for (SharedStringNode sharedStringNode : sharedStringNodeArray) {
                    while (sharedStringNode != null) {
                        int n = sharedStringNode.value.hashCode() & 0x3FF;
                        SharedStringNode sharedStringNode2 = sharedStringNode.next;
                        sharedStringNode.next = this._seenNames[n];
                        this._seenNames[n] = sharedStringNode;
                        sharedStringNode = sharedStringNode2;
                    }
                }
            }
        }
        int n = string.hashCode() & this._seenNames.length - 1;
        this._seenNames[n] = new SharedStringNode(string, this._seenNameCount, this._seenNames[n]);
        ++this._seenNameCount;
    }

    private final int _findSeenStringValue(String string) {
        int n = string.hashCode();
        SharedStringNode sharedStringNode = this._seenStringValues[n & this._seenStringValues.length - 1];
        if (sharedStringNode != null) {
            SharedStringNode sharedStringNode2 = sharedStringNode;
            do {
                if (sharedStringNode2.value != string) continue;
                return sharedStringNode2.index;
            } while ((sharedStringNode2 = sharedStringNode2.next) != null);
            sharedStringNode2 = sharedStringNode;
            do {
                String string2;
                if ((string2 = sharedStringNode2.value).hashCode() != n || !string2.equals(string)) continue;
                return sharedStringNode2.index;
            } while ((sharedStringNode2 = sharedStringNode2.next) != null);
        }
        return -1;
    }

    private final void _addSeenStringValue(String string) {
        if (this._seenStringValueCount == this._seenStringValues.length) {
            if (this._seenStringValueCount == 1024) {
                Arrays.fill(this._seenStringValues, null);
                this._seenStringValueCount = 0;
            } else {
                SharedStringNode[] sharedStringNodeArray = this._seenStringValues;
                this._seenStringValues = new SharedStringNode[1024];
                for (SharedStringNode sharedStringNode : sharedStringNodeArray) {
                    while (sharedStringNode != null) {
                        int n = sharedStringNode.value.hashCode() & 0x3FF;
                        SharedStringNode sharedStringNode2 = sharedStringNode.next;
                        sharedStringNode.next = this._seenStringValues[n];
                        this._seenStringValues[n] = sharedStringNode;
                        sharedStringNode = sharedStringNode2;
                    }
                }
            }
        }
        int n = string.hashCode() & this._seenStringValues.length - 1;
        this._seenStringValues[n] = new SharedStringNode(string, this._seenStringValueCount, this._seenStringValues[n]);
        ++this._seenStringValueCount;
    }

    protected long outputOffset() {
        return this._bytesWritten + this._outputTail;
    }

    protected UnsupportedOperationException _notSupported() {
        return new UnsupportedOperationException();
    }

    protected static final class SharedStringNode {
        public final String value;
        public final int index;
        public SharedStringNode next;

        public SharedStringNode(String string, int n, SharedStringNode sharedStringNode) {
            this.value = string;
            this.index = n;
            this.next = sharedStringNode;
        }
    }

    public static enum Feature {
        WRITE_HEADER(true),
        WRITE_END_MARKER(false),
        ENCODE_BINARY_AS_7BIT(true),
        CHECK_SHARED_NAMES(true),
        CHECK_SHARED_STRING_VALUES(false);

        protected final boolean _defaultState;
        protected final int _mask;

        public static int collectDefaults() {
            int n = 0;
            for (Feature feature : Feature.values()) {
                if (!feature.enabledByDefault()) continue;
                n |= feature.getMask();
            }
            return n;
        }

        private Feature(boolean bl) {
            this._defaultState = bl;
            this._mask = 1 << this.ordinal();
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public int getMask() {
            return this._mask;
        }
    }
}

