/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.jackson.dataformat.yaml;

import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.regex.Pattern;
import org.elasticsearch.common.jackson.core.Base64Variant;
import org.elasticsearch.common.jackson.core.JsonLocation;
import org.elasticsearch.common.jackson.core.JsonParseException;
import org.elasticsearch.common.jackson.core.JsonParser;
import org.elasticsearch.common.jackson.core.JsonToken;
import org.elasticsearch.common.jackson.core.ObjectCodec;
import org.elasticsearch.common.jackson.core.Version;
import org.elasticsearch.common.jackson.core.base.ParserBase;
import org.elasticsearch.common.jackson.core.io.IOContext;
import org.elasticsearch.common.jackson.core.util.BufferRecycler;
import org.elasticsearch.common.jackson.core.util.ByteArrayBuilder;
import org.elasticsearch.common.jackson.dataformat.yaml.PackageVersion;
import org.elasticsearch.common.jackson.dataformat.yaml.snakeyaml.error.Mark;
import org.elasticsearch.common.jackson.dataformat.yaml.snakeyaml.events.AliasEvent;
import org.elasticsearch.common.jackson.dataformat.yaml.snakeyaml.events.Event;
import org.elasticsearch.common.jackson.dataformat.yaml.snakeyaml.events.NodeEvent;
import org.elasticsearch.common.jackson.dataformat.yaml.snakeyaml.events.ScalarEvent;
import org.elasticsearch.common.jackson.dataformat.yaml.snakeyaml.parser.ParserImpl;
import org.elasticsearch.common.jackson.dataformat.yaml.snakeyaml.reader.StreamReader;

public class YAMLParser
extends ParserBase {
    private static final Pattern PATTERN_FLOAT = Pattern.compile("[-+]?([0-9][0-9_]*)?\\.[0-9]*([eE][-+][0-9]+)?");
    protected ObjectCodec _objectCodec;
    protected int _yamlFeatures;
    protected Reader _reader;
    protected ParserImpl _yamlParser;
    protected Event _lastEvent;
    protected String _textValue;
    protected String _currentFieldName;
    protected boolean _currentIsAlias;
    protected String _currentAnchor;

    public YAMLParser(IOContext iOContext, BufferRecycler bufferRecycler, int n, int n2, ObjectCodec objectCodec, Reader reader) {
        super(iOContext, n);
        this._objectCodec = objectCodec;
        this._yamlFeatures = n2;
        this._reader = reader;
        this._yamlParser = new ParserImpl(new StreamReader(reader));
    }

    @Override
    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    @Override
    public void setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
    }

    public boolean isCurrentAlias() {
        return this._currentIsAlias;
    }

    public String getCurrentAnchor() {
        return this._currentAnchor;
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    protected boolean loadMore() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void _finishString() throws IOException, JsonParseException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void _closeInput() throws IOException {
        this._reader.close();
    }

    public JsonParser enable(Feature feature) {
        this._yamlFeatures |= feature.getMask();
        return this;
    }

    public JsonParser disable(Feature feature) {
        this._yamlFeatures &= ~feature.getMask();
        return this;
    }

    public JsonParser configure(Feature feature, boolean bl) {
        if (bl) {
            this.enable(feature);
        } else {
            this.disable(feature);
        }
        return this;
    }

    public boolean isEnabled(Feature feature) {
        return (this._yamlFeatures & feature.getMask()) != 0;
    }

    @Override
    public JsonLocation getTokenLocation() {
        if (this._lastEvent == null) {
            return JsonLocation.NA;
        }
        return this._locationFor(this._lastEvent.getStartMark());
    }

    @Override
    public JsonLocation getCurrentLocation() {
        if (this._lastEvent == null) {
            return JsonLocation.NA;
        }
        return this._locationFor(this._lastEvent.getEndMark());
    }

    protected JsonLocation _locationFor(Mark mark) {
        if (mark == null) {
            return new JsonLocation(this._ioContext.getSourceReference(), -1L, -1, -1);
        }
        return new JsonLocation(this._ioContext.getSourceReference(), -1L, mark.getLine() + 1, mark.getColumn() + 1);
    }

    @Override
    public JsonToken nextToken() throws IOException, JsonParseException {
        this._currentIsAlias = false;
        this._binaryValue = null;
        this._currentAnchor = null;
        if (this._closed) {
            return null;
        }
        while (true) {
            Event event;
            if ((event = this._yamlParser.getEvent()) == null) {
                this._currToken = null;
                return null;
            }
            this._lastEvent = event;
            if (this._parsingContext.inObject() && this._currToken != JsonToken.FIELD_NAME) {
                String string;
                if (!event.is(Event.ID.Scalar)) {
                    if (event.is(Event.ID.MappingEnd)) {
                        if (!this._parsingContext.inObject()) {
                            this._reportMismatchedEndMarker(125, ']');
                        }
                        this._parsingContext = this._parsingContext.getParent();
                        this._currToken = JsonToken.END_OBJECT;
                        return this._currToken;
                    }
                    this._reportError("Expected a field name (Scalar value in YAML), got this instead: " + event);
                }
                ScalarEvent scalarEvent = (ScalarEvent)event;
                this._currentFieldName = string = scalarEvent.getValue();
                this._parsingContext.setCurrentName(string);
                this._currentAnchor = scalarEvent.getAnchor();
                this._currToken = JsonToken.FIELD_NAME;
                return this._currToken;
            }
            if (event.is(Event.ID.Scalar)) {
                this._currToken = this._decodeScalar((ScalarEvent)event);
                return this._currToken;
            }
            if (event.is(Event.ID.MappingStart)) {
                Mark mark = event.getStartMark();
                this._currentAnchor = ((NodeEvent)event).getAnchor();
                this._parsingContext = this._parsingContext.createChildObjectContext(mark.getLine(), mark.getColumn());
                this._currToken = JsonToken.START_OBJECT;
                return this._currToken;
            }
            if (event.is(Event.ID.MappingEnd)) {
                this._reportError("Not expecting END_OBJECT but a value");
            }
            if (event.is(Event.ID.SequenceStart)) {
                Mark mark = event.getStartMark();
                this._currentAnchor = ((NodeEvent)event).getAnchor();
                this._parsingContext = this._parsingContext.createChildArrayContext(mark.getLine(), mark.getColumn());
                this._currToken = JsonToken.START_ARRAY;
                return this._currToken;
            }
            if (event.is(Event.ID.SequenceEnd)) {
                if (!this._parsingContext.inArray()) {
                    this._reportMismatchedEndMarker(93, '}');
                }
                this._parsingContext = this._parsingContext.getParent();
                this._currToken = JsonToken.END_ARRAY;
                return this._currToken;
            }
            if (event.is(Event.ID.DocumentEnd)) {
                this._currToken = null;
                return null;
            }
            if (event.is(Event.ID.DocumentStart)) continue;
            if (event.is(Event.ID.Alias)) {
                AliasEvent aliasEvent = (AliasEvent)event;
                this._currentIsAlias = true;
                this._textValue = aliasEvent.getAnchor();
                this._currToken = JsonToken.VALUE_STRING;
                return this._currToken;
            }
            if (event.is(Event.ID.StreamEnd)) {
                this.close();
                this._currToken = null;
                return null;
            }
            if (!event.is(Event.ID.StreamStart)) continue;
        }
    }

    protected JsonToken _decodeScalar(ScalarEvent scalarEvent) {
        String string;
        this._textValue = string = scalarEvent.getValue();
        String string2 = scalarEvent.getTag();
        int n = string.length();
        if (string2 == null) {
            Character c = scalarEvent.getStyle();
            if ((c == null || c.charValue() == '\u0000') && n > 0) {
                Object object;
                char c2 = string.charAt(0);
                switch (c2) {
                    case 'n': {
                        if ("null".equals(string)) {
                            return JsonToken.VALUE_NULL;
                        }
                    }
                    case '+': 
                    case '-': 
                    case '.': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        object = this._decodeNumberScalar(string, n);
                        if (object == null) break;
                        return object;
                    }
                }
                object = this._matchYAMLBoolean(string, n);
                if (object != null) {
                    return ((Boolean)object).booleanValue() ? JsonToken.VALUE_TRUE : JsonToken.VALUE_FALSE;
                }
            }
        } else if ("bool".equals(string2)) {
            Boolean bl = this._matchYAMLBoolean(string, n);
            if (bl != null) {
                return bl != false ? JsonToken.VALUE_TRUE : JsonToken.VALUE_FALSE;
            }
        } else {
            if ("int".equals(string2)) {
                return JsonToken.VALUE_NUMBER_INT;
            }
            if ("float".equals(string2)) {
                return JsonToken.VALUE_NUMBER_FLOAT;
            }
            if ("null".equals(string2)) {
                return JsonToken.VALUE_NULL;
            }
        }
        this._currToken = JsonToken.VALUE_STRING;
        return this._currToken;
    }

    protected Boolean _matchYAMLBoolean(String string, int n) {
        switch (n) {
            case 1: {
                switch (string.charAt(0)) {
                    case 'Y': 
                    case 'y': {
                        return Boolean.TRUE;
                    }
                    case 'N': 
                    case 'n': {
                        return Boolean.FALSE;
                    }
                }
                break;
            }
            case 2: {
                if ("no".equalsIgnoreCase(string)) {
                    return Boolean.FALSE;
                }
                if (!"on".equalsIgnoreCase(string)) break;
                return Boolean.TRUE;
            }
            case 3: {
                if ("yes".equalsIgnoreCase(string)) {
                    return Boolean.TRUE;
                }
                if (!"off".equalsIgnoreCase(string)) break;
                return Boolean.FALSE;
            }
            case 4: {
                if (!"true".equalsIgnoreCase(string)) break;
                return Boolean.TRUE;
            }
            case 5: {
                if (!"false".equalsIgnoreCase(string)) break;
                return Boolean.FALSE;
            }
        }
        return null;
    }

    protected JsonToken _decodeNumberScalar(String string, int n) {
        char c;
        int n2;
        if ("0".equals(string)) {
            this._numberNegative = false;
            this._numberInt = 0;
            this._numTypesValid = 1;
            return JsonToken.VALUE_NUMBER_INT;
        }
        if (string.charAt(0) == '-') {
            this._numberNegative = true;
            n2 = 1;
            if (n == 1) {
                return null;
            }
        } else {
            this._numberNegative = false;
            n2 = 0;
        }
        while ((c = string.charAt(n2)) <= '9' && c >= '0') {
            if (++n2 != n) continue;
            this._numTypesValid = 0;
            return JsonToken.VALUE_NUMBER_INT;
        }
        if (PATTERN_FLOAT.matcher(string).matches()) {
            this._numTypesValid = 0;
            return JsonToken.VALUE_NUMBER_FLOAT;
        }
        return null;
    }

    @Override
    public boolean hasTextCharacters() {
        return false;
    }

    @Override
    public String getText() throws IOException, JsonParseException {
        if (this._currToken == JsonToken.VALUE_STRING) {
            return this._textValue;
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this._currentFieldName;
        }
        if (this._currToken != null) {
            if (this._currToken.isScalarValue()) {
                return this._textValue;
            }
            return this._currToken.asString();
        }
        return null;
    }

    @Override
    public String getCurrentName() throws IOException, JsonParseException {
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this._currentFieldName;
        }
        return super.getCurrentName();
    }

    @Override
    public char[] getTextCharacters() throws IOException, JsonParseException {
        String string = this.getText();
        return string == null ? null : string.toCharArray();
    }

    @Override
    public int getTextLength() throws IOException, JsonParseException {
        String string = this.getText();
        return string == null ? 0 : string.length();
    }

    @Override
    public int getTextOffset() throws IOException, JsonParseException {
        return 0;
    }

    @Override
    public Object getEmbeddedObject() throws IOException, JsonParseException {
        return null;
    }

    @Override
    public byte[] getBinaryValue(Base64Variant base64Variant) throws IOException, JsonParseException {
        if (this._binaryValue == null) {
            if (this._currToken != JsonToken.VALUE_STRING) {
                this._reportError("Current token (" + (Object)((Object)this._currToken) + ") not VALUE_STRING, can not access as binary");
            }
            ByteArrayBuilder byteArrayBuilder = this._getByteArrayBuilder();
            this._decodeBase64(this.getText(), byteArrayBuilder, base64Variant);
            this._binaryValue = byteArrayBuilder.toByteArray();
        }
        return this._binaryValue;
    }

    @Override
    protected void _parseNumericValue(int n) throws IOException, JsonParseException {
        if (this._currToken == JsonToken.VALUE_NUMBER_INT) {
            int n2 = this._textValue.length();
            if (this._numberNegative) {
                --n2;
            }
            if (n2 <= 9) {
                this._numberInt = Integer.parseInt(this._textValue);
                this._numTypesValid = 1;
                return;
            }
            if (n2 <= 18) {
                long l = Long.parseLong(this._textValue);
                if (n2 == 10) {
                    if (this._numberNegative) {
                        if (l >= Integer.MIN_VALUE) {
                            this._numberInt = (int)l;
                            this._numTypesValid = 1;
                            return;
                        }
                    } else if (l <= Integer.MAX_VALUE) {
                        this._numberInt = (int)l;
                        this._numTypesValid = 1;
                        return;
                    }
                }
                this._numberLong = l;
                this._numTypesValid = 2;
                return;
            }
            try {
                BigInteger bigInteger = new BigInteger(this._textValue);
                if (n2 == 19 && bigInteger.bitLength() <= 63) {
                    this._numberLong = bigInteger.longValue();
                    this._numTypesValid = 2;
                    return;
                }
                this._numberBigInt = bigInteger;
                this._numTypesValid = 4;
                return;
            }
            catch (NumberFormatException numberFormatException) {
                this._wrapError("Malformed numeric value '" + this._textValue + "'", numberFormatException);
            }
        }
        if (this._currToken == JsonToken.VALUE_NUMBER_FLOAT) {
            String string = this._cleanYamlDouble(this._textValue);
            try {
                if (n == 16) {
                    this._numberBigDecimal = new BigDecimal(string);
                    this._numTypesValid = 16;
                } else {
                    this._numberDouble = Double.parseDouble(string);
                    this._numTypesValid = 8;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this._wrapError("Malformed numeric value '" + string + "'", numberFormatException);
            }
            return;
        }
        this._reportError("Current token (" + (Object)((Object)this._currToken) + ") not numeric, can not use numeric value accessors");
    }

    private String _cleanYamlDouble(String string) {
        int n;
        int n2 = string.length();
        int n3 = string.indexOf(95);
        if (n3 < 0 || n2 == 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(n2);
        int n4 = n = string.charAt(0) == '+' ? 1 : 0;
        while (n < n2) {
            char c = string.charAt(n);
            if (c != '_') {
                stringBuilder.append(c);
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    public static enum Feature {
        BOGUS(false);

        final boolean _defaultState;
        final int _mask;

        public static int collectDefaults() {
            int n = 0;
            for (Feature feature : Feature.values()) {
                if (!feature.enabledByDefault()) continue;
                n |= feature.getMask();
            }
            return n;
        }

        private Feature(boolean bl) {
            this._defaultState = bl;
            this._mask = 1 << this.ordinal();
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public int getMask() {
            return this._mask;
        }
    }
}

