/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;

public class TermFilter
extends Filter {
    private final Term term;

    public TermFilter(Term term) {
        this.term = term;
    }

    public Term getTerm() {
        return this.term;
    }

    public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
        Terms terms = context.reader().terms(this.term.field());
        if (terms == null) {
            return null;
        }
        TermsEnum termsEnum = terms.iterator(null);
        if (!termsEnum.seekExact(this.term.bytes(), false)) {
            return null;
        }
        DocsEnum docsEnum = termsEnum.docs(acceptDocs, null);
        int docId = docsEnum.nextDoc();
        if (docId == Integer.MAX_VALUE) {
            return null;
        }
        FixedBitSet result = new FixedBitSet(context.reader().maxDoc());
        while (docId < Integer.MAX_VALUE) {
            result.set(docId);
            docId = docsEnum.nextDoc();
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        TermFilter that = (TermFilter)((Object)o);
        return !(this.term != null ? !this.term.equals((Object)that.term) : that.term != null);
    }

    public int hashCode() {
        return this.term != null ? this.term.hashCode() : 0;
    }

    public String toString() {
        return this.term.field() + ":" + this.term.text();
    }
}

