/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search.function;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.ToStringUtils;
import org.elasticsearch.common.lucene.search.function.ScoreFunction;

public class FunctionScoreQuery
extends Query {
    Query subQuery;
    final ScoreFunction function;

    public FunctionScoreQuery(Query subQuery, ScoreFunction function) {
        this.subQuery = subQuery;
        this.function = function;
    }

    public Query getSubQuery() {
        return this.subQuery;
    }

    public ScoreFunction getFunction() {
        return this.function;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query newQ = this.subQuery.rewrite(reader);
        if (newQ == this.subQuery) {
            return this;
        }
        FunctionScoreQuery bq = (FunctionScoreQuery)this.clone();
        bq.subQuery = newQ;
        return bq;
    }

    public void extractTerms(Set<Term> terms) {
        this.subQuery.extractTerms(terms);
    }

    public Weight createWeight(IndexSearcher searcher) throws IOException {
        Weight subQueryWeight = this.subQuery.createWeight(searcher);
        return new CustomBoostFactorWeight(subQueryWeight);
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("custom score (").append(this.subQuery.toString(field)).append(",function=").append(this.function).append(')');
        sb.append(ToStringUtils.boost((float)this.getBoost()));
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        FunctionScoreQuery other = (FunctionScoreQuery)((Object)o);
        return this.getBoost() == other.getBoost() && this.subQuery.equals((Object)other.subQuery) && this.function.equals(other.function);
    }

    public int hashCode() {
        return this.subQuery.hashCode() + 31 * this.function.hashCode() ^ Float.floatToIntBits(this.getBoost());
    }

    static class CustomBoostFactorScorer
    extends Scorer {
        private final float subQueryBoost;
        private final Scorer scorer;
        private final ScoreFunction function;

        private CustomBoostFactorScorer(CustomBoostFactorWeight w, Scorer scorer, ScoreFunction function) throws IOException {
            super((Weight)w);
            this.subQueryBoost = w.getQuery().getBoost();
            this.scorer = scorer;
            this.function = function;
        }

        public int docID() {
            return this.scorer.docID();
        }

        public int advance(int target) throws IOException {
            return this.scorer.advance(target);
        }

        public int nextDoc() throws IOException {
            return this.scorer.nextDoc();
        }

        public float score() throws IOException {
            return this.subQueryBoost * this.function.score(this.scorer.docID(), this.scorer.score());
        }

        public int freq() throws IOException {
            return this.scorer.freq();
        }

        public long cost() {
            return this.scorer.cost();
        }
    }

    class CustomBoostFactorWeight
    extends Weight {
        final Weight subQueryWeight;

        public CustomBoostFactorWeight(Weight subQueryWeight) throws IOException {
            this.subQueryWeight = subQueryWeight;
        }

        public Query getQuery() {
            return FunctionScoreQuery.this;
        }

        public float getValueForNormalization() throws IOException {
            float sum = this.subQueryWeight.getValueForNormalization();
            return sum *= FunctionScoreQuery.this.getBoost() * FunctionScoreQuery.this.getBoost();
        }

        public void normalize(float norm, float topLevelBoost) {
            this.subQueryWeight.normalize(norm, topLevelBoost * FunctionScoreQuery.this.getBoost());
        }

        public Scorer scorer(AtomicReaderContext context, boolean scoreDocsInOrder, boolean topScorer, Bits acceptDocs) throws IOException {
            Scorer subQueryScorer = this.subQueryWeight.scorer(context, scoreDocsInOrder, false, acceptDocs);
            if (subQueryScorer == null) {
                return null;
            }
            FunctionScoreQuery.this.function.setNextReader(context);
            return new CustomBoostFactorScorer(this, subQueryScorer, FunctionScoreQuery.this.function);
        }

        public Explanation explain(AtomicReaderContext context, int doc) throws IOException {
            Explanation subQueryExpl = this.subQueryWeight.explain(context, doc);
            if (!subQueryExpl.isMatch()) {
                return subQueryExpl;
            }
            FunctionScoreQuery.this.function.setNextReader(context);
            Explanation functionExplanation = FunctionScoreQuery.this.function.explainScore(doc, subQueryExpl);
            float sc = FunctionScoreQuery.this.getBoost() * functionExplanation.getValue();
            ComplexExplanation res = new ComplexExplanation(true, sc, "custom score, product of:");
            res.addDetail(functionExplanation);
            res.addDetail(new Explanation(FunctionScoreQuery.this.getBoost(), "queryBoost"));
            return res;
        }
    }
}

