/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.store;

import java.io.IOException;
import java.util.zip.Checksum;
import org.apache.lucene.store.BufferedIndexOutput;
import org.apache.lucene.store.IndexOutput;

public class BufferedChecksumIndexOutput
extends BufferedIndexOutput {
    private final IndexOutput out;
    private final Checksum digest;

    public BufferedChecksumIndexOutput(IndexOutput out, Checksum digest) {
        super(16448);
        this.out = out;
        this.digest = digest;
    }

    public Checksum digest() {
        return this.digest;
    }

    public IndexOutput underlying() {
        return this.out;
    }

    public void close() throws IOException {
        super.close();
        this.out.close();
    }

    protected void flushBuffer(byte[] b, int offset, int len) throws IOException {
        this.out.writeBytes(b, offset, len);
        this.digest.update(b, offset, len);
    }

    public void flush() throws IOException {
        super.flush();
        this.out.flush();
    }

    public void seek(long pos) throws IOException {
        super.seek(pos);
        this.out.seek(pos);
    }

    public long length() throws IOException {
        return this.out.length();
    }

    public void setLength(long length) throws IOException {
        this.out.setLength(length);
    }

    public String toString() {
        return this.out.toString();
    }
}

