/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;

public class ThreadLocals {
    private static final ESLogger logger = Loggers.getLogger(ThreadLocals.class);

    public static void clearReferencesThreadLocals() {
        try {
            Thread[] threads = ThreadLocals.getThreads();
            Field threadLocalsField = Thread.class.getDeclaredField("threadLocals");
            threadLocalsField.setAccessible(true);
            Field inheritableThreadLocalsField = Thread.class.getDeclaredField("inheritableThreadLocals");
            inheritableThreadLocalsField.setAccessible(true);
            Class<?> tlmClass = Class.forName("java.lang.ThreadLocal$ThreadLocalMap");
            Field tableField = tlmClass.getDeclaredField("table");
            tableField.setAccessible(true);
            for (int i = 0; i < threads.length; ++i) {
                if (threads[i] == null) continue;
                Object threadLocalMap = threadLocalsField.get(threads[i]);
                ThreadLocals.clearThreadLocalMap(threadLocalMap, tableField);
                threadLocalMap = inheritableThreadLocalsField.get(threads[i]);
                ThreadLocals.clearThreadLocalMap(threadLocalMap, tableField);
            }
        }
        catch (Exception e) {
            logger.debug("failed to clean thread locals", e, new Object[0]);
        }
    }

    private static void clearThreadLocalMap(Object map, Field internalTableField) throws NoSuchMethodException, IllegalAccessException, NoSuchFieldException, InvocationTargetException {
        if (map != null) {
            Method mapRemove = map.getClass().getDeclaredMethod("remove", ThreadLocal.class);
            mapRemove.setAccessible(true);
            Object[] table = (Object[])internalTableField.get(map);
            int staleEntriesCount = 0;
            if (table != null) {
                for (int j = 0; j < table.length; ++j) {
                    Object tableValue = table[j];
                    if (tableValue == null) continue;
                    boolean remove = false;
                    Object key = ((Reference)tableValue).get();
                    Field valueField = tableValue.getClass().getDeclaredField("value");
                    valueField.setAccessible(true);
                    Object value = valueField.get(tableValue);
                    if (value != null) {
                        String actualValueClassName;
                        Object actualValue = value;
                        if (value instanceof SoftReference) {
                            actualValue = ((SoftReference)value).get();
                        }
                        if (actualValue != null && ((actualValueClassName = actualValue.getClass().getName()).startsWith("org.elasticsearch") || actualValueClassName.startsWith("org.apache.lucene"))) {
                            remove = true;
                        }
                    }
                    if (!remove) continue;
                    Object[] args = new Object[4];
                    if (key != null) {
                        args[0] = key.getClass().getCanonicalName();
                        args[1] = key.toString();
                    }
                    args[2] = value.getClass().getCanonicalName();
                    args[3] = value.toString();
                    if (logger.isTraceEnabled()) {
                        logger.trace("ThreadLocal with key of type [{}] (value [{}]) and a value of type [{}] (value [{}]):  The ThreadLocal has been forcibly removed.", args);
                    }
                    if (key == null) {
                        ++staleEntriesCount;
                        continue;
                    }
                    mapRemove.invoke(map, key);
                }
            }
            if (staleEntriesCount > 0) {
                Method mapRemoveStale = map.getClass().getDeclaredMethod("expungeStaleEntries", new Class[0]);
                mapRemoveStale.setAccessible(true);
                mapRemoveStale.invoke(map, new Object[0]);
            }
        }
    }

    private static Thread[] getThreads() {
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        while (tg.getParent() != null) {
            tg = tg.getParent();
        }
        int threadCountGuess = tg.activeCount() + 50;
        Thread[] threads = new Thread[threadCountGuess];
        int threadCountActual = tg.enumerate(threads);
        while (threadCountActual == threadCountGuess) {
            threads = new Thread[threadCountGuess *= 2];
            threadCountActual = tg.enumerate(threads);
        }
        return threads;
    }
}

