/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent.json;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.jackson.core.JsonGenerator;
import org.elasticsearch.common.xcontent.XContentGenerator;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentString;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.json.JsonXContentParser;

public class JsonXContentGenerator
implements XContentGenerator {
    protected final JsonGenerator generator;

    public JsonXContentGenerator(JsonGenerator generator) {
        this.generator = generator;
    }

    @Override
    public XContentType contentType() {
        return XContentType.JSON;
    }

    @Override
    public void usePrettyPrint() {
        this.generator.useDefaultPrettyPrinter();
    }

    @Override
    public void writeStartArray() throws IOException {
        this.generator.writeStartArray();
    }

    @Override
    public void writeEndArray() throws IOException {
        this.generator.writeEndArray();
    }

    @Override
    public void writeStartObject() throws IOException {
        this.generator.writeStartObject();
    }

    @Override
    public void writeEndObject() throws IOException {
        this.generator.writeEndObject();
    }

    @Override
    public void writeFieldName(String name) throws IOException {
        this.generator.writeFieldName(name);
    }

    @Override
    public void writeFieldName(XContentString name) throws IOException {
        this.generator.writeFieldName(name);
    }

    @Override
    public void writeString(String text) throws IOException {
        this.generator.writeString(text);
    }

    @Override
    public void writeString(char[] text, int offset, int len) throws IOException {
        this.generator.writeString(text, offset, len);
    }

    @Override
    public void writeUTF8String(byte[] text, int offset, int length) throws IOException {
        this.generator.writeUTF8String(text, offset, length);
    }

    @Override
    public void writeBinary(byte[] data, int offset, int len) throws IOException {
        this.generator.writeBinary(data, offset, len);
    }

    @Override
    public void writeBinary(byte[] data) throws IOException {
        this.generator.writeBinary(data);
    }

    @Override
    public void writeNumber(int v) throws IOException {
        this.generator.writeNumber(v);
    }

    @Override
    public void writeNumber(long v) throws IOException {
        this.generator.writeNumber(v);
    }

    @Override
    public void writeNumber(double d) throws IOException {
        this.generator.writeNumber(d);
    }

    @Override
    public void writeNumber(float f) throws IOException {
        this.generator.writeNumber(f);
    }

    @Override
    public void writeBoolean(boolean state) throws IOException {
        this.generator.writeBoolean(state);
    }

    @Override
    public void writeNull() throws IOException {
        this.generator.writeNull();
    }

    @Override
    public void writeStringField(String fieldName, String value) throws IOException {
        this.generator.writeStringField(fieldName, value);
    }

    @Override
    public void writeStringField(XContentString fieldName, String value) throws IOException {
        this.generator.writeFieldName(fieldName);
        this.generator.writeString(value);
    }

    @Override
    public void writeBooleanField(String fieldName, boolean value) throws IOException {
        this.generator.writeBooleanField(fieldName, value);
    }

    @Override
    public void writeBooleanField(XContentString fieldName, boolean value) throws IOException {
        this.generator.writeFieldName(fieldName);
        this.generator.writeBoolean(value);
    }

    @Override
    public void writeNullField(String fieldName) throws IOException {
        this.generator.writeNullField(fieldName);
    }

    @Override
    public void writeNullField(XContentString fieldName) throws IOException {
        this.generator.writeFieldName(fieldName);
        this.generator.writeNull();
    }

    @Override
    public void writeNumberField(String fieldName, int value) throws IOException {
        this.generator.writeNumberField(fieldName, value);
    }

    @Override
    public void writeNumberField(XContentString fieldName, int value) throws IOException {
        this.generator.writeFieldName(fieldName);
        this.generator.writeNumber(value);
    }

    @Override
    public void writeNumberField(String fieldName, long value) throws IOException {
        this.generator.writeNumberField(fieldName, value);
    }

    @Override
    public void writeNumberField(XContentString fieldName, long value) throws IOException {
        this.generator.writeFieldName(fieldName);
        this.generator.writeNumber(value);
    }

    @Override
    public void writeNumberField(String fieldName, double value) throws IOException {
        this.generator.writeNumberField(fieldName, value);
    }

    @Override
    public void writeNumberField(XContentString fieldName, double value) throws IOException {
        this.generator.writeFieldName(fieldName);
        this.generator.writeNumber(value);
    }

    @Override
    public void writeNumberField(String fieldName, float value) throws IOException {
        this.generator.writeNumberField(fieldName, value);
    }

    @Override
    public void writeNumberField(XContentString fieldName, float value) throws IOException {
        this.generator.writeFieldName(fieldName);
        this.generator.writeNumber(value);
    }

    @Override
    public void writeBinaryField(String fieldName, byte[] data) throws IOException {
        this.generator.writeBinaryField(fieldName, data);
    }

    @Override
    public void writeBinaryField(XContentString fieldName, byte[] value) throws IOException {
        this.generator.writeFieldName(fieldName);
        this.generator.writeBinary(value);
    }

    @Override
    public void writeArrayFieldStart(String fieldName) throws IOException {
        this.generator.writeArrayFieldStart(fieldName);
    }

    @Override
    public void writeArrayFieldStart(XContentString fieldName) throws IOException {
        this.generator.writeFieldName(fieldName);
        this.generator.writeStartArray();
    }

    @Override
    public void writeObjectFieldStart(String fieldName) throws IOException {
        this.generator.writeObjectFieldStart(fieldName);
    }

    @Override
    public void writeObjectFieldStart(XContentString fieldName) throws IOException {
        this.generator.writeFieldName(fieldName);
        this.generator.writeStartObject();
    }

    @Override
    public void writeRawField(String fieldName, byte[] content, OutputStream bos) throws IOException {
        this.generator.writeRaw(", \"");
        this.generator.writeRaw(fieldName);
        this.generator.writeRaw("\" : ");
        this.flush();
        bos.write(content);
    }

    @Override
    public void writeRawField(String fieldName, byte[] content, int offset, int length, OutputStream bos) throws IOException {
        this.generator.writeRaw(", \"");
        this.generator.writeRaw(fieldName);
        this.generator.writeRaw("\" : ");
        this.flush();
        bos.write(content, offset, length);
    }

    @Override
    public void writeRawField(String fieldName, InputStream content, OutputStream bos) throws IOException {
        this.generator.writeRaw(", \"");
        this.generator.writeRaw(fieldName);
        this.generator.writeRaw("\" : ");
        this.flush();
        Streams.copy(content, bos);
    }

    @Override
    public void writeRawField(String fieldName, BytesReference content, OutputStream bos) throws IOException {
        this.generator.writeRaw(", \"");
        this.generator.writeRaw(fieldName);
        this.generator.writeRaw("\" : ");
        this.flush();
        content.writeTo(bos);
    }

    @Override
    public void copyCurrentStructure(XContentParser parser) throws IOException {
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        if (parser instanceof JsonXContentParser) {
            this.generator.copyCurrentStructure(((JsonXContentParser)parser).parser);
        } else {
            XContentHelper.copyCurrentStructure(this, parser);
        }
    }

    @Override
    public void flush() throws IOException {
        this.generator.flush();
    }

    @Override
    public void close() throws IOException {
        this.generator.close();
    }
}

