/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.Set;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.util.Version;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.Analysis;
import org.elasticsearch.index.settings.IndexSettings;

public class StopTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final CharArraySet stopWords;
    private final boolean ignoreCase;
    private final boolean enablePositionIncrements;

    @Inject
    public StopTokenFilterFactory(Index index, @IndexSettings Settings indexSettings, Environment env, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettings, name, settings);
        this.ignoreCase = settings.getAsBoolean("ignore_case", (Boolean)false);
        this.stopWords = Analysis.parseStopWords(env, settings, StopAnalyzer.ENGLISH_STOP_WORDS_SET, this.version, this.ignoreCase);
        this.enablePositionIncrements = settings.getAsBoolean("enable_position_increments", (Boolean)this.version.onOrAfter(Version.LUCENE_30));
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        StopFilter filter = new StopFilter(this.version, tokenStream, this.stopWords);
        filter.setEnablePositionIncrements(this.enablePositionIncrements);
        return filter;
    }

    public Set<?> stopWords() {
        return this.stopWords;
    }

    public boolean ignoreCase() {
        return this.ignoreCase;
    }

    public boolean enablePositionIncrements() {
        return this.enablePositionIncrements;
    }
}

