/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.index.fielddata.LongValues;
import org.elasticsearch.index.fielddata.ScriptDocValues;

public abstract class AtomicNumericFieldData
implements AtomicFieldData<ScriptDocValues> {
    private boolean isFloat;

    public AtomicNumericFieldData(boolean isFloat) {
        this.isFloat = isFloat;
    }

    public abstract LongValues getLongValues();

    public abstract DoubleValues getDoubleValues();

    @Override
    public ScriptDocValues getScriptValues() {
        if (this.isFloat) {
            return new ScriptDocValues.Doubles(this.getDoubleValues());
        }
        return new ScriptDocValues.Longs(this.getLongValues());
    }

    @Override
    public BytesValues getBytesValues() {
        if (this.isFloat) {
            final DoubleValues values = this.getDoubleValues();
            return new BytesValues(values.isMultiValued()){

                @Override
                public boolean hasValue(int docId) {
                    return values.hasValue(docId);
                }

                @Override
                public BytesRef getValueScratch(int docId, BytesRef ret) {
                    if (values.hasValue(docId)) {
                        ret.copyChars((CharSequence)Double.toString(values.getValue(docId)));
                    } else {
                        ret.length = 0;
                    }
                    return ret;
                }

                @Override
                public BytesValues.Iter getIter(int docId) {
                    final DoubleValues.Iter iter = values.getIter(docId);
                    return new BytesValues.Iter(){
                        private final BytesRef spare = new BytesRef();

                        @Override
                        public boolean hasNext() {
                            return iter.hasNext();
                        }

                        @Override
                        public BytesRef next() {
                            this.spare.copyChars((CharSequence)Double.toString(iter.next()));
                            return this.spare;
                        }

                        @Override
                        public int hash() {
                            return this.spare.hashCode();
                        }
                    };
                }
            };
        }
        final LongValues values = this.getLongValues();
        return new BytesValues(values.isMultiValued()){

            @Override
            public boolean hasValue(int docId) {
                return values.hasValue(docId);
            }

            @Override
            public BytesRef getValueScratch(int docId, BytesRef ret) {
                if (values.hasValue(docId)) {
                    ret.copyChars((CharSequence)Long.toString(values.getValue(docId)));
                } else {
                    ret.length = 0;
                }
                return ret;
            }

            @Override
            public BytesValues.Iter getIter(int docId) {
                final LongValues.Iter iter = values.getIter(docId);
                return new BytesValues.Iter(){
                    private final BytesRef spare = new BytesRef();

                    @Override
                    public boolean hasNext() {
                        return iter.hasNext();
                    }

                    @Override
                    public BytesRef next() {
                        this.spare.copyChars((CharSequence)Long.toString(iter.next()));
                        return this.spare;
                    }

                    @Override
                    public int hash() {
                        return this.spare.hashCode();
                    }
                };
            }
        };
    }

    @Override
    public BytesValues getHashedBytesValues() {
        return this.getBytesValues();
    }
}

