/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;

public abstract class BytesValues {
    public static final BytesValues EMPTY = new Empty();
    private boolean multiValued;
    protected final BytesRef scratch = new BytesRef();

    protected BytesValues(boolean multiValued) {
        this.multiValued = multiValued;
    }

    public final boolean isMultiValued() {
        return this.multiValued;
    }

    public abstract boolean hasValue(int var1);

    public BytesRef makeSafe(BytesRef bytes) {
        return BytesRef.deepCopyOf((BytesRef)bytes);
    }

    public BytesRef getValue(int docId) {
        if (this.hasValue(docId)) {
            return this.getValueScratch(docId, this.scratch);
        }
        return null;
    }

    public abstract BytesRef getValueScratch(int var1, BytesRef var2);

    public int getValueHashed(int docId, BytesRef spare) {
        return this.getValueScratch(docId, spare).hashCode();
    }

    public abstract Iter getIter(int var1);

    public static abstract class WithOrdinals
    extends BytesValues {
        protected final Ordinals.Docs ordinals;

        protected WithOrdinals(Ordinals.Docs ordinals) {
            super(ordinals.isMultiValued());
            this.ordinals = ordinals;
        }

        public Ordinals.Docs ordinals() {
            return this.ordinals;
        }

        public BytesRef getValueByOrd(int ord) {
            return this.getValueScratchByOrd(ord, this.scratch);
        }

        protected Iter.Multi newMultiIter() {
            assert (this.isMultiValued());
            return new Iter.Multi(this);
        }

        protected Iter.Single newSingleIter() {
            assert (!this.isMultiValued());
            return new Iter.Single();
        }

        @Override
        public boolean hasValue(int docId) {
            return this.ordinals.getOrd(docId) != 0;
        }

        @Override
        public BytesRef getValue(int docId) {
            int ord = this.ordinals.getOrd(docId);
            if (ord == 0) {
                return null;
            }
            return this.getValueScratchByOrd(ord, this.scratch);
        }

        @Override
        public BytesRef getValueScratch(int docId, BytesRef ret) {
            return this.getValueScratchByOrd(this.ordinals.getOrd(docId), ret);
        }

        public BytesRef getSafeValueByOrd(int ord) {
            return this.getValueScratchByOrd(ord, new BytesRef());
        }

        public abstract BytesRef getValueScratchByOrd(int var1, BytesRef var2);

        public static class Empty
        extends WithOrdinals {
            public Empty(Ordinals.Docs ordinals) {
                super(ordinals);
            }

            @Override
            public BytesRef getValueScratchByOrd(int ord, BytesRef ret) {
                ret.length = 0;
                return ret;
            }

            @Override
            public Iter getIter(int docId) {
                return Iter.Empty.INSTANCE;
            }
        }
    }

    public static class Empty
    extends BytesValues {
        public Empty() {
            super(false);
        }

        @Override
        public boolean hasValue(int docId) {
            return false;
        }

        @Override
        public Iter getIter(int docId) {
            return Iter.Empty.INSTANCE;
        }

        @Override
        public BytesRef getValueScratch(int docId, BytesRef ret) {
            ret.length = 0;
            return ret;
        }
    }

    public static interface Iter {
        public boolean hasNext();

        public BytesRef next();

        public int hash();

        public static class Multi
        implements Iter {
            protected int innerOrd;
            protected int ord;
            protected WithOrdinals withOrds;
            protected Ordinals.Docs.Iter ordsIter;
            protected final BytesRef scratch = new BytesRef();

            public Multi(WithOrdinals withOrds) {
                this.withOrds = withOrds;
                assert (withOrds.isMultiValued());
            }

            public Multi reset(Ordinals.Docs.Iter ordsIter) {
                this.ordsIter = ordsIter;
                this.innerOrd = this.ord = ordsIter.next();
                return this;
            }

            @Override
            public boolean hasNext() {
                return this.innerOrd != 0;
            }

            @Override
            public BytesRef next() {
                this.withOrds.getValueScratchByOrd(this.innerOrd, this.scratch);
                this.ord = this.innerOrd;
                this.innerOrd = this.ordsIter.next();
                return this.scratch;
            }

            @Override
            public int hash() {
                return this.scratch.hashCode();
            }
        }

        public static class Single
        implements Iter {
            protected BytesRef value;
            protected int ord;
            protected boolean done;

            public Single reset(BytesRef value, int ord) {
                this.value = value;
                this.ord = ord;
                this.done = false;
                return this;
            }

            @Override
            public boolean hasNext() {
                return !this.done;
            }

            @Override
            public BytesRef next() {
                assert (!this.done);
                this.done = true;
                return this.value;
            }

            @Override
            public int hash() {
                return this.value.hashCode();
            }
        }

        public static class Empty
        implements Iter {
            public static final Empty INSTANCE = new Empty();

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public BytesRef next() {
                throw new ElasticSearchIllegalStateException();
            }

            @Override
            public int hash() {
                return 0;
            }
        }
    }
}

