/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.io.IOException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.trove.iterator.TObjectLongIterator;
import org.elasticsearch.common.trove.map.hash.TObjectLongHashMap;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class FieldDataStats
implements Streamable,
ToXContent {
    long memorySize;
    long evictions;
    @Nullable
    TObjectLongHashMap<String> fields;

    public FieldDataStats() {
    }

    public FieldDataStats(long memorySize, long evictions, @Nullable TObjectLongHashMap<String> fields) {
        this.memorySize = memorySize;
        this.evictions = evictions;
        this.fields = fields;
    }

    public void add(FieldDataStats stats) {
        this.memorySize += stats.memorySize;
        this.evictions += stats.evictions;
        if (stats.fields != null) {
            if (this.fields == null) {
                this.fields = new TObjectLongHashMap();
            }
            TObjectLongIterator<String> it = stats.fields.iterator();
            while (it.hasNext()) {
                it.advance();
                this.fields.adjustOrPutValue(it.key(), it.value(), it.value());
            }
        }
    }

    public long getMemorySizeInBytes() {
        return this.memorySize;
    }

    public ByteSizeValue getMemorySize() {
        return new ByteSizeValue(this.memorySize);
    }

    public long getEvictions() {
        return this.evictions;
    }

    @Nullable
    public TObjectLongHashMap<String> getFields() {
        return this.fields;
    }

    public static FieldDataStats readFieldDataStats(StreamInput in) throws IOException {
        FieldDataStats stats = new FieldDataStats();
        stats.readFrom(in);
        return stats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.memorySize = in.readVLong();
        this.evictions = in.readVLong();
        if (in.readBoolean()) {
            int size = in.readVInt();
            this.fields = new TObjectLongHashMap(size);
            for (int i = 0; i < size; ++i) {
                this.fields.put(in.readString(), in.readVLong());
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.memorySize);
        out.writeVLong(this.evictions);
        if (this.fields == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeVInt(this.fields.size());
            TObjectLongIterator<String> it = this.fields.iterator();
            while (it.hasNext()) {
                it.advance();
                out.writeString(it.key());
                out.writeVLong(it.value());
            }
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.FIELDDATA);
        builder.field(Fields.MEMORY_SIZE, this.getMemorySize().toString());
        builder.field(Fields.MEMORY_SIZE_IN_BYTES, this.memorySize);
        builder.field(Fields.EVICTIONS, this.getEvictions());
        if (this.fields != null) {
            builder.startObject(Fields.FIELDS);
            TObjectLongIterator<String> it = this.fields.iterator();
            while (it.hasNext()) {
                it.advance();
                builder.startObject(it.key(), XContentBuilder.FieldCaseConversion.NONE);
                builder.field(Fields.MEMORY_SIZE, new ByteSizeValue(it.value()).toString());
                builder.field(Fields.MEMORY_SIZE_IN_BYTES, it.value());
                builder.endObject();
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final XContentBuilderString FIELDDATA = new XContentBuilderString("fielddata");
        static final XContentBuilderString MEMORY_SIZE = new XContentBuilderString("memory_size");
        static final XContentBuilderString MEMORY_SIZE_IN_BYTES = new XContentBuilderString("memory_size_in_bytes");
        static final XContentBuilderString EVICTIONS = new XContentBuilderString("evictions");
        static final XContentBuilderString FIELDS = new XContentBuilderString("fields");

        Fields() {
        }
    }
}

