/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.common.geo.GeoPoint;

public interface GeoPointValues {
    public static final GeoPointValues EMPTY = new Empty();

    public boolean isMultiValued();

    public boolean hasValue(int var1);

    public GeoPoint getValue(int var1);

    public GeoPoint getValueSafe(int var1);

    public Iter getIter(int var1);

    public Iter getIterSafe(int var1);

    public static class Empty
    implements GeoPointValues {
        @Override
        public boolean isMultiValued() {
            return false;
        }

        @Override
        public boolean hasValue(int docId) {
            return false;
        }

        @Override
        public GeoPoint getValueSafe(int docId) {
            return this.getValue(docId);
        }

        @Override
        public Iter getIterSafe(int docId) {
            return this.getIter(docId);
        }

        @Override
        public GeoPoint getValue(int docId) {
            return null;
        }

        @Override
        public Iter getIter(int docId) {
            return Iter.Empty.INSTANCE;
        }
    }

    public static interface Iter {
        public boolean hasNext();

        public GeoPoint next();

        public static class Single
        implements Iter {
            public GeoPoint value;
            public boolean done;

            public Single reset(GeoPoint value) {
                this.value = value;
                this.done = false;
                return this;
            }

            @Override
            public boolean hasNext() {
                return !this.done;
            }

            @Override
            public GeoPoint next() {
                assert (!this.done);
                this.done = true;
                return this.value;
            }
        }

        public static class Empty
        implements Iter {
            public static final Empty INSTANCE = new Empty();

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public GeoPoint next() {
                throw new ElasticSearchIllegalStateException();
            }
        }
    }
}

