/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;

public abstract class LongValues {
    public static final LongValues EMPTY = new Empty();
    private final boolean multiValued;
    protected final Iter.Single iter = new Iter.Single();

    protected LongValues(boolean multiValued) {
        this.multiValued = multiValued;
    }

    public final boolean isMultiValued() {
        return this.multiValued;
    }

    public abstract boolean hasValue(int var1);

    public abstract long getValue(int var1);

    public long getValueMissing(int docId, long missingValue) {
        if (this.hasValue(docId)) {
            return this.getValue(docId);
        }
        return missingValue;
    }

    public Iter getIter(int docId) {
        assert (!this.isMultiValued());
        if (this.hasValue(docId)) {
            return this.iter.reset(this.getValue(docId));
        }
        return Iter.Empty.INSTANCE;
    }

    public static class Filtered
    extends LongValues {
        protected final LongValues delegate;

        public Filtered(LongValues delegate) {
            super(delegate.isMultiValued());
            this.delegate = delegate;
        }

        @Override
        public boolean hasValue(int docId) {
            return this.delegate.hasValue(docId);
        }

        @Override
        public long getValue(int docId) {
            return this.delegate.getValue(docId);
        }

        @Override
        public Iter getIter(int docId) {
            return this.delegate.getIter(docId);
        }
    }

    static class Empty
    extends LongValues {
        public Empty() {
            super(false);
        }

        @Override
        public boolean hasValue(int docId) {
            return false;
        }

        @Override
        public long getValue(int docId) {
            throw new ElasticSearchIllegalStateException("Can't retrieve a value from an empty LongValues");
        }

        @Override
        public Iter getIter(int docId) {
            return Iter.Empty.INSTANCE;
        }
    }

    public static interface Iter {
        public boolean hasNext();

        public long next();

        public static class Multi
        implements Iter {
            private Ordinals.Docs.Iter ordsIter;
            private int ord;
            private WithOrdinals values;

            public Multi(WithOrdinals values) {
                this.values = values;
            }

            public Multi reset(Ordinals.Docs.Iter ordsIter) {
                this.ordsIter = ordsIter;
                this.ord = ordsIter.next();
                return this;
            }

            @Override
            public boolean hasNext() {
                return this.ord != 0;
            }

            @Override
            public long next() {
                long value = this.values.getValueByOrd(this.ord);
                this.ord = this.ordsIter.next();
                return value;
            }
        }

        public static class Single
        implements Iter {
            public long value;
            public boolean done;

            public Single reset(long value) {
                this.value = value;
                this.done = false;
                return this;
            }

            @Override
            public boolean hasNext() {
                return !this.done;
            }

            @Override
            public long next() {
                assert (!this.done);
                this.done = true;
                return this.value;
            }
        }

        public static class Empty
        implements Iter {
            public static final Empty INSTANCE = new Empty();

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public long next() {
                throw new ElasticSearchIllegalStateException();
            }
        }
    }

    public static abstract class WithOrdinals
    extends LongValues {
        protected final Ordinals.Docs ordinals;
        private final Iter.Multi iter;

        protected WithOrdinals(Ordinals.Docs ordinals) {
            super(ordinals.isMultiValued());
            this.ordinals = ordinals;
            this.iter = new Iter.Multi(this);
        }

        public Ordinals.Docs ordinals() {
            return this.ordinals;
        }

        @Override
        public final boolean hasValue(int docId) {
            return this.ordinals.getOrd(docId) != 0;
        }

        @Override
        public final long getValue(int docId) {
            return this.getValueByOrd(this.ordinals.getOrd(docId));
        }

        public abstract long getValueByOrd(int var1);

        @Override
        public final Iter getIter(int docId) {
            return this.iter.reset(this.ordinals.getIter(docId));
        }

        @Override
        public final long getValueMissing(int docId, long missingValue) {
            int ord = this.ordinals.getOrd(docId);
            if (ord == 0) {
                return missingValue;
            }
            return this.getValueByOrd(ord);
        }
    }

    public static abstract class Dense
    extends LongValues {
        protected Dense(boolean multiValued) {
            super(multiValued);
        }

        @Override
        public final boolean hasValue(int docId) {
            return true;
        }

        @Override
        public final long getValueMissing(int docId, long missingValue) {
            assert (this.hasValue(docId));
            assert (!this.isMultiValued());
            return this.getValue(docId);
        }

        @Override
        public final Iter getIter(int docId) {
            assert (this.hasValue(docId));
            assert (!this.isMultiValued());
            return this.iter.reset(this.getValue(docId));
        }
    }
}

