/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.fieldcomparator;

import java.io.IOException;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.fieldcomparator.LongValuesComparatorBase;
import org.elasticsearch.index.fielddata.fieldcomparator.SortMode;

public final class ByteValuesComparator
extends LongValuesComparatorBase<Byte> {
    private final byte[] values;

    public ByteValuesComparator(IndexNumericFieldData<?> indexFieldData, byte missingValue, int numHits, SortMode sortMode) {
        super(indexFieldData, missingValue, sortMode);
        this.values = new byte[numHits];
        assert (indexFieldData.getNumericType().requiredBits() <= 8);
    }

    public int compare(int slot1, int slot2) {
        byte v1 = this.values[slot1];
        byte v2 = this.values[slot2];
        return v1 - v2;
    }

    public void setBottom(int slot) {
        this.bottom = this.values[slot];
    }

    public void copy(int slot, int doc) throws IOException {
        this.values[slot] = (byte)this.readerValues.getValueMissing(doc, this.missingValue);
    }

    public Byte value(int slot) {
        return this.values[slot];
    }

    @Override
    public void add(int slot, int doc) {
        int n = slot;
        this.values[n] = (byte)(this.values[n] + (byte)this.readerValues.getValueMissing(doc, this.missingValue));
    }

    @Override
    public void divide(int slot, int divisor) {
        int n = slot;
        this.values[n] = (byte)(this.values[n] / divisor);
    }

    @Override
    public void missing(int slot) {
        this.values[slot] = (byte)this.missingValue;
    }
}

