/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.fieldcomparator;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.fieldcomparator.SortMode;

public final class BytesRefValComparator
extends FieldComparator<BytesRef> {
    private final IndexFieldData<?> indexFieldData;
    private final SortMode sortMode;
    private final BytesRef[] values;
    private BytesRef bottom;
    private BytesValues docTerms;

    BytesRefValComparator(IndexFieldData<?> indexFieldData, int numHits, SortMode sortMode) {
        this.sortMode = sortMode;
        this.values = new BytesRef[numHits];
        this.indexFieldData = indexFieldData;
    }

    public int compare(int slot1, int slot2) {
        BytesRef val1 = this.values[slot1];
        BytesRef val2 = this.values[slot2];
        return this.compareValues(val1, val2);
    }

    public int compareBottom(int doc) throws IOException {
        BytesRef val2 = this.docTerms.getValue(doc);
        return this.compareValues(this.bottom, val2);
    }

    public void copy(int slot, int doc) throws IOException {
        if (this.values[slot] == null) {
            this.values[slot] = new BytesRef();
        }
        this.docTerms.getValueScratch(doc, this.values[slot]);
    }

    public FieldComparator<BytesRef> setNextReader(AtomicReaderContext context) throws IOException {
        this.docTerms = this.indexFieldData.load(context).getBytesValues();
        if (this.docTerms.isMultiValued()) {
            this.docTerms = new MultiValuedBytesWrapper(this.docTerms, this.sortMode);
        }
        return this;
    }

    public void setBottom(int bottom) {
        this.bottom = this.values[bottom];
    }

    public BytesRef value(int slot) {
        return this.values[slot];
    }

    public int compareValues(BytesRef val1, BytesRef val2) {
        if (val1 == null) {
            if (val2 == null) {
                return 0;
            }
            return -1;
        }
        if (val2 == null) {
            return 1;
        }
        return val1.compareTo(val2);
    }

    public int compareDocToValue(int doc, BytesRef value) {
        return this.docTerms.getValue(doc).compareTo(value);
    }

    private static final class MultiValuedBytesWrapper
    extends FilteredByteValues {
        private final SortMode sortMode;

        public MultiValuedBytesWrapper(BytesValues delegate, SortMode sortMode) {
            super(delegate);
            this.sortMode = sortMode;
        }

        @Override
        public BytesRef getValueScratch(int docId, BytesRef scratch) {
            BytesRef currentVal;
            BytesValues.Iter iter = this.delegate.getIter(docId);
            if (!iter.hasNext()) {
                return null;
            }
            BytesRef relevantVal = currentVal = iter.next();
            while (true) {
                int cmp = currentVal.compareTo(relevantVal);
                if (this.sortMode == SortMode.MAX) {
                    if (cmp > 0) {
                        relevantVal = currentVal;
                    }
                } else if (cmp < 0) {
                    relevantVal = currentVal;
                }
                if (!iter.hasNext()) break;
                currentVal = iter.next();
            }
            return relevantVal;
        }
    }

    public static class FilteredByteValues
    extends BytesValues {
        protected final BytesValues delegate;

        public FilteredByteValues(BytesValues delegate) {
            super(delegate.isMultiValued());
            this.delegate = delegate;
        }

        @Override
        public boolean hasValue(int docId) {
            return this.delegate.hasValue(docId);
        }

        @Override
        public BytesRef makeSafe(BytesRef bytes) {
            return this.delegate.makeSafe(bytes);
        }

        @Override
        public BytesRef getValueScratch(int docId, BytesRef ret) {
            return this.delegate.getValueScratch(docId, ret);
        }

        @Override
        public BytesValues.Iter getIter(int docId) {
            return this.delegate.getIter(docId);
        }
    }
}

