/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.fieldcomparator;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.FieldComparator;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.fieldcomparator.NumberComparatorBase;
import org.elasticsearch.index.fielddata.fieldcomparator.SortMode;

abstract class DoubleValuesComparatorBase<T extends Number>
extends NumberComparatorBase<T> {
    protected final IndexNumericFieldData<?> indexFieldData;
    protected final double missingValue;
    protected double bottom;
    protected DoubleValues readerValues;
    private final SortMode sortMode;

    public DoubleValuesComparatorBase(IndexNumericFieldData<?> indexFieldData, double missingValue, SortMode sortMode) {
        this.indexFieldData = indexFieldData;
        this.missingValue = missingValue;
        this.sortMode = sortMode;
    }

    public final int compareBottom(int doc) throws IOException {
        double v2 = this.readerValues.getValueMissing(doc, this.missingValue);
        return DoubleValuesComparatorBase.compare(this.bottom, v2);
    }

    public final int compareDocToValue(int doc, T valueObj) throws IOException {
        double value = ((Number)valueObj).doubleValue();
        double docValue = this.readerValues.getValueMissing(doc, this.missingValue);
        return DoubleValuesComparatorBase.compare(docValue, value);
    }

    public final FieldComparator<T> setNextReader(AtomicReaderContext context) throws IOException {
        this.readerValues = ((AtomicNumericFieldData)this.indexFieldData.load(context)).getDoubleValues();
        if (this.readerValues.isMultiValued()) {
            this.readerValues = new MultiValueWrapper(this.readerValues, this.sortMode);
        }
        return this;
    }

    @Override
    public int compareBottomMissing() {
        return DoubleValuesComparatorBase.compare(this.bottom, this.missingValue);
    }

    static final int compare(double left, double right) {
        return Double.compare(left, right);
    }

    static final class MultiValueWrapper
    extends DoubleValues.Filtered {
        private final SortMode sortMode;

        public MultiValueWrapper(DoubleValues delegate, SortMode sortMode) {
            super(delegate);
            this.sortMode = sortMode;
        }

        @Override
        public double getValueMissing(int docId, double missing) {
            double currentVal;
            DoubleValues.Iter iter = this.delegate.getIter(docId);
            if (!iter.hasNext()) {
                return missing;
            }
            double relevantVal = currentVal = iter.next();
            int counter = 1;
            while (iter.hasNext()) {
                currentVal = iter.next();
                int cmp = Double.compare(currentVal, relevantVal);
                switch (this.sortMode) {
                    case SUM: {
                        relevantVal += currentVal;
                        break;
                    }
                    case AVG: {
                        relevantVal += currentVal;
                        ++counter;
                        break;
                    }
                    case MIN: {
                        if (cmp >= 0) break;
                        relevantVal = currentVal;
                        break;
                    }
                    case MAX: {
                        if (cmp <= 0) break;
                        relevantVal = currentVal;
                    }
                }
            }
            if (this.sortMode == SortMode.AVG) {
                return relevantVal / (double)counter;
            }
            return relevantVal;
        }
    }
}

