/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.fieldcomparator;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.FieldComparator;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.index.fielddata.AtomicGeoPointFieldData;
import org.elasticsearch.index.fielddata.GeoPointValues;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.fielddata.fieldcomparator.NumberComparatorBase;
import org.elasticsearch.index.fielddata.fieldcomparator.SortMode;

public class GeoDistanceComparator
extends NumberComparatorBase<Double> {
    protected final IndexGeoPointFieldData<?> indexFieldData;
    protected final double lat;
    protected final double lon;
    protected final DistanceUnit unit;
    protected final GeoDistance geoDistance;
    protected final GeoDistance.FixedSourceDistance fixedSourceDistance;
    protected final SortMode sortMode;
    private final double[] values;
    private double bottom;
    private GeoDistanceValues geoDistanceValues;

    public GeoDistanceComparator(int numHits, IndexGeoPointFieldData<?> indexFieldData, double lat, double lon, DistanceUnit unit, GeoDistance geoDistance, SortMode sortMode) {
        this.values = new double[numHits];
        this.indexFieldData = indexFieldData;
        this.lat = lat;
        this.lon = lon;
        this.unit = unit;
        this.geoDistance = geoDistance;
        this.fixedSourceDistance = geoDistance.fixedSourceDistance(lat, lon, unit);
        this.sortMode = sortMode;
    }

    public FieldComparator<Double> setNextReader(AtomicReaderContext context) throws IOException {
        GeoPointValues readerValues = ((AtomicGeoPointFieldData)this.indexFieldData.load(context)).getGeoPointValues();
        this.geoDistanceValues = readerValues.isMultiValued() ? new MV(readerValues, this.fixedSourceDistance, this.sortMode) : new SV(readerValues, this.fixedSourceDistance);
        return this;
    }

    public int compare(int slot1, int slot2) {
        double v1 = this.values[slot1];
        double v2 = this.values[slot2];
        if (v1 > v2) {
            return 1;
        }
        if (v1 < v2) {
            return -1;
        }
        return 0;
    }

    public int compareBottom(int doc) {
        double v2 = this.geoDistanceValues.computeDistance(doc);
        if (this.bottom > v2) {
            return 1;
        }
        if (this.bottom < v2) {
            return -1;
        }
        return 0;
    }

    public int compareDocToValue(int doc, Double distance2) throws IOException {
        double distance1 = this.geoDistanceValues.computeDistance(doc);
        if (distance1 < distance2) {
            return -1;
        }
        if (distance1 == distance2) {
            return 0;
        }
        return 1;
    }

    public void copy(int slot, int doc) {
        this.values[slot] = this.geoDistanceValues.computeDistance(doc);
    }

    public void setBottom(int bottom) {
        this.bottom = this.values[bottom];
    }

    public Double value(int slot) {
        return this.values[slot];
    }

    @Override
    public void add(int slot, int doc) {
        int n = slot;
        this.values[n] = this.values[n] + this.geoDistanceValues.computeDistance(doc);
    }

    @Override
    public void divide(int slot, int divisor) {
        int n = slot;
        this.values[n] = this.values[n] / (double)divisor;
    }

    @Override
    public void missing(int slot) {
        this.values[slot] = Double.MAX_VALUE;
    }

    @Override
    public int compareBottomMissing() {
        return Double.compare(this.bottom, Double.MAX_VALUE);
    }

    private static final class MV
    extends GeoDistanceValues {
        private final SortMode sortMode;

        MV(GeoPointValues readerValues, GeoDistance.FixedSourceDistance fixedSourceDistance, SortMode sortMode) {
            super(readerValues, fixedSourceDistance);
            this.sortMode = sortMode;
        }

        @Override
        public double computeDistance(int doc) {
            GeoPointValues.Iter iter = this.readerValues.getIter(doc);
            if (!iter.hasNext()) {
                return Double.MAX_VALUE;
            }
            GeoPoint point = iter.next();
            double distance = this.fixedSourceDistance.calculate(point.lat(), point.lon());
            int counter = 1;
            while (iter.hasNext()) {
                point = iter.next();
                double newDistance = this.fixedSourceDistance.calculate(point.lat(), point.lon());
                switch (this.sortMode) {
                    case MIN: {
                        if (!(distance > newDistance)) break;
                        distance = newDistance;
                        break;
                    }
                    case MAX: {
                        if (!(distance < newDistance)) break;
                        distance = newDistance;
                        break;
                    }
                    case AVG: {
                        distance += newDistance;
                        ++counter;
                    }
                }
            }
            if (this.sortMode == SortMode.AVG && counter > 1) {
                return distance / (double)counter;
            }
            return distance;
        }
    }

    private static final class SV
    extends GeoDistanceValues {
        SV(GeoPointValues readerValues, GeoDistance.FixedSourceDistance fixedSourceDistance) {
            super(readerValues, fixedSourceDistance);
        }

        @Override
        public double computeDistance(int doc) {
            GeoPoint geoPoint = this.readerValues.getValue(doc);
            if (geoPoint == null) {
                return Double.MAX_VALUE;
            }
            return this.fixedSourceDistance.calculate(geoPoint.lat(), geoPoint.lon());
        }
    }

    private static abstract class GeoDistanceValues {
        protected final GeoPointValues readerValues;
        protected final GeoDistance.FixedSourceDistance fixedSourceDistance;

        protected GeoDistanceValues(GeoPointValues readerValues, GeoDistance.FixedSourceDistance fixedSourceDistance) {
            this.readerValues = readerValues;
            this.fixedSourceDistance = fixedSourceDistance;
        }

        public abstract double computeDistance(int var1);
    }
}

