/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.fieldcomparator;

import java.io.IOException;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.SortField;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.fieldcomparator.IntValuesComparator;
import org.elasticsearch.index.fielddata.fieldcomparator.SortMode;

public class IntValuesComparatorSource
extends IndexFieldData.XFieldComparatorSource {
    private final IndexNumericFieldData<?> indexFieldData;
    private final Object missingValue;
    private final SortMode sortMode;

    public IntValuesComparatorSource(IndexNumericFieldData<?> indexFieldData, @Nullable Object missingValue, SortMode sortMode) {
        this.indexFieldData = indexFieldData;
        this.missingValue = missingValue;
        this.sortMode = sortMode;
    }

    @Override
    public SortField.Type reducedType() {
        return SortField.Type.INT;
    }

    public FieldComparator<?> newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
        assert (fieldname.equals(this.indexFieldData.getFieldNames().indexName()));
        int dMissingValue = this.missingValue == null || "_last".equals(this.missingValue) ? (reversed ? Integer.MIN_VALUE : Integer.MAX_VALUE) : ("_first".equals(this.missingValue) ? (reversed ? Integer.MAX_VALUE : Integer.MIN_VALUE) : (this.missingValue instanceof Number ? ((Number)this.missingValue).intValue() : Integer.parseInt(this.missingValue.toString())));
        return new IntValuesComparator(this.indexFieldData, dMissingValue, numHits, this.sortMode);
    }
}

