/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.fieldcomparator;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.FieldComparator;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.LongValues;
import org.elasticsearch.index.fielddata.fieldcomparator.NumberComparatorBase;
import org.elasticsearch.index.fielddata.fieldcomparator.SortMode;

abstract class LongValuesComparatorBase<T extends Number>
extends NumberComparatorBase<T> {
    protected final IndexNumericFieldData<?> indexFieldData;
    protected final long missingValue;
    protected long bottom;
    protected LongValues readerValues;
    private final SortMode sortMode;

    public LongValuesComparatorBase(IndexNumericFieldData<?> indexFieldData, long missingValue, SortMode sortMode) {
        this.indexFieldData = indexFieldData;
        this.missingValue = missingValue;
        this.sortMode = sortMode;
    }

    public final int compareBottom(int doc) throws IOException {
        long v2 = this.readerValues.getValueMissing(doc, this.missingValue);
        return LongValuesComparatorBase.compare(this.bottom, v2);
    }

    public final int compareDocToValue(int doc, T valueObj) throws IOException {
        long value = ((Number)valueObj).longValue();
        long docValue = this.readerValues.getValueMissing(doc, this.missingValue);
        return LongValuesComparatorBase.compare(docValue, value);
    }

    static final int compare(long left, long right) {
        if (left > right) {
            return 1;
        }
        if (left < right) {
            return -1;
        }
        return 0;
    }

    public final FieldComparator<T> setNextReader(AtomicReaderContext context) throws IOException {
        this.readerValues = ((AtomicNumericFieldData)this.indexFieldData.load(context)).getLongValues();
        if (this.readerValues.isMultiValued()) {
            this.readerValues = new MultiValueWrapper(this.readerValues, this.sortMode);
        }
        return this;
    }

    @Override
    public int compareBottomMissing() {
        return LongValuesComparatorBase.compare(this.bottom, this.missingValue);
    }

    private static final class MultiValueWrapper
    extends LongValues.Filtered {
        private final SortMode sortMode;

        public MultiValueWrapper(LongValues delegate, SortMode sortMode) {
            super(delegate);
            this.sortMode = sortMode;
        }

        @Override
        public long getValueMissing(int docId, long missing) {
            long currentVal;
            LongValues.Iter iter = this.delegate.getIter(docId);
            if (!iter.hasNext()) {
                return missing;
            }
            long relevantVal = currentVal = iter.next();
            int counter = 1;
            while (iter.hasNext()) {
                currentVal = iter.next();
                switch (this.sortMode) {
                    case SUM: {
                        relevantVal += currentVal;
                        break;
                    }
                    case AVG: {
                        relevantVal += currentVal;
                        ++counter;
                        break;
                    }
                    case MAX: {
                        if (currentVal <= relevantVal) break;
                        relevantVal = currentVal;
                        break;
                    }
                    case MIN: {
                        if (currentVal >= relevantVal) break;
                        relevantVal = currentVal;
                    }
                }
            }
            if (this.sortMode == SortMode.AVG) {
                return relevantVal / (long)counter;
            }
            return relevantVal;
        }
    }
}

