/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.ordinals;

import org.apache.lucene.util.IntsRef;
import org.elasticsearch.common.RamUsage;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;

public class DocIdOrdinals
implements Ordinals {
    private final int numDocs;

    public DocIdOrdinals(int numDocs) {
        this.numDocs = numDocs;
    }

    @Override
    public boolean hasSingleArrayBackingStorage() {
        return false;
    }

    @Override
    public Object getBackingStorage() {
        return null;
    }

    @Override
    public long getMemorySizeInBytes() {
        return RamUsage.NUM_BYTES_OBJECT_REF;
    }

    @Override
    public boolean isMultiValued() {
        return false;
    }

    @Override
    public int getNumDocs() {
        return this.numDocs;
    }

    @Override
    public int getNumOrds() {
        return this.numDocs;
    }

    @Override
    public int getMaxOrd() {
        return this.numDocs + 1;
    }

    @Override
    public Ordinals.Docs ordinals() {
        return new Docs(this);
    }

    public static class Docs
    implements Ordinals.Docs {
        private final DocIdOrdinals parent;
        private final IntsRef intsScratch = new IntsRef(new int[1], 0, 1);
        private final Ordinals.Docs.SingleValueIter iter = new Ordinals.Docs.SingleValueIter();

        public Docs(DocIdOrdinals parent) {
            this.parent = parent;
        }

        @Override
        public Ordinals ordinals() {
            return this.parent;
        }

        @Override
        public int getNumDocs() {
            return this.parent.getNumDocs();
        }

        @Override
        public int getNumOrds() {
            return this.parent.getNumOrds();
        }

        @Override
        public int getMaxOrd() {
            return this.parent.getMaxOrd();
        }

        @Override
        public boolean isMultiValued() {
            return false;
        }

        @Override
        public int getOrd(int docId) {
            return docId + 1;
        }

        @Override
        public IntsRef getOrds(int docId) {
            this.intsScratch.ints[0] = docId + 1;
            return this.intsScratch;
        }

        @Override
        public Ordinals.Docs.Iter getIter(int docId) {
            return this.iter.reset(docId + 1);
        }
    }
}

