/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.ordinals;

import org.apache.lucene.util.IntsRef;
import org.elasticsearch.common.RamUsage;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;

public final class MultiFlatArrayOrdinals
implements Ordinals {
    private final int[][] ordinals;
    private final int numDocs;
    private final int numOrds;
    private final int maxOrd;
    private long size = -1L;

    public MultiFlatArrayOrdinals(int[][] ordinals, int numOrds) {
        assert (ordinals.length > 0);
        this.ordinals = ordinals;
        this.numDocs = ordinals[0].length;
        this.numOrds = numOrds;
        this.maxOrd = numOrds + 1;
    }

    @Override
    public boolean hasSingleArrayBackingStorage() {
        return false;
    }

    @Override
    public Object getBackingStorage() {
        return this.ordinals;
    }

    @Override
    public long getMemorySizeInBytes() {
        if (this.size == -1L) {
            long size = 0L;
            size += (long)RamUsage.NUM_BYTES_ARRAY_HEADER;
            for (int[] ordinal : this.ordinals) {
                size += (long)(4 * ordinal.length + RamUsage.NUM_BYTES_ARRAY_HEADER);
            }
            this.size = size;
        }
        return this.size;
    }

    @Override
    public boolean isMultiValued() {
        return true;
    }

    @Override
    public int getNumDocs() {
        return this.numDocs;
    }

    @Override
    public int getNumOrds() {
        return this.numOrds;
    }

    @Override
    public int getMaxOrd() {
        return this.maxOrd;
    }

    @Override
    public Docs ordinals() {
        return new Docs(this, this.ordinals);
    }

    public static class Docs
    implements Ordinals.Docs {
        private final MultiFlatArrayOrdinals parent;
        private final int[][] ordinals;
        private final IterImpl iter;
        private final IntsRef intsScratch;

        public Docs(MultiFlatArrayOrdinals parent, int[][] ordinals) {
            this.parent = parent;
            this.ordinals = ordinals;
            this.iter = new IterImpl(ordinals);
            this.intsScratch = new IntsRef(new int[16], 0, 16);
        }

        @Override
        public Ordinals ordinals() {
            return this.parent;
        }

        @Override
        public int getNumDocs() {
            return this.parent.getNumDocs();
        }

        @Override
        public int getNumOrds() {
            return this.parent.getNumOrds();
        }

        @Override
        public int getMaxOrd() {
            return this.parent.getMaxOrd();
        }

        @Override
        public boolean isMultiValued() {
            return true;
        }

        @Override
        public int getOrd(int docId) {
            return this.ordinals[0][docId];
        }

        @Override
        public IntsRef getOrds(int docId) {
            int i;
            this.intsScratch.offset = 0;
            for (i = 0; i < this.ordinals.length; ++i) {
                int ordinal = this.ordinals[i][docId];
                if (ordinal == 0) {
                    if (i != 0) break;
                    this.intsScratch.length = 0;
                    return this.intsScratch;
                }
                this.intsScratch.grow(i + 1);
                this.intsScratch.ints[i] = ordinal;
            }
            this.intsScratch.length = i;
            return this.intsScratch;
        }

        @Override
        public Ordinals.Docs.Iter getIter(int docId) {
            return this.iter.reset(docId);
        }

        public static class IterImpl
        implements Ordinals.Docs.Iter {
            private final int[][] ordinals;
            private int docId;
            private int i;

            public IterImpl(int[][] ordinals) {
                this.ordinals = ordinals;
            }

            public IterImpl reset(int docId) {
                this.docId = docId;
                this.i = 0;
                return this;
            }

            @Override
            public int next() {
                if (this.i >= this.ordinals.length) {
                    return 0;
                }
                return this.ordinals[this.i++][this.docId];
            }
        }
    }
}

