/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.ordinals;

import org.apache.lucene.util.IntsRef;
import org.elasticsearch.common.RamUsage;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.ordinals.OrdinalsBuilder;
import org.elasticsearch.index.fielddata.ordinals.PositiveIntPool;

public final class SparseMultiArrayOrdinals
implements Ordinals {
    private final int[] lookup;
    private final PositiveIntPool pool;
    private final int numOrds;
    private final int maxOrd;
    private final int numDocs;
    private long size = -1L;

    public SparseMultiArrayOrdinals(OrdinalsBuilder builder, int maxSize) {
        int blockShift = Math.min(SparseMultiArrayOrdinals.floorPow2(builder.getTotalNumOrds() << 1), SparseMultiArrayOrdinals.floorPow2(maxSize));
        this.pool = new PositiveIntPool(Math.max(4, blockShift));
        this.numDocs = builder.maxDoc();
        this.lookup = new int[this.numDocs];
        this.numOrds = builder.getNumOrds();
        this.maxOrd = this.numOrds + 1;
        for (int doc = 0; doc < this.numDocs; ++doc) {
            IntsRef spare = builder.docOrds(doc);
            int size = spare.length;
            if (size == 0) {
                this.lookup[doc] = 0;
                continue;
            }
            if (size == 1) {
                this.lookup[doc] = spare.ints[spare.offset];
                continue;
            }
            int offset = this.pool.put(spare);
            this.lookup[doc] = -offset - 1;
        }
    }

    private static int floorPow2(int number) {
        return 31 - Integer.numberOfLeadingZeros(number);
    }

    @Override
    public boolean hasSingleArrayBackingStorage() {
        return false;
    }

    @Override
    public Object getBackingStorage() {
        return null;
    }

    @Override
    public long getMemorySizeInBytes() {
        if (this.size == -1L) {
            this.size = (long)(RamUsage.NUM_BYTES_ARRAY_HEADER + 4 * this.lookup.length) + this.pool.getMemorySizeInBytes();
        }
        return this.size;
    }

    @Override
    public boolean isMultiValued() {
        return true;
    }

    @Override
    public int getNumDocs() {
        return this.numDocs;
    }

    @Override
    public int getNumOrds() {
        return this.numOrds;
    }

    @Override
    public int getMaxOrd() {
        return this.maxOrd;
    }

    @Override
    public Docs ordinals() {
        return new Docs(this, this.lookup, this.pool);
    }

    static class Docs
    implements Ordinals.Docs {
        private final SparseMultiArrayOrdinals parent;
        private final int[] lookup;
        private final IterImpl iter;
        private final PositiveIntPool pool;
        private final IntsRef spare = new IntsRef(1);

        public Docs(SparseMultiArrayOrdinals parent, int[] lookup, PositiveIntPool pool) {
            this.parent = parent;
            this.lookup = lookup;
            this.pool = pool;
            this.iter = new IterImpl(lookup, pool);
        }

        @Override
        public Ordinals ordinals() {
            return this.parent;
        }

        @Override
        public int getNumDocs() {
            return this.parent.getNumDocs();
        }

        @Override
        public int getNumOrds() {
            return this.parent.getNumOrds();
        }

        @Override
        public int getMaxOrd() {
            return this.parent.getMaxOrd();
        }

        @Override
        public boolean isMultiValued() {
            return true;
        }

        @Override
        public int getOrd(int docId) {
            int pointer = this.lookup[docId];
            if (pointer < 0) {
                return this.pool.getFirstFromOffset(-(pointer + 1));
            }
            return pointer;
        }

        @Override
        public IntsRef getOrds(int docId) {
            this.spare.offset = 0;
            int pointer = this.lookup[docId];
            if (pointer != 0) {
                if (pointer > 0) {
                    this.spare.length = 1;
                    this.spare.ints[0] = pointer;
                    return this.spare;
                }
                this.pool.fill(this.spare, -(pointer + 1));
                return this.spare;
            }
            this.spare.length = 0;
            return this.spare;
        }

        @Override
        public Ordinals.Docs.Iter getIter(int docId) {
            return this.iter.reset(docId);
        }

        class IterImpl
        implements Ordinals.Docs.Iter {
            private final int[] lookup;
            private final PositiveIntPool pool;
            private final IntsRef slice = new IntsRef(1);
            private int valuesOffset;

            public IterImpl(int[] lookup, PositiveIntPool pool) {
                this.lookup = lookup;
                this.pool = pool;
            }

            public IterImpl reset(int docId) {
                int pointer = this.lookup[docId];
                if (pointer < 0) {
                    this.pool.fill(this.slice, -(pointer + 1));
                } else {
                    this.slice.ints[0] = pointer;
                    this.slice.offset = 0;
                    this.slice.length = 1;
                }
                this.valuesOffset = 0;
                return this;
            }

            @Override
            public int next() {
                if (this.valuesOffset >= this.slice.length) {
                    return 0;
                }
                return this.slice.ints[this.slice.offset + this.valuesOffset++];
            }
        }
    }
}

