/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.trove.list.array.TByteArrayList;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.AbstractIndexFieldData;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.fieldcomparator.ByteValuesComparatorSource;
import org.elasticsearch.index.fielddata.fieldcomparator.SortMode;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.ordinals.OrdinalsBuilder;
import org.elasticsearch.index.fielddata.plain.ByteArrayAtomicFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.settings.IndexSettings;

public class ByteArrayIndexFieldData
extends AbstractIndexFieldData<ByteArrayAtomicFieldData>
implements IndexNumericFieldData<ByteArrayAtomicFieldData> {
    public ByteArrayIndexFieldData(Index index, @IndexSettings Settings indexSettings, FieldMapper.Names fieldNames, FieldDataType fieldDataType, IndexFieldDataCache cache) {
        super(index, indexSettings, fieldNames, fieldDataType, cache);
    }

    @Override
    public IndexNumericFieldData.NumericType getNumericType() {
        return IndexNumericFieldData.NumericType.BYTE;
    }

    @Override
    public boolean valuesOrdered() {
        return false;
    }

    @Override
    public ByteArrayAtomicFieldData load(AtomicReaderContext context) {
        try {
            return (ByteArrayAtomicFieldData)this.cache.load(context, this);
        }
        catch (Throwable e) {
            if (e instanceof ElasticSearchException) {
                throw (ElasticSearchException)e;
            }
            throw new ElasticSearchException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteArrayAtomicFieldData loadDirect(AtomicReaderContext context) throws Exception {
        BytesRef term;
        AtomicReader reader = context.reader();
        Terms terms = reader.terms(this.getFieldNames().indexName());
        if (terms == null) {
            return ByteArrayAtomicFieldData.EMPTY;
        }
        final TByteArrayList values = new TByteArrayList();
        values.add((byte)0);
        OrdinalsBuilder builder = new OrdinalsBuilder(terms, reader.maxDoc());
        BytesRefIterator iter = builder.buildFromTerms(builder.wrapNumeric32Bit(terms.iterator(null)), reader.getLiveDocs());
        while ((term = iter.next()) != null) {
            values.add((byte)NumericUtils.prefixCodedToInt((BytesRef)term));
        }
        try {
            Ordinals build = builder.build(this.fieldDataType.getSettings());
            ByteArrayAtomicFieldData byteArrayAtomicFieldData = ByteArrayIndexFieldData.build(reader, this.fieldDataType, builder, build, new BuilderBytes(){

                @Override
                public byte get(int index) {
                    return values.get(index);
                }

                @Override
                public byte[] toArray() {
                    return values.toArray();
                }
            });
            return byteArrayAtomicFieldData;
        }
        finally {
            builder.close();
        }
    }

    static ByteArrayAtomicFieldData build(AtomicReader reader, FieldDataType fieldDataType, OrdinalsBuilder builder, Ordinals build, BuilderBytes values) {
        if (!build.isMultiValued() && IndexFieldData.CommonSettings.removeOrdsOnSingleValue(fieldDataType)) {
            Ordinals.Docs ordinals = build.ordinals();
            byte[] sValues = new byte[reader.maxDoc()];
            int maxDoc = reader.maxDoc();
            for (int i = 0; i < maxDoc; ++i) {
                sValues[i] = values.get(ordinals.getOrd(i));
            }
            FixedBitSet set = builder.buildDocsWithValuesSet();
            if (set == null) {
                return new ByteArrayAtomicFieldData.Single(sValues, reader.maxDoc());
            }
            return new ByteArrayAtomicFieldData.SingleFixedSet(sValues, reader.maxDoc(), set);
        }
        return new ByteArrayAtomicFieldData.WithOrdinals(values.toArray(), reader.maxDoc(), build);
    }

    @Override
    public IndexFieldData.XFieldComparatorSource comparatorSource(@Nullable Object missingValue, SortMode sortMode) {
        return new ByteValuesComparatorSource(this, missingValue, sortMode);
    }

    static interface BuilderBytes {
        public byte get(int var1);

        public byte[] toArray();
    }

    public static class Builder
    implements IndexFieldData.Builder {
        @Override
        public IndexFieldData build(Index index, @IndexSettings Settings indexSettings, FieldMapper.Names fieldNames, FieldDataType type, IndexFieldDataCache cache) {
            return new ByteArrayIndexFieldData(index, indexSettings, fieldNames, type, cache);
        }
    }
}

