/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.common.RamUsage;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.index.fielddata.LongValues;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;

public abstract class DoubleArrayAtomicFieldData
extends AtomicNumericFieldData {
    public static final DoubleArrayAtomicFieldData EMPTY = new Empty();
    protected final double[] values;
    private final int numDocs;
    protected long size = -1L;

    public DoubleArrayAtomicFieldData(double[] values, int numDocs) {
        super(true);
        this.values = values;
        this.numDocs = numDocs;
    }

    @Override
    public void close() {
    }

    @Override
    public int getNumDocs() {
        return this.numDocs;
    }

    public static class Single
    extends DoubleArrayAtomicFieldData {
        public Single(double[] values, int numDocs) {
            super(values, numDocs);
        }

        @Override
        public boolean isMultiValued() {
            return false;
        }

        @Override
        public boolean isValuesOrdered() {
            return false;
        }

        @Override
        public long getMemorySizeInBytes() {
            if (this.size == -1L) {
                this.size = RamUsage.NUM_BYTES_ARRAY_HEADER + this.values.length * 8;
            }
            return this.size;
        }

        @Override
        public LongValues getLongValues() {
            return new LongValues(this.values);
        }

        @Override
        public DoubleValues getDoubleValues() {
            return new DoubleValues(this.values);
        }

        static class DoubleValues
        extends DoubleValues.Dense {
            private final double[] values;

            DoubleValues(double[] values) {
                super(false);
                this.values = values;
            }

            @Override
            public double getValue(int docId) {
                return this.values[docId];
            }
        }

        static class LongValues
        extends LongValues.Dense {
            private final double[] values;

            LongValues(double[] values) {
                super(false);
                this.values = values;
            }

            @Override
            public long getValue(int docId) {
                return (long)this.values[docId];
            }
        }
    }

    public static class SingleFixedSet
    extends DoubleArrayAtomicFieldData {
        private final FixedBitSet set;

        public SingleFixedSet(double[] values, int numDocs, FixedBitSet set) {
            super(values, numDocs);
            this.set = set;
        }

        @Override
        public boolean isMultiValued() {
            return false;
        }

        @Override
        public boolean isValuesOrdered() {
            return false;
        }

        @Override
        public long getMemorySizeInBytes() {
            if (this.size == -1L) {
                this.size = RamUsage.NUM_BYTES_ARRAY_HEADER + this.values.length * 8 + this.set.getBits().length * 8;
            }
            return this.size;
        }

        @Override
        public LongValues getLongValues() {
            return new LongValues(this.values, this.set);
        }

        @Override
        public DoubleValues getDoubleValues() {
            return new DoubleValues(this.values, this.set);
        }

        static class DoubleValues
        extends org.elasticsearch.index.fielddata.DoubleValues {
            private final double[] values;
            private final FixedBitSet set;

            DoubleValues(double[] values, FixedBitSet set) {
                super(false);
                this.values = values;
                this.set = set;
            }

            @Override
            public boolean hasValue(int docId) {
                return this.set.get(docId);
            }

            @Override
            public double getValue(int docId) {
                return this.values[docId];
            }
        }

        static class LongValues
        extends org.elasticsearch.index.fielddata.LongValues {
            private final double[] values;
            private final FixedBitSet set;

            LongValues(double[] values, FixedBitSet set) {
                super(false);
                this.values = values;
                this.set = set;
            }

            @Override
            public boolean hasValue(int docId) {
                return this.set.get(docId);
            }

            @Override
            public long getValue(int docId) {
                return (long)this.values[docId];
            }
        }
    }

    public static class WithOrdinals
    extends DoubleArrayAtomicFieldData {
        private final Ordinals ordinals;

        public WithOrdinals(double[] values, int numDocs, Ordinals ordinals) {
            super(values, numDocs);
            this.ordinals = ordinals;
        }

        @Override
        public boolean isMultiValued() {
            return this.ordinals.isMultiValued();
        }

        @Override
        public boolean isValuesOrdered() {
            return true;
        }

        @Override
        public long getMemorySizeInBytes() {
            if (this.size == -1L) {
                this.size = (long)(8 + RamUsage.NUM_BYTES_ARRAY_HEADER + this.values.length * 8) + this.ordinals.getMemorySizeInBytes();
            }
            return this.size;
        }

        @Override
        public LongValues getLongValues() {
            return new LongValues(this.values, this.ordinals.ordinals());
        }

        @Override
        public DoubleValues getDoubleValues() {
            return new DoubleValues(this.values, this.ordinals.ordinals());
        }

        static class DoubleValues
        extends DoubleValues.WithOrdinals {
            private final double[] values;

            DoubleValues(double[] values, Ordinals.Docs ordinals) {
                super(ordinals);
                this.values = values;
            }

            @Override
            public double getValueByOrd(int ord) {
                return this.values[ord];
            }
        }

        static class LongValues
        extends LongValues.WithOrdinals {
            private final double[] values;

            LongValues(double[] values, Ordinals.Docs ordinals) {
                super(ordinals);
                this.values = values;
            }

            @Override
            public final long getValueByOrd(int ord) {
                return (long)this.values[ord];
            }
        }
    }

    static class Empty
    extends DoubleArrayAtomicFieldData {
        Empty() {
            super(null, 0);
        }

        @Override
        public LongValues getLongValues() {
            return LongValues.EMPTY;
        }

        @Override
        public DoubleValues getDoubleValues() {
            return DoubleValues.EMPTY;
        }

        @Override
        public boolean isMultiValued() {
            return false;
        }

        @Override
        public boolean isValuesOrdered() {
            return false;
        }

        @Override
        public long getMemorySizeInBytes() {
            return 0L;
        }

        @Override
        public BytesValues getBytesValues() {
            return BytesValues.EMPTY;
        }

        @Override
        public ScriptDocValues getScriptValues() {
            return ScriptDocValues.EMPTY;
        }
    }
}

